/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.roles;

import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;

public class RoleDefBuilder
extends DefBuilder {
    private final String name;
    private final Map<SubsetKey, Permission> subsetPermissionMap = new LinkedHashMap<SubsetKey, Permission>();

    public RoleDefBuilder(String name) {
        try {
            RoleDef.checkRoleName(name);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Not a valid role name: " + name);
        }
        this.name = name;
    }

    public void putSubsetPermission(SubsetKey subsetKey, Permission permission) {
        this.subsetPermissionMap.put(subsetKey, permission);
    }

    public RoleDef toRoleDef() {
        int size = this.subsetPermissionMap.size();
        int p = 0;
        RoleDef.SubsetEntry[] subsetEntryArray = new RoleDef.SubsetEntry[size];
        for (Map.Entry<SubsetKey, Permission> entry : this.subsetPermissionMap.entrySet()) {
            subsetEntryArray[p] = RoleUtils.toSubsetEntry(entry.getKey(), entry.getValue());
            ++p;
        }
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        return new InternalRoleDef(this.name, RoleUtils.wrap(subsetEntryArray), titleLabels, attributes);
    }

    public static RoleDefBuilder init(String roleName) {
        return new RoleDefBuilder(roleName);
    }

    private static class InternalRoleDef
    implements RoleDef {
        private final String name;
        private final List<RoleDef.SubsetEntry> subsetEntryList;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalRoleDef(String name, List<RoleDef.SubsetEntry> subsetEntryList, Labels titleLabels, Attributes attributes) {
            this.name = name;
            this.subsetEntryList = subsetEntryList;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public List<RoleDef.SubsetEntry> getSubsetEntryList() {
            return this.subsetEntryList;
        }
    }
}

