/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.AbstractUtilRequestHandler;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RequestHandler
extends AbstractUtilRequestHandler
implements BdfParameters {
    protected final BdfParameters bdfParameters;
    private Map<String, String> storeMap = null;
    private boolean store = false;

    public RequestHandler(BdfParameters bdfParameters, RequestMap requestMap) {
        super(bdfParameters.getBdfServer(), requestMap);
        this.bdfParameters = bdfParameters;
    }

    public RequestHandler disableStore() {
        this.store = false;
        return this;
    }

    public RequestHandler enableStore() {
        this.store = true;
        if (this.storeMap == null) {
            this.storeMap = new LinkedHashMap<String, String>();
        }
        return this;
    }

    @Override
    public BdfUser getBdfUser() {
        return this.bdfParameters.getBdfUser();
    }

    @Override
    public PermissionSummary getPermissionSummary() {
        return this.bdfParameters.getPermissionSummary();
    }

    @Override
    protected void store(String paramName, String paramValue) {
        if (this.store) {
            this.storeMap.put(paramName, paramValue);
        }
    }

    public void store(String storeName) {
        if (this.storeMap != null) {
            this.bdfServer.store(this.getBdfUser(), storeName, this.storeMap);
            this.storeMap.clear();
        }
    }

    public FicheMeta getMandatoryFicheMeta(boolean alternativeError) throws ErrorMessageException {
        int id;
        if (!alternativeError) {
            return this.getMandatoryFicheMeta();
        }
        Corpus corpus = this.getMandatoryCorpus();
        FicheMeta ficheMeta = corpus.getFicheMetaById(id = this.getMandatoryId());
        if (ficheMeta == null) {
            String corpusTitle = FichothequeUtils.getTitle(corpus, this.getWorkingLang());
            throw BdfErrors.error("_ error.unknown.fiche", corpusTitle, id);
        }
        return ficheMeta;
    }

    public static RequestHandler init(BdfParameters bdfParameters, RequestMap requestMap) {
        return new RequestHandler(bdfParameters, requestMap);
    }

    public static RequestHandler cloneHandler(RequestHandler requestHandler) {
        return new RequestHandler(requestHandler.bdfParameters, requestHandler.requestMap);
    }
}

