/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.exportation.transformation.StreamTemplateFactory;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfPictureHandler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.CompilationException;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.ImageXMLPart;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.InsertPart;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertiesOdParser;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertyPart;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.StreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.TemplateCompilerUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fichotheque.Fichotheque;
import net.fichotheque.album.Illustration;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.namespaces.TransformationSpace;
import net.fichotheque.tools.exportation.transformation.TemplateContentDescriptionBuilder;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.css.output.StylesConversionEngine;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.io.Pictures;
import net.mapeadores.opendocument.transform.PictureHandler;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DefaultXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public class PropertiesOdStreamTemplateCompiler
extends StreamTemplateCompiler {
    private static final String TEMPLATE_ODT = "template.odt";
    private static final String CONTENT_XML = "content.xml";
    private static final String STYLES_XML = "styles.xml";
    private static final String MANIFEST_XML = "META-INF/manifest.xml";

    public PropertiesOdStreamTemplateCompiler(BdfServer bdfServer, PathConfiguration pathConfiguration, TemplateKey templateKey, MessageHandler messageHandler) {
        super(bdfServer, pathConfiguration, templateKey, messageHandler);
    }

    @Override
    public StreamTemplateFactory compile(TemplateStorage.Unit storageUnit) throws CompilationException {
        ReadZipEngine readZipEngine = new ReadZipEngine(storageUnit);
        readZipEngine.run();
        PropertiesStreamTemplate streamTemplate = new PropertiesStreamTemplate(readZipEngine, PropertiesOdStreamTemplateCompiler.getTableExportName(storageUnit));
        return new PropertiesStreamTemplateFactory(streamTemplate);
    }

    private static String getTableExportName(TemplateStorage.Unit storageUnit) {
        Attribute attribute = storageUnit.getTemplateDef().getAttributes().getAttribute(TransformationSpace.TABLEEXPORT_KEY);
        if (attribute != null) {
            return attribute.getFirstValue();
        }
        return "";
    }

    private static String cleanFragment(String text) {
        text = text.replace("</fragment>", "");
        text = text.replaceAll("<fragment.*>", "");
        return text;
    }

    private class ReadZipEngine {
        private final TemplateStorage.Unit storageUnit;
        private final Map<String, byte[]> map = new LinkedHashMap<String, byte[]>();
        private String contentString = "";
        private String stylesString = "";
        private String manifestString = "";
        private ElementMaps elementMaps;
        private List<Object> contentPartList;
        private List<Object> stylesPartList;

        private ReadZipEngine(TemplateStorage.Unit storageUnit) {
            this.storageUnit = storageUnit;
        }

        private void run() throws CompilationException {
            this.readZip();
            this.initDefaultElementMaps();
            this.insertDefaultStyles();
            this.contentPartList = this.toPartList(this.contentString);
            this.stylesPartList = this.toPartList(this.stylesString);
        }

        private void readZip() throws CompilationException {
            try (ZipInputStream zis = new ZipInputStream(this.getZipInputStream(PropertiesOdStreamTemplateCompiler.TEMPLATE_ODT));){
                ZipEntry zipEntry;
                TemplateContentDescriptionBuilder templateContentDescriptionBuilder = PropertiesOdStreamTemplateCompiler.this.newTemplateContentDescriptionBuilder(PropertiesOdStreamTemplateCompiler.TEMPLATE_ODT, true, true);
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String name = zipEntry.getName();
                    if (name.equals(PropertiesOdStreamTemplateCompiler.CONTENT_XML)) {
                        this.contentString = IOUtils.toString(zis, "UTF-8");
                        continue;
                    }
                    if (name.equals(PropertiesOdStreamTemplateCompiler.STYLES_XML)) {
                        this.stylesString = IOUtils.toString(zis, "UTF-8");
                        continue;
                    }
                    if (name.equals(PropertiesOdStreamTemplateCompiler.MANIFEST_XML)) {
                        this.manifestString = IOUtils.toString(zis, "UTF-8");
                        continue;
                    }
                    byte[] bytes = IOUtils.toByteArray(zis);
                    this.map.put(name, bytes);
                }
            }
            catch (IOException ioe) {
                PropertiesOdStreamTemplateCompiler.this.addError("_ error.exception.transformation_io", PropertiesOdStreamTemplateCompiler.TEMPLATE_ODT, ioe.getMessage());
                throw new CompilationException();
            }
        }

        private void initDefaultElementMaps() {
            String baseURI = TemplateCompilerUtils.getBaseURI(this.storageUnit.getTemplateKey());
            String stylesCss = "@import url(\"bdf://this/css/_ficheblockelements_odt.css\");";
            this.elementMaps = PropertiesOdStreamTemplateCompiler.this.parseCss(stylesCss, baseURI, "default_styles.css");
        }

        private void insertDefaultStyles() {
            this.stylesString = StylesConversionEngine.insertAllStyles(this.stylesString, this.elementMaps, false);
        }

        private List<Object> toPartList(String xml) throws CompilationException {
            try {
                return PropertiesOdParser.parse(xml);
            }
            catch (ParseException pe) {
                throw new CompilationException();
            }
        }

        private InputStream getZipInputStream(String zipName) throws CompilationException {
            InputStream inputStream;
            try {
                inputStream = TemplateCompilerUtils.getContentInputStream(this.storageUnit, zipName);
            }
            catch (IOException ioe) {
                PropertiesOdStreamTemplateCompiler.this.addError("_ error.exception.transformation_io", zipName, ioe.getMessage());
                throw new CompilationException();
            }
            if (inputStream == null) {
                PropertiesOdStreamTemplateCompiler.this.addError("_ error.empty.transformation.ressource", zipName);
                throw new CompilationException();
            }
            return inputStream;
        }
    }

    private class PropertiesStreamTemplate
    implements StreamTemplate.Properties {
        private final Map<String, byte[]> map;
        private final List<Object> contentPartList;
        private final List<Object> stylesPartList;
        private final String tableExportName;
        private final ElementMaps elementMaps;
        private final String manifestString;

        private PropertiesStreamTemplate(ReadZipEngine readZipEngine, String tableExportName) {
            this.map = readZipEngine.map;
            this.contentPartList = readZipEngine.contentPartList;
            this.stylesPartList = readZipEngine.stylesPartList;
            this.tableExportName = tableExportName;
            this.elementMaps = readZipEngine.elementMaps;
            this.manifestString = readZipEngine.manifestString;
        }

        @Override
        public String getMimeType() {
            return "application/vnd.oasis.opendocument.text";
        }

        @Override
        public String getTableExportName() {
            return this.tableExportName;
        }

        @Override
        public void fill(Cell[] cellArray, OutputStream outputStream) throws IOException {
            BdfPictureHandler pictureHandler = new BdfPictureHandler(PropertiesOdStreamTemplateCompiler.this.bdfServer, PropertiesOdStreamTemplateCompiler.this.pathConfiguration);
            ReplaceEngine replaceEngine = new ReplaceEngine(PropertiesOdStreamTemplateCompiler.this.bdfServer, pictureHandler, this.elementMaps);
            try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
                this.zipOtherFiles(zos);
                this.zipPartList(PropertiesOdStreamTemplateCompiler.CONTENT_XML, this.contentPartList, cellArray, replaceEngine, zos);
                this.zipPartList(PropertiesOdStreamTemplateCompiler.STYLES_XML, this.stylesPartList, cellArray, replaceEngine, zos);
                Pictures pictures = ((PictureHandler)pictureHandler).toPictures();
                this.zipPictures(pictures, zos);
                this.zipManifest(pictures, zos);
            }
        }

        private void zipOtherFiles(ZipOutputStream zos) throws IOException {
            for (Map.Entry<String, byte[]> entry : this.map.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(entry.getKey());
                zos.putNextEntry(zipEntry);
                IOUtils.write(entry.getValue(), (OutputStream)zos);
                zos.closeEntry();
            }
        }

        private void zipPartList(String entryName, List<Object> partList, Cell[] cellArray, ReplaceEngine replaceEngine, ZipOutputStream zos) throws IOException {
            ZipEntry zipEntry = new ZipEntry(entryName);
            zos.putNextEntry(zipEntry);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, "UTF-8"));
            replaceEngine.setWriter(writer);
            replaceEngine.writePartList(partList, cellArray);
            writer.flush();
            zos.closeEntry();
        }

        private void zipPictures(Pictures pictures, ZipOutputStream zos) throws IOException {
            for (Pictures.Entry picture : pictures.getEntryList()) {
                ZipEntry zipEntry = new ZipEntry(picture.getHref());
                zos.putNextEntry(zipEntry);
                picture.getOdSource().writeStream(zos);
            }
        }

        private void zipManifest(Pictures pictures, ZipOutputStream zos) throws IOException {
            int idx;
            String newManifest = this.manifestString;
            List<Pictures.Entry> list = pictures.getEntryList();
            if (!list.isEmpty() && (idx = this.manifestString.indexOf("</manifest:manifest>")) != -1) {
                StringBuilder buf = new StringBuilder(newManifest.substring(0, idx));
                for (Pictures.Entry entry : list) {
                    buf.append("<manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"");
                    buf.append(entry.getHref());
                    buf.append("\"/>");
                }
                buf.append(this.manifestString.substring(idx));
                newManifest = buf.toString();
            }
            ZipEntry zipEntry = new ZipEntry(PropertiesOdStreamTemplateCompiler.MANIFEST_XML);
            zos.putNextEntry(zipEntry);
            IOUtils.write(newManifest, (OutputStream)zos, "UTF-8");
            zos.closeEntry();
        }
    }

    private class PropertiesStreamTemplateFactory
    implements StreamTemplateFactory {
        private final StreamTemplate streamTemplate;

        private PropertiesStreamTemplateFactory(StreamTemplate streamTemplate) {
            this.streamTemplate = streamTemplate;
        }

        @Override
        public StreamTemplate newInstance() {
            return this.streamTemplate;
        }
    }

    private static class ReplaceEngine {
        private final BdfServer bdfServer;
        private final ElementMaps elementMaps;
        private final PictureHandler pictureHandler;
        private final Fichotheque fichotheque;
        private final ImageXMLPart imageXMLPart;
        private final DefaultXMLWriter xmlWriter;
        private Writer writer;

        private ReplaceEngine(BdfServer bdfServer, PictureHandler pictureHandler, ElementMaps elementMaps) {
            this.bdfServer = bdfServer;
            this.pictureHandler = pictureHandler;
            this.fichotheque = bdfServer.getFichotheque();
            this.xmlWriter = new DefaultXMLWriter();
            this.imageXMLPart = new ImageXMLPart(this.xmlWriter, pictureHandler);
            this.elementMaps = elementMaps;
        }

        private void setWriter(Writer writer) {
            this.writer = writer;
            this.xmlWriter.setAppendable(writer);
        }

        private void writePartList(List<Object> partList, Cell[] cellArray) throws IOException {
            for (Object part : partList) {
                if (part instanceof String) {
                    this.write((String)part);
                    continue;
                }
                if (part instanceof InsertPart) {
                    StylesConversionEngine.appendAutomaticStyles(this.writer, this.elementMaps);
                    continue;
                }
                PropertyPart propertyPart = (PropertyPart)part;
                String name = propertyPart.getName();
                boolean done = false;
                for (Cell cell : cellArray) {
                    if (!cell.getColDef().getColName().equals(name)) continue;
                    Object value = cell.getValue();
                    if (value != null) {
                        this.resolve(value, propertyPart);
                    }
                    done = true;
                    break;
                }
                if (done) continue;
                this.write("????");
                this.escape(name);
                this.write("????");
            }
        }

        private void resolve(Object value, PropertyPart propertyPart) throws IOException {
            switch (propertyPart.getMode()) {
                case "raw": {
                    this.writeRaw(value, false);
                    break;
                }
                case "fragment": {
                    this.writeRaw(value, true);
                    break;
                }
                case "image": {
                    this.writeImage(value, propertyPart);
                    break;
                }
                default: {
                    this.writeDefault(value);
                }
            }
        }

        private void writeRaw(Object value, boolean removeFragment) throws IOException {
            String stringValue = value.toString();
            if (removeFragment) {
                stringValue = PropertiesOdStreamTemplateCompiler.cleanFragment(stringValue);
            }
            stringValue = this.pictureHandler.check(stringValue);
            this.writer.write(stringValue);
        }

        private void writeDefault(Object value) throws IOException {
            if (value instanceof String) {
                String[] tokens = StringUtils.getLineTokens((String)value, (short)0);
                boolean next = false;
                for (String token : tokens) {
                    if (next) {
                        this.writer.write("<text:line-break/>");
                    } else {
                        next = true;
                    }
                    XMLUtils.writeEscape((Appendable)this.writer, token);
                }
            } else {
                XMLUtils.writeEscape((Appendable)this.writer, value.toString());
            }
        }

        private void write(String text) throws IOException {
            this.writer.write(text);
        }

        private void escape(String text) throws IOException {
            XMLUtils.writeEscape((Appendable)this.writer, text);
        }

        private void writeImage(Object value, PropertyPart propertyPart) throws IOException {
            String[] tokens;
            String stringValue = value.toString();
            for (String token : tokens = StringUtils.getTechnicalTokens(stringValue, true)) {
                try {
                    Illustration illustration = (Illustration)FichothequeUtils.parseGlobalId(token, this.fichotheque, (short)5, null);
                    if (illustration == null) continue;
                    this.imageXMLPart.write(illustration, propertyPart);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

