/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.namespaces.CellSpace;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.api.namespaces.RoleSpace;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.FilterParameters;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.SubsetExtractDef;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.LiageTest;
import net.fichotheque.namespaces.ExtractionSpace;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.extraction.builders.CorpusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.ExtractionBuilderUtils;
import net.fichotheque.tools.extraction.builders.ExtractionDefBuilder;
import net.fichotheque.tools.extraction.builders.FicheFilterBuilder;
import net.fichotheque.tools.extraction.builders.FilterParametersBuilder;
import net.fichotheque.tools.extraction.builders.MotcleFilterBuilder;
import net.fichotheque.tools.extraction.builders.ThesaurusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.TitleClauseBuilder;
import net.fichotheque.tools.selection.CroisementConditionBuilder;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FilterUnits;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.TransformationUtils;
import net.fichotheque.utils.selection.RangeConditionBuilder;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.primitives.Ranges;

public final class DefaultExtractionDefFactory {
    private static final Predicate<UiComponent> STANDARD_PREDICATE = new ExtractionComponentPredicate(UiUtils.ALL_COMPONENTPREDICATE);
    private static final Predicate<UiComponent> WITH_SATELLITES_PREDICATE = new ExtractionComponentPredicate(UiUtils.MAIN_COMPONENTPREDICATE);
    private static final Predicate<UiComponent> SATELLITE_PREDICATE = new ExtractionComponentPredicate(UiUtils.SATELLITE_COMPONENTPREDICATE);

    private DefaultExtractionDefFactory() {
    }

    public static ExtractionDef newInstance(BdfServer bdfServer, TransformationKey transformationKey, Attributes attributes) {
        if (transformationKey.isCorpusTransformationKey()) {
            return DefaultExtractionDefFactory.getFicheExtractionDef(bdfServer, transformationKey.toCorpusKey(), attributes);
        }
        switch (transformationKey.getKeyString()) {
            case "compilation": {
                return DefaultExtractionDefFactory.getCompilationExtractionDef(bdfServer, attributes);
            }
            case "statthesaurus": {
                MotcleFilter thesaurusFilter = MotcleFilterBuilder.init((short)1).setWithIcon(true).setWithLabels(true).addDefaultCorpusExtractDef().setChildrenRecursive().toMotcleFilter();
                return ExtractionDefBuilder.init().setDynamicThesaurusExtractDef(ThesaurusExtractDefBuilder.init(thesaurusFilter).setBoolean("withthesaurustitle", true).toThesaurusExtractDef()).toExtractionDef();
            }
        }
        return null;
    }

    private static ExtractionDef getCompilationExtractionDef(BdfServer bdfServer, Attributes attributes) {
        ExtractionDefBuilder extractionDefBuilder = new ExtractionDefBuilder();
        for (Corpus corpus : BdfTransformationUtils.getCorpusList(bdfServer.getFichotheque(), attributes)) {
            Converter converter = new Converter(bdfServer, corpus);
            FicheFilter ficheFilter = converter.convertUiComponentList(DefaultExtractionDefFactory.STANDARD_PREDICATE).add(FilterUnits.CHRONO_FILTERUNIT).add(FilterUnits.FICHEPHRASE_FILTERUNIT).toFicheFilter();
            FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus(corpus).toFicheQuery();
            CorpusExtractDef corpusExtractDef = CorpusExtractDefBuilder.init(ficheFilter).setClause("title", TitleClauseBuilder.DEFAULT).setEntryList(SelectionUtils.toFicheConditionEntry(ficheQuery)).toCorpusExtractDef();
            extractionDefBuilder.addStatic(corpusExtractDef);
        }
        return extractionDefBuilder.toExtractionDef();
    }

    private static ExtractionDef getFicheExtractionDef(BdfServer bdfServer, SubsetKey corpusKey, Attributes attributes) {
        Converter converter;
        List includedSatelliteList = (converter = new Converter(bdfServer, corpusKey)).getIncludeSatelliteList();
        FicheFilterBuilder builder = converter.convertUiComponentList(includedSatelliteList.isEmpty() ? DefaultExtractionDefFactory.STANDARD_PREDICATE : DefaultExtractionDefFactory.WITH_SATELLITES_PREDICATE).add(FilterUnits.CHRONO_FILTERUNIT).add(FilterUnits.FICHEPHRASE_FILTERUNIT);
        for (Corpus satellite : includedSatelliteList) {
            Converter satelliteConverter = new Converter(bdfServer, satellite);
            FicheFilter satelliteFicheFilter = satelliteConverter.convertUiComponentList(DefaultExtractionDefFactory.SATELLITE_PREDICATE).toFicheFilter();
            builder.add(FilterUnits.ficheParentage(satelliteFicheFilter, ExtractionUtils.EMPTY_FILTERPARAMETERS, Collections.singleton(satellite.getSubsetKey())));
        }
        TagNameInfo tagNameInfo = DefaultExtractionDefFactory.getDynamicTagNameInfo(attributes);
        return ExtractionDefBuilder.init().setDynamicCorpusExtractDef(CorpusExtractDefBuilder.init(builder.toFicheFilter()).setTagNameInfo(tagNameInfo).toCorpusExtractDef()).toExtractionDef();
    }

    private static TagNameInfo getDynamicTagNameInfo(Attributes initAttributes) {
        int extractVersion = TransformationUtils.getExtractVersion(initAttributes);
        if (extractVersion == 1) {
            return TagNameInfo.DEFAULT;
        }
        return TagNameInfo.NULL;
    }

    private static class Converter {
        protected final BdfServer bdfServer;
        protected final Corpus corpus;
        protected final UiComponents uiComponents;
        protected final Fichotheque fichotheque;

        private Converter(BdfServer bdfServer, Corpus corpus) {
            this.bdfServer = bdfServer;
            this.corpus = corpus;
            this.uiComponents = bdfServer.getUiManager().getMainUiComponents(corpus);
            this.fichotheque = bdfServer.getFichotheque();
        }

        private Converter(BdfServer bdfServer, SubsetKey subsetKey) {
            this(bdfServer, (Corpus)bdfServer.getFichotheque().getSubset(subsetKey));
        }

        private List<Corpus> getIncludeSatelliteList() {
            return BdfServerUtils.getIncludeSatelliteList(this.corpus);
        }

        private FicheFilterBuilder convertUiComponentList(Predicate<UiComponent> predicate) {
            FicheFilterBuilder builder = FicheFilterBuilder.init();
            for (UiComponent uiComponent : this.uiComponents.getUiComponentList()) {
                if (!predicate.test(uiComponent)) continue;
                FilterParameters filterParameters = this.initFilterParametersBuilder(uiComponent).toFilterParameters();
                this.convertUiComponent(builder, uiComponent, filterParameters);
            }
            return builder;
        }

        protected void convertUiComponent(FicheFilterBuilder builder, UiComponent uiComponent, FilterParameters filterParameters) {
            if (uiComponent instanceof FieldUi) {
                builder.add(FilterUnits.fieldKey(((FieldUi)uiComponent).getFieldKey(), filterParameters));
            } else if (uiComponent instanceof SpecialIncludeUi) {
                switch (uiComponent.getName()) {
                    case "liage": {
                        builder.add(FilterUnits.corpusExtract(this.getLiageCorpusExtractDef(), filterParameters));
                        break;
                    }
                    case "parentage": {
                        Subset masterSubset = this.corpus.getMasterSubset();
                        if (masterSubset != null && masterSubset instanceof Thesaurus) {
                            MotcleFilter motcleFilter = MotcleFilterBuilder.init((short)1).setWithIcon(true).setWithLabels(true).setWithFicheStylePhrase(((Thesaurus)masterSubset).getThesaurusMetadata().isWithFicheStyle()).toMotcleFilter();
                            builder.add(FilterUnits.masterMotcle(motcleFilter, filterParameters));
                        }
                        builder.add(FilterUnits.ficheParentage(ExtractionXMLUtils.TITLE_FICHEFILTER, filterParameters, FichothequeUtils.EMPTY_SUBSETKEYLIST));
                    }
                }
            } else if (uiComponent instanceof SubsetIncludeUi) {
                this.convertSubsetIncludeUi(builder, (SubsetIncludeUi)uiComponent, filterParameters);
            } else if (uiComponent instanceof DataUi) {
                DataUi dataUi = (DataUi)uiComponent;
                builder.add(FilterUnits.data(dataUi.getDataName(), filterParameters));
            }
        }

        private void convertSubsetIncludeUi(FicheFilterBuilder builder, SubsetIncludeUi subsetIncludeUi, FilterParameters filterParameters) {
            ExtendedIncludeKey includeKey = subsetIncludeUi.getExtendedIncludeKey();
            if (subsetIncludeUi.isFicheTable()) {
                FicheTableConverter ficheTableConverter = new FicheTableConverter(this.bdfServer, includeKey.getSubsetKey(), subsetIncludeUi);
                FicheFilter ficheFilter = ficheTableConverter.convertFicheTable().add(FilterUnits.FICHEPHRASE_FILTERUNIT).toFicheFilter();
                CorpusExtractDef extractDef = ExtractionBuilderUtils.getCorpusExtractDef(includeKey, ficheFilter);
                builder.add(FilterUnits.corpusExtract(extractDef, filterParameters));
            } else if (filterParameters.isEmpty()) {
                builder.add(ExtractionBuilderUtils.getDefaultFilterUnit(includeKey, this.fichotheque));
            } else {
                SubsetExtractDef extractDef = ExtractionBuilderUtils.getDefaultExtractDef(includeKey, this.fichotheque);
                builder.add(FilterUnits.subsetExtract(extractDef, filterParameters));
            }
        }

        private CorpusExtractDef getLiageCorpusExtractDef() {
            CorpusExtractDefBuilder builder = CorpusExtractDefBuilder.init(ExtractionXMLUtils.TITLE_FICHEFILTER).setName("liage");
            ArrayList<FicheCondition.Entry> entryList = new ArrayList<FicheCondition.Entry>();
            ArrayList<SubsetKey> excludeList = new ArrayList<SubsetKey>();
            LiageTest liageTest = UiUtils.checkLiageTest(this.uiComponents);
            for (Corpus otherCorpus : this.fichotheque.getCorpusList()) {
                SubsetKey otherKey = otherCorpus.getSubsetKey();
                Object testResult = liageTest.ownsToLiage(otherKey);
                if (testResult instanceof Ranges) {
                    Ranges excludeRanges = (Ranges)testResult;
                    FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus(otherKey).toFicheQuery();
                    CroisementCondition croisementCondition = CroisementConditionBuilder.init().addLienMode("").setWeightRangeCondition(RangeConditionBuilder.init(excludeRanges).setExclude(true).toRangeCondition()).toCroisementCondition();
                    entryList.add(SelectionUtils.toFicheConditionEntry(ficheQuery, croisementCondition, false));
                    excludeList.add(otherKey);
                    continue;
                }
                Boolean bool = (Boolean)testResult;
                if (bool.booleanValue()) continue;
                excludeList.add(otherKey);
            }
            FicheQueryBuilder globalBuilder = FicheQueryBuilder.init();
            if (!excludeList.isEmpty()) {
                globalBuilder.setExclude(true).addCorpus(excludeList);
            }
            entryList.add(SelectionUtils.toFicheConditionEntry(globalBuilder.toFicheQuery(), SelectionUtils.toCroisementCondition("", -1), false));
            builder.setEntryList(entryList);
            return builder.toCorpusExtractDef();
        }

        protected FilterParametersBuilder initFilterParametersBuilder(UiComponent uiComponent) {
            Attribute roles;
            FilterParametersBuilder filterParametersBuilder = new FilterParametersBuilder();
            Attributes componentAttributes = uiComponent.getAttributes();
            String extractionSpace = ExtractionSpace.EXTRACTION_NAMESPACE.toString();
            for (Attribute attribute : componentAttributes) {
                AttributeKey attributeKey = attribute.getAttributeKey();
                if (!attributeKey.getNameSpace().equals(extractionSpace)) continue;
                filterParametersBuilder.appendValues(attributeKey.getLocalKey(), attribute);
            }
            Attribute groups = componentAttributes.getAttribute(FicheFormSpace.GROUPS_ATTRIBUTEKEY);
            if (groups != null) {
                filterParametersBuilder.appendValues("groups", groups);
            }
            if ((roles = componentAttributes.getAttribute(RoleSpace.READ_KEY)) != null) {
                filterParametersBuilder.appendValues("roles", roles);
            }
            switch (uiComponent.getStatus()) {
                case "optional": 
                case "obsolete": {
                    filterParametersBuilder.appendValue("hide", "empty");
                    break;
                }
                case "mandatory": {
                    filterParametersBuilder.appendValue("hide", "never");
                }
            }
            return filterParametersBuilder;
        }
    }

    private static class ExtractionComponentPredicate
    implements Predicate<UiComponent> {
        private final Predicate<UiComponent> rootPredicate;

        private ExtractionComponentPredicate(Predicate<UiComponent> rootPredicate) {
            this.rootPredicate = rootPredicate;
        }

        @Override
        public boolean test(UiComponent uiComponent) {
            if (uiComponent instanceof CommentUi) {
                return false;
            }
            return this.rootPredicate.test(uiComponent);
        }
    }

    private static class FicheTableConverter
    extends Converter {
        private final SubsetIncludeUi parentComponent;

        private FicheTableConverter(BdfServer bdfServer, SubsetKey subsetKey, SubsetIncludeUi parentComponent) {
            super(bdfServer, subsetKey);
            this.parentComponent = parentComponent;
        }

        private FicheFilterBuilder convertFicheTable() {
            FicheFilterBuilder builder = FicheFilterBuilder.init();
            List<UiComponent> cellList = UiUtils.filterFicheTableUiComponents(this.uiComponents, this.parentComponent.getSubsetKey());
            int defaultOrder = 1;
            for (UiComponent uiComponent : cellList) {
                FilterParametersBuilder parametersBuilder = this.initFilterParametersBuilder(uiComponent);
                this.checkCellAttributes(uiComponent, parametersBuilder, defaultOrder);
                ++defaultOrder;
                this.convertUiComponent(builder, uiComponent, parametersBuilder.toFilterParameters());
            }
            return builder;
        }

        private void checkCellAttributes(UiComponent uiComponent, FilterParametersBuilder parametersBuilder, int defaultOrder) {
            Attribute formatAttribute;
            Attributes attributes = uiComponent.getAttributes();
            Attribute orderAttribute = attributes.getAttribute(CellSpace.ORDER_KEY);
            boolean orderDone = false;
            if (orderAttribute != null) {
                try {
                    int value = Integer.parseInt(orderAttribute.getFirstValue());
                    if (value > 0) {
                        parametersBuilder.appendValue("cell-order", String.valueOf(value));
                        orderDone = true;
                    }
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
            }
            if ((formatAttribute = attributes.getAttribute(CellSpace.FORMAT_KEY)) != null) {
                parametersBuilder.appendValue("cell-format", formatAttribute.getFirstValue());
            }
            if (!orderDone) {
                parametersBuilder.appendValue("cell-order", String.valueOf(defaultOrder));
            }
        }
    }
}

