/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.session.LoginException;
import fr.exemole.bdfserver.api.session.LoginParameters;
import fr.exemole.bdfserver.html.LoginHtmlProducer;
import fr.exemole.bdfserver.jsonproducers.session.PingJsonProducer;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.session.LoginParametersBuilder;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.text.StringUtils;

public final class LoginEngine {
    private LoginEngine() {
    }

    public static ResponseHandler resolveLoginException(BdfServer bdfServer, RequestMap requestMap, String pathInfo, BdfInstruction bdfInstruction, LoginException loginException) {
        if (BdfInstructionUtils.isJsonOutput(bdfInstruction) || RequestUtils.isJsonDefined(requestMap)) {
            return LoginEngine.getJsonResponseHandler(bdfServer, requestMap, loginException);
        }
        return HtmlResponseHandler.init(LoginEngine.getHtmlProducer(bdfServer, requestMap, pathInfo, bdfInstruction, loginException));
    }

    private static JsonResponseHandler getJsonResponseHandler(BdfServer bdfServer, RequestMap requestMap, LoginException loginException) {
        LangPreference langPreference = BdfInstructionUtils.getLangPreference(requestMap, bdfServer);
        MessageLocalisation messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(langPreference);
        PingJsonProducer jsonProducer = PingJsonProducer.unauthentified(messageLocalisation, LogUtils.error(loginException.getErrorMessageKey(), new Object[0]));
        return JsonResponseHandler.build(jsonProducer, requestMap).giveAccess(requestMap);
    }

    private static HtmlProducer getHtmlProducer(BdfServer bdfServer, RequestMap requestMap, String pathInfo, BdfInstruction bdfInstruction, LoginException loginException) {
        HtmlProducer customHtmlProducer = (HtmlProducer)bdfInstruction.getLoginOption("htmlproducer");
        if (customHtmlProducer != null) {
            return customHtmlProducer;
        }
        LangPreference langPreference = BdfInstructionUtils.getLangPreference(requestMap, bdfServer);
        LoginParameters loginParameters = (LoginParameters)bdfInstruction.getLoginOption("loginparameters");
        if (loginParameters == null) {
            loginParameters = LoginEngine.buildLoginParameters(requestMap, pathInfo, bdfInstruction, loginException);
        }
        return new LoginHtmlProducer(bdfServer, langPreference, loginParameters);
    }

    private static LoginParameters buildLoginParameters(RequestMap requestMap, String pathInfo, BdfInstruction bdfInstruction, LoginException loginException) {
        int idx = pathInfo.lastIndexOf(47);
        String formAction = idx == -1 ? pathInfo.toLowerCase() : pathInfo.substring(idx + 1).toLowerCase();
        if (formAction.length() == 0) {
            formAction = ".";
        }
        CommandMessage sessionMessage = LoginEngine.getSessionMessage(bdfInstruction, loginException, formAction, requestMap);
        if (!formAction.equals(".")) {
            formAction = "./" + formAction;
        }
        SubsetKey defaultSphereKey = LoginEngine.getDefaultSphereKey(bdfInstruction);
        LoginParametersBuilder builder = LoginParametersBuilder.init().setFormAction(formAction).setReversePath(StringUtils.getReversePath(pathInfo)).setLoginException(loginException).setRequestMap(requestMap).setCommandMessage(sessionMessage).setTitlePhraseName((String)bdfInstruction.getLoginOption("titlephrasename")).setDefaultSphereKey(defaultSphereKey);
        LoginEngine.populateAvailableSpheres(builder, bdfInstruction);
        return builder.toLoginParameters();
    }

    private static CommandMessage getSessionMessage(BdfInstruction bdfInstruction, LoginException loginException, String formAction, RequestMap requestMap) {
        CommandMessage sessionMessage = (CommandMessage)bdfInstruction.getLoginOption("sessionmessage");
        if (sessionMessage != null) {
            return sessionMessage;
        }
        if (loginException.getErrorMessageKey().equals(LoginException.EXIT_ERROR)) {
            return LogUtils.done("_ info.session.newsession", new Object[0]);
        }
        if (formAction.equals(".") || formAction.equals("session") || formAction.equals("index.html") || formAction.startsWith("app-")) {
            return LogUtils.done("_ info.session.newsession", new Object[0]);
        }
        if (formAction.indexOf(46) != -1) {
            return LogUtils.done("_ warning.session.protectedcontent", new Object[0]);
        }
        if (requestMap.getParameter("cmd") != null) {
            return LogUtils.done("_ warning.session.expiredsession", new Object[0]);
        }
        return LogUtils.done("_ info.session.newsession", new Object[0]);
    }

    private static SubsetKey getDefaultSphereKey(BdfInstruction bdfInstruction) {
        SubsetKey defaultSphereKey = null;
        String defaultSphereObj = (String)bdfInstruction.getLoginOption("defaultsphere");
        if (defaultSphereObj != null) {
            if (defaultSphereObj instanceof String) {
                try {
                    defaultSphereKey = SubsetKey.parse((short)3, defaultSphereObj);
                }
                catch (ParseException parseException) {}
            } else if (defaultSphereObj instanceof SubsetKey && !(defaultSphereKey = (SubsetKey)((Object)defaultSphereObj)).isSphereSubset()) {
                defaultSphereKey = null;
            }
        }
        return defaultSphereKey;
    }

    private static LoginParametersBuilder populateAvailableSpheres(LoginParametersBuilder builder, BdfInstruction bdfInstruction) {
        Object obj = bdfInstruction.getLoginOption("availablespheres");
        if (obj != null && obj instanceof String[]) {
            String[] array;
            for (String name : array = (String[])obj) {
                try {
                    builder.addLoginSphereKey(name);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return builder;
    }
}

