/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.xml;

import fr.exemole.bdfserver.multi.api.central.CentralUser;
import java.io.IOException;
import java.util.Locale;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class CentralUserXMLPart
extends XMLPart {
    public CentralUserXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendCentralUser(CentralUser centralUser) throws IOException {
        this.startOpenTag("central-user");
        this.addAttribute("status", centralUser.getStatus());
        this.endOpenTag();
        this.appendPersonCore(centralUser.getPerson());
        EmailCore emailCore = centralUser.getEmail();
        if (emailCore != null) {
            this.appendEmailCore(emailCore);
        }
        this.addSimpleElement("password", centralUser.getEncryptedPassword());
        this.appendLangContext(centralUser);
        AttributeUtils.addAttributes(this, centralUser.getAttributes());
        this.closeTag("central-user");
    }

    private void appendPersonCore(PersonCore personCore) throws IOException {
        this.startOpenTag("person");
        if (personCore.isSurnameFirst()) {
            this.addAttribute("surname-first", "true");
        }
        this.addAttribute("surname", personCore.getSurname());
        this.addAttribute("forename", personCore.getForename());
        this.addAttribute("nonlatin", personCore.getNonlatin());
        this.closeEmptyTag();
    }

    private void appendEmailCore(EmailCore emailCore) throws IOException {
        this.startOpenTag("email");
        this.addAttribute("addr-spec", emailCore.getAddrSpec());
        this.addAttribute("real-name", emailCore.getRealName());
        this.closeEmptyTag();
    }

    private void appendLangContext(CentralUser centralUser) throws IOException {
        LangPreference customLangPreference;
        UserLangContext userLangContext = centralUser.getUserLangContext();
        this.addSimpleElement("lang", userLangContext.getWorkingLang().toString());
        Locale customFormatLocale = centralUser.getCustomFormatLocale();
        if (customFormatLocale != null) {
            this.addSimpleElement("format-locale", Lang.toISOString(customFormatLocale));
        }
        if ((customLangPreference = centralUser.getCustomLangPreference()) != null) {
            this.openTag("lang-preference");
            for (Lang lang : customLangPreference) {
                this.addSimpleElement("lang", lang.toString());
            }
            this.closeTag("lang-preference");
        }
    }
}

