/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.misc;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.json.HistoryJson;
import java.io.IOException;
import java.util.LinkedHashSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.history.HistoryUnit;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;

public class HistoryJsonProducer
implements JsonProducer {
    private final BdfServer bdfServer;
    private final HistoryUnit history;

    public HistoryJsonProducer(BdfParameters bdfParameters, HistoryUnit history) {
        this.bdfServer = bdfParameters.getBdfServer();
        this.history = history;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        LinkedHashSet<String> globalIdSet = new LinkedHashSet<String>();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("history");
        jw.object();
        jw.key("deleted").value(this.history.isDeleted());
        jw.key("revisionArray");
        jw.array();
        for (HistoryUnit.Revision revision : this.history.getRevisionList()) {
            jw.object();
            HistoryJson.properties(jw, revision, globalIdSet);
            jw.endObject();
        }
        jw.endArray();
        HistoryJson.userMapProperty(jw, fichotheque, globalIdSet);
        jw.endObject();
        jw.endObject();
    }
}

