/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.docstream.DocStreamFactory;
import java.io.IOException;
import java.net.URI;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class StreamTextJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final URI uri;
    private String path;
    private String extension = "";

    public StreamTextJsonProperty(BdfServer bdfServer, URI uri) {
        this.bdfServer = bdfServer;
        this.uri = uri;
        this.path = uri.getPath();
        if (this.path == null || this.path.length() == 1) {
            throw new IllegalArgumentException("uri.getPath is null");
        }
        this.path = this.path.substring(1);
        int idx = this.path.lastIndexOf(46);
        if (idx != -1) {
            this.extension = this.path.substring(idx + 1);
        }
    }

    @Override
    public String getName() {
        return "streamText";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.object();
        jw.key("extension").value(this.extension);
        jw.key("path").value(this.path);
        jw.key("content").value(this.getBdfResourceContent());
        jw.endObject();
    }

    private String getBdfResourceContent() {
        DocStream docStream = DocStreamFactory.buildDocStream(this.bdfServer, this.uri);
        if (docStream == null) {
            return "";
        }
        return docStream.getContent();
    }
}

