/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.api.storage.RedacteurListStorage;
import fr.exemole.bdfserver.api.storage.RoleStorage;
import fr.exemole.bdfserver.api.storage.StorageCheck;
import fr.exemole.bdfserver.impl.RoleImpl;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.text.StringUtils;

class PermissionManagerImpl
implements PermissionManager {
    private static final List<Redacteur> EMPTY_REDACTEURLIST = Collections.emptyList();
    private final GlobalIdSet adminSet = new GlobalIdSet();
    private final Fichotheque fichotheque;
    private final RoleStorage roleStorage;
    private final RedacteurListStorage redacteurListStorage;
    private Map<String, RoleImpl> roleMap;
    private Roles globalRoles;
    private final Map<String, GlobalIdSet> redacteurByRoleMap = new HashMap<String, GlobalIdSet>();
    private final Map<String, Roles> roleByRedacteurMap = new HashMap<String, Roles>();
    private List<Role> defaultSingletonRoleList;

    private PermissionManagerImpl(Fichotheque fichotheque, RoleStorage roleStorage, RedacteurListStorage redacteurListStorage) {
        this.fichotheque = fichotheque;
        this.roleStorage = roleStorage;
        this.redacteurListStorage = redacteurListStorage;
    }

    static PermissionManagerImpl build(Fichotheque fichotheque, RoleStorage roleStorage, RedacteurListStorage redacteurListStorage, StorageCheck storageCheck) {
        String name;
        PermissionManagerImpl impl = new PermissionManagerImpl(fichotheque, roleStorage, redacteurListStorage);
        TreeMap<String, RoleImpl> roleMap = new TreeMap<String, RoleImpl>();
        RoleImpl defaultRole = null;
        for (RoleDef roleDef : storageCheck.getRoleDefList()) {
            name = roleDef.getName();
            if (roleMap.containsKey(name)) continue;
            RoleImpl roleImpl = RoleImpl.fromRoleDef(roleDef);
            if (name.equals("_default")) {
                defaultRole = roleImpl;
            }
            roleMap.put(name, roleImpl);
        }
        if (defaultRole == null) {
            defaultRole = RoleImpl.fromName("_default");
            roleMap.put("_default", defaultRole);
        }
        impl.roleMap = roleMap;
        impl.globalRoles = new Roles(new ArrayList(roleMap.values()));
        impl.defaultSingletonRoleList = Collections.singletonList(defaultRole);
        for (Map.Entry entry : storageCheck.getRedacteurListMap().entrySet()) {
            String roleName;
            Role role;
            name = (String)entry.getKey();
            List redacteurList = (List)entry.getValue();
            if (name.equals("admin")) {
                for (Redacteur redacteur : redacteurList) {
                    impl.setAdmin(redacteur.getGlobalId(), true);
                }
                continue;
            }
            if (!name.startsWith("role_") || (role = impl.getRole(roleName = name.substring(5))) == null) continue;
            for (Redacteur redacteur : redacteurList) {
                impl.link(redacteur, role);
            }
        }
        return impl;
    }

    @Override
    public boolean isAdmin(Redacteur redacteur) {
        return this.adminSet.containsGlobalId(redacteur.getGlobalId());
    }

    @Override
    public List<Redacteur> getAdminRedacteurList() {
        return this.adminSet.toRedacteurList(this.fichotheque);
    }

    @Override
    public List<Role> getRoleList() {
        return this.globalRoles.getRoleList();
    }

    @Override
    public List<Role> getRoleList(Redacteur redacteur) {
        Roles roles = this.roleByRedacteurMap.get(redacteur.getGlobalId());
        if (roles != null && roles.size() > 0) {
            return roles.getRoleList();
        }
        return this.defaultSingletonRoleList;
    }

    @Override
    public List<Redacteur> getRedacteurList(Role role) {
        GlobalIdSet globalIdSet = this.redacteurByRoleMap.get(role.getName());
        if (globalIdSet != null) {
            return globalIdSet.toRedacteurList(this.fichotheque);
        }
        return EMPTY_REDACTEURLIST;
    }

    @Override
    public Role getRole(String roleName) {
        return this.roleMap.get(roleName);
    }

    void redacteurRemoved(BdfServerEditor bdfServerEditor, String globalId) {
        Roles roles = this.roleByRedacteurMap.get(globalId);
        if (roles != null) {
            for (Role role : roles.getRoleList()) {
                bdfServerEditor.unlink(globalId, role);
            }
            this.roleByRedacteurMap.remove(globalId);
        }
        if (this.adminSet.containsGlobalId(globalId)) {
            if (this.adminSet.size() == 1) {
                throw new UnsupportedOperationException("Last admin cannot be removed");
            }
            bdfServerEditor.setAdmin(globalId, false);
        }
    }

    boolean setAdmin(String globalId, boolean isAdmin) {
        if (isAdmin) {
            if (this.adminSet.containsGlobalId(globalId)) {
                return false;
            }
            Redacteur redacteur = SphereUtils.getRedacteur(this.fichotheque, globalId);
            if (redacteur == null || !redacteur.getStatus().equals("active")) {
                return false;
            }
            this.adminSet.addGlobalId(globalId);
            return true;
        }
        if (this.adminSet.containsGlobalId(globalId)) {
            if (this.adminSet.size() == 1) {
                return false;
            }
            this.adminSet.removeGlobalId(globalId);
            return true;
        }
        return false;
    }

    boolean link(Redacteur redacteur, Role role) {
        this.getOrCreateRoleList(redacteur.getGlobalId()).addRole((RoleImpl)role);
        boolean done = this.getOrCreateGlobalIdSet(role.getName()).addGlobalId(redacteur.getGlobalId());
        return done;
    }

    boolean unlink(String globalId, Role role) {
        RoleImpl roleImpl = (RoleImpl)role;
        String roleName = role.getName();
        Roles roles = this.roleByRedacteurMap.get(globalId);
        if (roles != null) {
            roles.removeRole(roleImpl);
            if (roles.size() == 0) {
                this.roleByRedacteurMap.remove(globalId);
            }
        }
        boolean done = false;
        GlobalIdSet globalIdSet = this.redacteurByRoleMap.get(roleName);
        if (globalIdSet != null) {
            done = globalIdSet.removeGlobalId(globalId);
            if (globalIdSet.size() == 0) {
                this.redacteurByRoleMap.remove(roleName);
            }
        }
        return done;
    }

    RoleImpl createRole(String roleName) throws ParseException, ExistingIdException {
        StringUtils.checkTechnicalName(roleName, true);
        if (this.roleMap.containsKey(roleName)) {
            throw new ExistingIdException();
        }
        RoleImpl roleImpl = RoleImpl.fromName(roleName);
        this.roleMap.put(roleName, roleImpl);
        this.globalRoles.addRole(roleImpl);
        return roleImpl;
    }

    boolean prepareRoleToRemove(String roleName) {
        if (roleName.equals("_default")) {
            throw new IllegalArgumentException("Default role cannot be removed");
        }
        if (!this.roleMap.containsKey(roleName)) {
            return false;
        }
        RoleImpl roleImpl = this.roleMap.remove(roleName);
        this.globalRoles.removeRole(roleImpl);
        GlobalIdSet globalIdSet = this.redacteurByRoleMap.get(roleName);
        if (globalIdSet != null) {
            for (String globalId : globalIdSet.set) {
                Roles roles = this.roleByRedacteurMap.get(globalId);
                if (roles == null) continue;
                roles.removeRole(roleImpl);
                if (roles.size() != 0) continue;
                this.roleByRedacteurMap.remove(globalId);
            }
            this.redacteurByRoleMap.remove(roleName);
        }
        return true;
    }

    RoleStorage getRoleStorage() {
        return this.roleStorage;
    }

    RedacteurListStorage getRedacteurListStorage() {
        return this.redacteurListStorage;
    }

    GlobalIdSet getOrCreateGlobalIdSet(String roleName) {
        GlobalIdSet globalIdSet = this.redacteurByRoleMap.get(roleName);
        if (globalIdSet == null) {
            globalIdSet = new GlobalIdSet();
            this.redacteurByRoleMap.put(roleName, globalIdSet);
        }
        return globalIdSet;
    }

    Roles getOrCreateRoleList(String redacteurGlobalId) {
        Roles roleList = this.roleByRedacteurMap.get(redacteurGlobalId);
        if (roleList == null) {
            roleList = new Roles(new ArrayList());
            this.roleByRedacteurMap.put(redacteurGlobalId, roleList);
        }
        return roleList;
    }

    void saveRedacteurList(String name) {
        String roleName;
        Role role;
        List<Redacteur> redacteurList = null;
        if (name.equals("admin")) {
            redacteurList = this.getAdminRedacteurList();
        } else if (name.startsWith("role_") && (role = this.getRole(roleName = name.substring(5))) != null) {
            redacteurList = this.getRedacteurList(role);
        }
        if (redacteurList != null) {
            this.redacteurListStorage.saveRedacteurList(name, redacteurList);
        }
    }

    void saveRole(RoleImpl roleImpl) {
        this.roleStorage.saveRoleDef(roleImpl);
    }

    void removeRole(String roleName) {
        this.roleStorage.removeRoleDef(roleName);
        this.redacteurListStorage.removeRedacteurList("role_" + roleName);
    }

    private static class GlobalIdSet {
        private final SortedSet<String> set = new TreeSet<String>();

        private GlobalIdSet() {
        }

        private int size() {
            return this.set.size();
        }

        private boolean addGlobalId(String globalId) {
            return this.set.add(globalId);
        }

        private boolean removeGlobalId(String globalId) {
            return this.set.remove(globalId);
        }

        private boolean containsGlobalId(String globalId) {
            return this.set.contains(globalId);
        }

        private List<Redacteur> toRedacteurList(Fichotheque fichotheque) {
            ArrayList<Redacteur> redacteurList = new ArrayList<Redacteur>();
            for (String redacteurGlobalId : this.set) {
                Redacteur redacteur = SphereUtils.getRedacteur(fichotheque, redacteurGlobalId);
                if (redacteur == null) continue;
                redacteurList.add(redacteur);
            }
            return redacteurList;
        }
    }

    private static class Roles {
        private final List<RoleImpl> list;
        private List<Role> cacheList;

        private Roles(List<RoleImpl> list) {
            this.list = list;
        }

        private List<Role> getRoleList() {
            List<Role> result = this.cacheList;
            if (result == null) {
                result = this.initRoleList();
            }
            return result;
        }

        private synchronized List<Role> initRoleList() {
            if (this.cacheList != null) {
                return this.cacheList;
            }
            List<Role> newList = RoleUtils.wrap(this.list.toArray(new Role[this.list.size()]));
            this.cacheList = newList;
            return newList;
        }

        private void clearCache() {
            this.cacheList = null;
        }

        private int size() {
            return this.list.size();
        }

        private synchronized boolean addRole(RoleImpl role) {
            this.clearCache();
            String roleName = role.getName();
            int size = this.list.size();
            boolean done = false;
            for (int i = 0; i < size; ++i) {
                String currentName = this.list.get(i).getName();
                if (currentName.equals(roleName)) {
                    return false;
                }
                if (roleName.compareTo(currentName) >= 0) continue;
                this.list.add(i, role);
                done = true;
                break;
            }
            if (!done) {
                this.list.add(role);
            }
            return true;
        }

        private synchronized boolean removeRole(RoleImpl role) {
            this.clearCache();
            return this.list.remove(role);
        }
    }
}

