/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSessionListener;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.storage.BdfExtensionStorage;
import fr.exemole.bdfserver.api.storage.ConfigurationStorage;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.exportation.table.TableInclusionResolverProvider;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.localisation.Message;

class ExtensionManagerImpl
implements ExtensionManager {
    private final BdfServer bdfServer;
    private final Map<String, InternalBdfExtensionReference> referenceMap = new TreeMap<String, InternalBdfExtensionReference>();
    private final BdfExtensionStorage bdfExtensionStorage;
    private final ConfigurationStorage configurationStorage;
    private final InternalInstructionResolverProvider instructionResolverProvider = new InternalInstructionResolverProvider();
    private final BdfExtensionReferenceList referenceList;

    ExtensionManagerImpl(BdfServer bdfServer, Fichotheque fichotheque, BdfExtensionStorage bdfExtensionStorage, List<BdfExtensionInitializer> extensionInitializerList, ConfigurationStorage configurationStorage) {
        this.bdfServer = bdfServer;
        this.configurationStorage = configurationStorage;
        for (BdfExtensionInitializer initializer : extensionInitializerList) {
            String registratioName = initializer.getRegistrationName();
            BdfExtensionInitializer.Factory factory = initializer.init(bdfExtensionStorage, fichotheque);
            InternalBdfExtensionReference reference = new InternalBdfExtensionReference(bdfServer, registratioName, factory);
            this.referenceMap.put(registratioName, reference);
        }
        this.bdfExtensionStorage = bdfExtensionStorage;
        this.referenceList = new BdfExtensionReferenceList(this.referenceMap.values().toArray(new InternalBdfExtensionReference[this.referenceMap.size()]));
    }

    void endInit() {
        for (InternalBdfExtensionReference reference : this.referenceMap.values()) {
            EditSessionListener editionSessionListener = (EditSessionListener)reference.factory.getImplementation(this.bdfServer, EditSessionListener.class);
            if (editionSessionListener == null) continue;
            this.bdfServer.addEditionSessionListener(editionSessionListener);
        }
    }

    @Override
    public List<BdfExtensionReference> getBdfExtensionReferenceList() {
        return this.referenceList;
    }

    @Override
    public BdfExtensionReference getBdfExtensionReference(String registrationName) {
        return this.referenceMap.get(registrationName);
    }

    @Override
    public BdfExtensionStorage getBdfExtensionStorage() {
        return this.bdfExtensionStorage;
    }

    InstructionResolverProvider getInstructionResolverProvider() {
        return this.instructionResolverProvider;
    }

    TableInclusionResolver getExtensionTableInclusionResolver(String tableInclusionName) {
        return this.referenceList.getExtensionTableInclusionResolver(tableInclusionName);
    }

    void update(List<String> activeExtensionList) {
        this.referenceList.updateActive(activeExtensionList);
    }

    void save() {
        this.configurationStorage.saveActiveExtensionList(BdfServerUtils.toActiveExtensionList(this.referenceList));
    }

    private static class BdfExtensionReferenceList
    extends AbstractList<BdfExtensionReference>
    implements RandomAccess {
        private final InternalBdfExtensionReference[] array;

        private BdfExtensionReferenceList(InternalBdfExtensionReference[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public BdfExtensionReference get(int index) {
            return this.array[index];
        }

        private void updateActive(List<String> activeExtensionList) {
            for (InternalBdfExtensionReference reference : this.array) {
                boolean active = false;
                if (activeExtensionList.contains(reference.getRegistrationName())) {
                    active = true;
                }
                reference.setActive(active);
            }
        }

        private InstructionResolver getInstructionResolver(Class destinationClass, Object optionObject) {
            for (InternalBdfExtensionReference reference : this.array) {
                InstructionResolver resolver;
                InstructionResolverProvider provider = (InstructionResolverProvider)reference.getImplementation(InstructionResolverProvider.class);
                if (provider == null || (resolver = provider.getInstructionResolver(destinationClass, optionObject)) == null) continue;
                return resolver;
            }
            return null;
        }

        private TableInclusionResolver getExtensionTableInclusionResolver(String nameSpace) {
            for (InternalBdfExtensionReference reference : this.array) {
                TableInclusionResolver resolver;
                TableInclusionResolverProvider provider = (TableInclusionResolverProvider)reference.getImplementation(TableInclusionResolverProvider.class);
                if (provider == null || (resolver = provider.getTableInclusionResolver(nameSpace)) == null) continue;
                return resolver;
            }
            return null;
        }
    }

    private class InternalInstructionResolverProvider
    implements InstructionResolverProvider {
        private InternalInstructionResolverProvider() {
        }

        @Override
        public InstructionResolver getInstructionResolver(Class destinationClass, Object optionObject) {
            return ExtensionManagerImpl.this.referenceList.getInstructionResolver(destinationClass, optionObject);
        }
    }

    private static class InternalBdfExtensionReference
    implements BdfExtensionReference {
        private final BdfServer bdfServer;
        private final String registrationName;
        private final BdfExtensionInitializer.Factory factory;
        private final Map<Class, Object> implementationMap = new HashMap<Class, Object>();
        private boolean active = true;

        private InternalBdfExtensionReference(BdfServer bdfServer, String registrationName, BdfExtensionInitializer.Factory factory) {
            this.bdfServer = bdfServer;
            this.registrationName = registrationName;
            this.factory = factory;
        }

        @Override
        public String getRegistrationName() {
            return this.registrationName;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public Message getTitleMessage() {
            return (Message)this.factory.getImplementation(this.bdfServer, Message.class);
        }

        @Override
        public Object getImplementation(Class interfaceClass) {
            if (this.active) {
                if (this.implementationMap.containsKey(interfaceClass)) {
                    return this.implementationMap.get(interfaceClass);
                }
                Object implementation = this.factory.getImplementation(this.bdfServer, interfaceClass);
                this.implementationMap.put(interfaceClass, implementation);
                return implementation;
            }
            return null;
        }

        private void setActive(boolean active) {
            this.active = active;
        }
    }
}

