/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.menu.MenuGroup;
import fr.exemole.bdfserver.api.menu.MenuLink;
import fr.exemole.bdfserver.api.menu.MenuNode;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.json.BdfUserJson;
import fr.exemole.bdfserver.tools.BdfHrefProvider;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.utils.FichothequeMetadataUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.localisation.Message;

public class IframesHtmlProducer
extends BdfServerHtmlProducer {
    private final BdfHrefProvider bdfHrefProvider;

    public IframesHtmlProducer(BdfParameters bdfParameters, BdfHrefProvider bdfHrefProvider) {
        super(bdfParameters);
        this.bdfHrefProvider = bdfHrefProvider;
        this.addJsLib(MiscJsLibs.MAIN);
        this.addJsLib(MiscJsLibs.MENU);
        this.scanIcons();
        this.setMainStorageKey("main", "iframes");
    }

    @Override
    public void printHtml() {
        JsObject args = JsObject.init().put("bdfUser", this.getBdfUserObject()).put("actionGroupArray", this.getActionGroupArray()).put("links", this.getLinksObject());
        this.start(FichothequeMetadataUtils.getLongTitle(this.bdfServer.getFichotheque(), this.workingLang));
        this.SCRIPT().__jsObject("Menu.ARGS", args)._SCRIPT();
        this.DIV(HA.id("main")).DIV(HA.id("main_menu").classes("menu-Container"))._DIV().DIV(HA.id("main_body")).DIV(HA.id("main_body_tool"))._DIV().DIV(HA.id("main_body_list")).__(this.appendIFrame("List", "main_body_list_iframe"))._DIV().DIV(HA.id("main_body_edition")).DIV(HA.id("main_body_edition_toolbar").classes("hidden"))._DIV().DIV(HA.id("main_body_edition_fieldedit").classes("hidden"))._DIV().__(this.appendIFrame("Edition", "main_body_edition_iframe"))._DIV()._DIV()._DIV();
        this.end();
    }

    private boolean appendIFrame(String name, String id) {
        this.IFRAME(HA.name(name).id(id).src(this.bdfHrefProvider.getSrc(name)))._IFRAME();
        return true;
    }

    private JsObject getBdfUserObject() {
        JsObject bdfUserJsObject = JsObject.init().put("admin", this.bdfParameters.isFichothequeAdmin());
        BdfUserJson.populate(bdfUserJsObject, this.bdfUser);
        return bdfUserJsObject;
    }

    private JsObject getLinksObject() {
        JsObject linksJsObject = new JsObject();
        if (this.bdfParameters.isFichothequeAdmin() || this.bdfParameters.getPermissionSummary().isPartialAdmin()) {
            linksJsObject.put("administration", true);
        }
        return linksJsObject;
    }

    private List<JsObject> getActionGroupArray() {
        ArrayList<JsObject> list = new ArrayList<JsObject>();
        List<MenuGroup> menuGroupList = BdfServerUtils.getExtensionMenuGroupList(this.bdfServer, this.bdfUser, "mainMenu");
        for (MenuGroup menuGroup : menuGroupList) {
            list.add(this.getActionGroupObject(menuGroup));
        }
        return list;
    }

    private JsObject getActionGroupObject(MenuGroup menuGroup) {
        JsObject actionGroupObject = new JsObject();
        actionGroupObject.put("title", this.getTitle(menuGroup));
        ArrayList<JsObject> actionList = new ArrayList<JsObject>();
        for (MenuNode menuNode : menuGroup.getMenuNodeList()) {
            if (!(menuNode instanceof MenuLink)) continue;
            actionList.add(this.getActionMenuLink((MenuLink)menuNode));
        }
        actionGroupObject.put("actionArray", actionList);
        return actionGroupObject;
    }

    private JsObject getActionMenuLink(MenuLink menuLink) {
        JsObject actionLinkObject = new JsObject();
        String target = menuLink.getTarget();
        if (target == null) {
            target = "Edition";
        }
        String url = menuLink.getUrl();
        String iconPath = menuLink.getIconPath();
        if (iconPath == null) {
            iconPath = "";
        }
        actionLinkObject.put("target", target).put("url", url).put("icon", iconPath).put("title", this.getTitle(menuLink));
        return actionLinkObject;
    }

    private String getTitle(MenuNode menuNode) {
        Message titleMessage = menuNode.getTitleMessage();
        if (titleMessage != null) {
            return this.getLocalization(titleMessage);
        }
        return menuNode.getTitle();
    }
}

