/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.exportation;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.AccessesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.BalayageErrorHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.BalayageIndexHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.BalayageResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.BalayagesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.ScrutariExportsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.SqlExportsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.TableExportsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.TemplateBinaryUpdateHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.exportation.TransformationsHtmlProducer;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ExportationHtmlProducerFactory {
    private ExportationHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "accesses": {
                return new AccessesHtmlProducer(parameters);
            }
            case "balayage-index": {
                parameters.checkFichothequeAdmin();
                return new BalayageIndexHtmlProducer(parameters);
            }
            case "balayage-error": {
                BalayageDescription balayageDescription = requestHandler.getBalayage();
                return new BalayageErrorHtmlProducer(parameters, balayageDescription.getBalayageDef());
            }
            case "balayage-result": {
                BalayageDescription balayageDescription = requestHandler.getBalayage();
                BalayageLog balayageLog = (BalayageLog)parameters.getResultObject("obj.balayagelog");
                String mode = (String)parameters.getResultObject("obj.mode");
                return new BalayageResultHtmlProducer(parameters, balayageDescription.getBalayageDef(), mode, balayageLog);
            }
            case "tableexports": {
                parameters.checkFichothequeAdmin();
                return new TableExportsHtmlProducer(parameters);
            }
            case "scrutariexports": {
                parameters.checkFichothequeAdmin();
                return new ScrutariExportsHtmlProducer(parameters);
            }
            case "transformations": {
                parameters.checkFichothequeAdmin();
                return new TransformationsHtmlProducer(parameters);
            }
            case "transformation-binaryupdate": {
                parameters.checkFichothequeAdmin();
                TemplateContentDescription templateContentDescription = requestHandler.getTemplateContentDescription();
                return new TemplateBinaryUpdateHtmlProducer(parameters, templateContentDescription);
            }
            case "sqlexports": {
                parameters.checkFichothequeAdmin();
                return new SqlExportsHtmlProducer(parameters);
            }
            case "balayages": {
                parameters.checkFichothequeAdmin();
                return new BalayagesHtmlProducer(parameters);
            }
        }
        return null;
    }
}

