/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.tools.BH;
import java.util.Locale;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public final class CorpusHtmlUtils {
    private CorpusHtmlUtils() {
    }

    public static boolean printCorpusToolbar(HtmlPrinter hp, Corpus corpus, String currentPage, BdfServer bdfServer) {
        boolean withExternalSources = bdfServer.getContextObject("fichothequeSharing") != null;
        hp.NAV("subset-Toolbar").__(CorpusHtmlUtils.printCommands(hp, corpus, currentPage)).__(CorpusHtmlUtils.printInclude(hp, corpus, currentPage, withExternalSources)).__(CorpusHtmlUtils.printOverview(hp, corpus, currentPage))._NAV();
        return true;
    }

    private static boolean printCommands(HtmlPrinter hp, Corpus corpus, String currentPage) {
        Button button = Button.link().style("transparent");
        boolean withRemoveField = CorpusMetadataUtils.containsRemoveableField(corpus.getCorpusMetadata());
        hp.DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.global.commands").__colon()._SPAN().__(CorpusHtmlUtils.link(button, "action-Labels", corpus, "corpus-phrasesform", "_ link.corpus.corpusphrasesform", currentPage)).__(CorpusHtmlUtils.link(button, "action-FieldCreate", corpus, "field-creationform", "_ link.corpus.fieldcreationform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Options", corpus, "field-optionsform", "_ CRP-07", currentPage)).__if(withRemoveField, CorpusHtmlUtils.link(button, "action-FieldRemove", corpus, "field-removeform", "_ CRP-08", currentPage)).__(CorpusHtmlUtils.link(button, "action-ComponentPosition", corpus, "ui-componentpositionform", "_ link.corpus.uicomponentpositionform", currentPage)).__(CorpusHtmlUtils.link(button, "action-ComponentOptions", corpus, "ui-componentoptionsform", "_ link.corpus.uicomponentoptionsform", currentPage)).__(CorpusHtmlUtils.link(button, "action-ComponentAttributes", corpus, "ui-componentattributesform", "_ link.corpus.uicomponentattributesform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Advanced", corpus, "corpus-advancedcommands", "_ link.corpus.corpusadvancedcommands", currentPage)).__(CorpusHtmlUtils.link(button, "action-History", corpus, "removedlist", "_ link.corpus.removedlist", currentPage)).__(CorpusHtmlUtils.refresh(button, corpus))._DIV();
        return true;
    }

    private static boolean printInclude(HtmlPrinter hp, Corpus corpus, String currentPage, boolean withExternalSources) {
        Button button = Button.link().style("transparent");
        hp.DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.corpus.include").__colon()._SPAN().__(CorpusHtmlUtils.link(button, "action-Special", corpus, "include-special", "_ link.corpus.corpusinclude_specialform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Thesaurus", corpus, "include-thesaurus", "_ link.corpus.corpusinclude_thesaurusform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Corpus", corpus, "include-corpus", "_ link.corpus.corpusinclude_corpusform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Album", corpus, "include-album", "_ link.corpus.corpusinclude_albumform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Addenda", corpus, "include-addenda", "_ link.corpus.corpusinclude_addendaform", currentPage)).__(CorpusHtmlUtils.link(button, "action-Comment", corpus, "include-comment", "_ link.corpus.corpusinclude_commentform", currentPage)).__if(withExternalSources, CorpusHtmlUtils.link(button, "action-ExternalSource", corpus, "include-externalsource", "_ link.corpus.corpusinclude_externalsourceform", currentPage))._DIV();
        return true;
    }

    private static boolean printOverview(HtmlPrinter hp, Corpus corpus, String currentPage) {
        Button button = Button.link().style("transparent");
        hp.DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.corpus.overview").__colon()._SPAN().__(CorpusHtmlUtils.link(button, "action-Diagrams", corpus, "corpus-diagram", "_ link.corpus.diagram", currentPage)).__(CorpusHtmlUtils.link(button, "action-Conf", corpus, "corpus-conf", "_ link.corpus.conf", currentPage))._DIV();
        return true;
    }

    public static boolean printFicheHeader(HtmlPrinter hp, FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        SubsetItem masterItem = null;
        Subset masterSubset = ficheMeta.getCorpus().getMasterSubset();
        if (masterSubset != null) {
            masterItem = masterSubset.getSubsetItemById(ficheMeta.getId());
        }
        String title = CorpusMetadataUtils.getFicheTitle(ficheMeta, workingLang, formatLocale);
        hp.HEADER("subset-ItemHeader").__(BdfHtmlUtils.printFicheTitle(hp, title, ficheMeta.isDiscarded(), masterItem, workingLang, formatLocale))._HEADER();
        return true;
    }

    public static boolean printFicheHeader(HtmlPrinter hp, String title, boolean discarded, SubsetItem masterItem, Lang workingLang, Locale formatLocale) {
        hp.HEADER("subset-ItemHeader").__(BdfHtmlUtils.printFicheTitle(hp, title, discarded, masterItem, workingLang, formatLocale))._HEADER();
        return true;
    }

    public static String getFicheItemMessageKey(String ficheItemType) {
        switch (ficheItemType) {
            case "person": {
                return "_ label.corpus.ficheitemtype_person";
            }
            case "language": {
                return "_ label.corpus.ficheitemtype_language";
            }
            case "date": {
                return "_ label.corpus.ficheitemtype_date";
            }
            case "country": {
                return "_ label.corpus.ficheitemtype_country";
            }
            case "email": {
                return "_ label.corpus.ficheitemtype_email";
            }
            case "link": {
                return "_ label.corpus.ficheitemtype_link";
            }
            case "item": {
                return "_ label.corpus.ficheitemtype_item";
            }
            case "number": {
                return "_ label.corpus.ficheitemtype_number";
            }
            case "amount": {
                return "_ label.corpus.ficheitemtype_amount";
            }
            case "geopoint": {
                return "_ label.corpus.ficheitemtype_geopoint";
            }
            case "para": {
                return "_ label.corpus.ficheitemtype_para";
            }
            case "image": {
                return "_ label.corpus.ficheitemtype_image";
            }
        }
        throw new SwitchException("Unknown type: " + ficheItemType);
    }

    private static Button link(Button button, String action, Corpus corpus, String page, String titleLocKey, String currentPage) {
        if (currentPage.equals(page)) {
            return button.current(true).href(null).action(action).tooltip(null);
        }
        return button.current(false).href(BH.domain("corpus").subset(corpus).page(page)).action(action).tooltipMessage(titleLocKey);
    }

    private static Button refresh(Button button, Corpus corpus) {
        return button.current(false).href(BH.domain("corpus").page("corpus").subset(corpus)).action("action-Refresh").tooltipMessage("_ link.global.reload").target("List");
    }
}

