/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.configuration.ConfigurationCommandBoxUtils;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.storage.IconScanEngine;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.text.RelativePath;

public class LogosFormHtmlProducer
extends BdfServerHtmlProducer {
    public LogosFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("configuration.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("configuration").family("CNF").veil(true).page("config-logos").name(BdfInstructionUtils.getAbsoluteCommandName("administration", "ResourceUpload")).multipart(true).actionCssClass("action-Save").submitLocKey("_ submit.administration.resourceupload");
        this.printLogoBox(commandBox);
        this.printIconBox(commandBox, "16");
        this.printIconBox(commandBox, "32");
        this.printOdtLogoBox();
        this.printExistingCustomIconUnit();
        ConfigurationCommandBoxUtils.printCustomIconUploadBox(this, commandBox);
        this.end();
    }

    private void printIconBox(CommandBox commandBox, String size) {
        RelativePath relativePath = LogosFormHtmlProducer.getRelativePath(size);
        boolean containsIcon = StorageUtils.containsVarResource(this.bdfServer, relativePath);
        commandBox.lockey(LogosFormHtmlProducer.getCommandLockKey(size)).hidden("path", relativePath.toString());
        this.__start(commandBox).__(Grid.START).__(this.printImageRow(containsIcon, HA.src(relativePath.toString()).alt("icon " + size + "x" + size).classes("configuration-Logo").height(size).width(size))).__(this.printFileInput("_ label.configuration.file_icon")).__(Grid.END).__end(commandBox);
    }

    private boolean printLogoBox(CommandBox commandBox) {
        boolean containsLogo = this.bdfServer.getResourceStorages().containsResource(StorageUtils.LOGO);
        commandBox.lockey("_ CNF-06").hidden("path", StorageUtils.LOGO.toString());
        this.__start(commandBox).__(Grid.START).__(this.printLogoRow(containsLogo, HA.src("images/logo.png").alt("logo").classes("configuration-Logo"))).__(this.printFileInput("_ label.configuration.file_logo")).__(Grid.END).__end(commandBox);
        return true;
    }

    private boolean printImageRow(boolean contains, HtmlAttributes imgAttributes) {
        String locKey = contains ? "_ label.configuration.icon_current" : "_ label.configuration.icon_default";
        this.__(Grid.START_ROW).__(Grid.labelCells(locKey)).__(Grid.START_INPUTCELL).IMG(imgAttributes).__(Grid.END_INPUTCELL).__(Grid.END_ROW);
        return true;
    }

    private boolean printLogoRow(boolean contains, HtmlAttributes imgAttributes) {
        if (contains) {
            this.__(Grid.START_ROW).__(Grid.labelCells("_ label.configuration.logo_current")).__(Grid.START_INPUTCELL).IMG(imgAttributes).__(Grid.END_INPUTCELL).__(Grid.END_ROW);
        } else {
            this.__(Grid.START_ROW).__(Grid.START_UNIQUECELL).__localize("_ info.configuration.nologo").__(Grid.END_UNIQUECELL).__(Grid.END_ROW);
        }
        return true;
    }

    private boolean printFileInput(String messageKey) {
        this.__(Grid.fileInputRow(messageKey, this.name("file").size("75").classes("global-FileInput")));
        return true;
    }

    private boolean printExistingCustomIconUnit() {
        List<HtmlAttributes> existingList = IconScanEngine.run(this.bdfServer.getResourceStorages(), this.bdfServer.getMimeTypeResolver());
        this.__(PageUnit.start("action-Logos", "_ title.configuration.customincons"));
        if (existingList.isEmpty()) {
            this.P().__localize("_ info.configuration.empty_customincons").P();
        } else {
            this.__(Grid.START);
            for (HtmlAttributes htmlAttributes : existingList) {
                HtmlAttributes imgAttributes = HA.src(htmlAttributes.href()).classes("configuration-Logo");
                String sizes = htmlAttributes.attr("sizes");
                String labelText = sizes != null ? sizes + " (" + htmlAttributes.rel() + ")" : htmlAttributes.rel();
                this.__(Grid.START_ROW).__(Grid.labelCells(new Litteral(labelText))).__(Grid.START_INPUTCELL).IMG(imgAttributes).__(Grid.END_INPUTCELL).__(Grid.END_ROW);
            }
            this.__(Grid.END);
        }
        this.__(PageUnit.END);
        return true;
    }

    private void printOdtLogoBox() {
        Map<String, String> logoMap = ConfigurationUtils.getOdtLogoParameters(this.bdfServer);
        CommandBox commandBox = CommandBox.init().action("configuration").lockey("_ CNF-19").family("CNF").veil(true).page("config-logos").name("OdtLogoChange").multipart(true).actionCssClass("action-Odt").submitLocKey("_ submit.configuration.odtlogochange");
        String path = logoMap.get("path");
        boolean withCurrent = false;
        HtmlAttributes logoImg = null;
        if (path != null) {
            withCurrent = true;
            logoImg = HA.src(path).alt("logo").classes("configuration-Logo");
        }
        this.__start(commandBox).__(Grid.START).__(this.printLogoRow(withCurrent, logoImg)).__(Grid.fileInputRow("_ label.configuration.file_logo_odt", this.name("file").size("75").classes("global-FileInput"))).__(Grid.textInputRow("_ label.configuration.odtlogowidth", this.name("width").size("30").value(logoMap.get("width")))).__(Grid.textInputRow("_ label.configuration.odtlogoheight", this.name("height").size("30").value(logoMap.get("height")))).__(Grid.END).__end(commandBox);
    }

    private static String getCommandLockKey(String size) {
        switch (size) {
            case "16": {
                return "_ CNF-07";
            }
            case "32": {
                return "_ CNF-08";
            }
        }
        throw new SwitchException("Unknown size: " + size);
    }

    private static RelativePath getRelativePath(String size) {
        switch (size) {
            case "16": {
                return StorageUtils.ICON;
            }
            case "32": {
                return StorageUtils.ICON32;
            }
        }
        throw new SwitchException("Unknown size: " + size);
    }
}

