/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.album.AlbumCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlUtils;
import net.fichotheque.album.Album;
import net.mapeadores.util.html.CommandBox;

public class AlbumAdvancedCommandsHtmlProducer
extends BdfServerHtmlProducer {
    private final Album album;

    public AlbumAdvancedCommandsHtmlProducer(BdfParameters bdfParameters, Album album) {
        super(bdfParameters);
        this.album = album;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("album.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.album, "album-advancedcommands");
        AlbumHtmlUtils.printAlbumToolbar(this, "album-advancedcommands", this.album);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("album").family("ALB").veil(true);
        if (this.bdfParameters.isFichothequeAdmin() && this.album.isRemoveable()) {
            commandBox.errorPage("album-advancedcommands").page("_message");
            AlbumCommandBoxUtils.printAlbumRemoveBox(this, commandBox, this.album);
        }
        commandBox.errorPage(null).page("album-advancedcommands");
        AlbumCommandBoxUtils.printAlbumAttributeChangeBox(this, commandBox, this.album);
    }
}

