/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FieldContentCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.PeriodCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.selection.UserCondition;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.RangeUtils;

public class SelectionFormPrinter {
    private static final SelectOption[] DISCARDFILTER_OPTIONS = new SelectOption[]{SelectOption.init("all").textL10nObject("_ label.selection.discardfilter_all"), SelectOption.init("none").textL10nObject("_ label.selection.discardfilter_none"), SelectOption.init("only").textL10nObject("_ label.selection.discardfilter_only")};
    private final HtmlPrinter htmlPrinter;
    private final Fichotheque fichotheque;
    private final BdfServer bdfServer;
    private final Lang workingLang;
    private final BdfUser bdfUser;
    private final PermissionSummary permissionSummary;
    private final FicheQuery ficheQuery;

    public SelectionFormPrinter(FicheQuery ficheQuery, BdfServer bdfServer, BdfUser bdfUser, PermissionSummary permissionSummary, HtmlPrinter htmlPrinter) {
        this.ficheQuery = ficheQuery;
        this.htmlPrinter = htmlPrinter;
        this.fichotheque = bdfServer.getFichotheque();
        this.bdfUser = bdfUser;
        this.permissionSummary = permissionSummary;
        this.workingLang = bdfUser.getWorkingLang();
        this.bdfServer = bdfServer;
    }

    public boolean printFieldsets() {
        this.htmlPrinter.DIV("selectform-Container").DIV("selectform-Area selectform-Area_corpus").__(this.printIdFieldset()).__(this.printCorpusFieldset()).__(this.printDiscardFilterFieldset())._DIV().DIV("selectform-Area selectform-Area_field").__(this.printFieldConditionFieldset()).__(this.printUserFieldset()).__(this.printPeriodFieldSet())._DIV().DIV("selectform-Area selectform-Area_croisement").__(this.printMotcleConditionFieldsets()).__(this.printFicheConditionFieldsets())._DIV()._DIV();
        return true;
    }

    public static SelectionFormPrinter init(FicheQuery ficheQuery, BdfServer bdfServer, BdfUser bdfUser, PermissionSummary permissionSummary, HtmlPrinter htmlPrinter) {
        return new SelectionFormPrinter(ficheQuery, bdfServer, bdfUser, permissionSummary, htmlPrinter);
    }

    private boolean printIdFieldset() {
        String idValue = "";
        RangeCondition idRangeCondition = this.ficheQuery.getIdRangeCondition();
        if (idRangeCondition != null) {
            idValue = RangeUtils.positiveRangesToString(idRangeCondition.getRanges());
        }
        this.htmlPrinter.FIELDSET("selectform-Id").LEGEND().__localize("_ label.selection.id").__colon()._LEGEND().TEXTAREA(HA.name("id").classes("selectform-Input").rows(3)).__escape(idValue, true)._TEXTAREA()._FIELDSET();
        return true;
    }

    private boolean printFieldConditionFieldset() {
        String fieldValue = "";
        FieldContentCondition fieldContentCondition = this.ficheQuery.getFieldContentCondition();
        String currentOperator = "and";
        String currentScope = "title";
        if (fieldContentCondition != null) {
            fieldValue = ConditionsUtils.conditionToSimpleString(fieldContentCondition.getTextCondition(), false);
            currentScope = fieldContentCondition.getScope();
            currentOperator = fieldContentCondition.getTextCondition().getLogicalOperator();
        }
        this.htmlPrinter.FIELDSET("selectform-FieldCondition").LEGEND().__localize("_ label.selection.fieldcondition").__colon()._LEGEND().INPUT_text(HA.name("fieldcontent").value(fieldValue).classes("selectform-Input")).DIV("selectform-AndOr").__(this.printAndOr("fieldcontent_operator", currentOperator))._DIV().__(this.addScopeRadio("title", "_ label.selection.scope_title", currentScope)).__(this.addScopeRadio("head", "_ label.selection.scope_head", currentScope)).__(this.addScopeRadio("fiche", "_ label.selection.scope_fiche", currentScope)).__(this.addScopeRadio("selection", "_ label.selection.scope_selection", currentScope))._FIELDSET();
        return true;
    }

    private boolean addScopeRadio(String scope, String key, String current) {
        String appelantFieldSelection = this.htmlPrinter.generateId();
        String appelantFieldSelectionAnchorId = this.htmlPrinter.generateId();
        String fieldSelectionAreaId = this.htmlPrinter.generateId();
        String fieldSelectionAreaClasses = "";
        boolean isSelectionScope = scope.equals("selection");
        if (this.htmlPrinter.isWithJavascript() && !current.equals(scope)) {
            fieldSelectionAreaClasses = "hidden";
        }
        HtmlAttributes scopeAttr = HA.name("fieldcontent_scope").value(scope).checked(current);
        if (isSelectionScope) {
            scopeAttr.populate(Deploy.radio(fieldSelectionAreaId));
        }
        this.htmlPrinter.LABEL("selectform-Label").INPUT_radio(scopeAttr).__localize(key)._LABEL();
        if (isSelectionScope) {
            String fieldSelection = "";
            FieldContentCondition fieldContentCondition = this.ficheQuery.getFieldContentCondition();
            if (fieldContentCondition != null) {
                fieldSelection = this.toString(fieldContentCondition.getFieldKeyList());
            }
            this.htmlPrinter.DIV(HA.id(fieldSelectionAreaId).classes(fieldSelectionAreaClasses)).INPUT_text(HA.id(appelantFieldSelection).name("fieldcontent_fieldselection").value(fieldSelection).classes("selectform-Input").populate(Appelant.field().anchor(appelantFieldSelectionAnchorId))).DIV("selectform-AndOr").SPAN(HA.id(appelantFieldSelectionAnchorId)).__space()._SPAN()._DIV()._DIV();
        }
        return true;
    }

    private boolean printCorpusFieldset() {
        String detailId = this.htmlPrinter.generateId();
        SubsetCondition corpusCondition = this.ficheQuery.getCorpusCondition();
        boolean all = corpusCondition.isAll();
        SubsetTree filteredSubsetTree = TreeFilterEngine.read(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)1));
        this.htmlPrinter.FIELDSET("selectform-fieldset-Corpus").LEGEND().__localize("_ label.selection.corpus").__colon()._LEGEND().__(this.addRadios("corpus_all", detailId, all, "_ label.selection.corpus_all")).DIV(this.getDetailAttributes(detailId, all)).__(SubsetTreeOptions.init(filteredSubsetTree, this.bdfServer, this.workingLang).onlyNames(true).withKeys(false).selectedSet(corpusCondition.getSubsetKeySet()).checkboxMode(HA.name("corpus_selection"), HA.classes("selectform-Label"), HA.classes("selectform-GroupTitle"), HA.classes("selectform-GroupDiv")))._DIV()._FIELDSET();
        return true;
    }

    private boolean printDiscardFilterFieldset() {
        String currentDiscardFilter = this.ficheQuery.getDiscardFilter();
        this.htmlPrinter.FIELDSET("selectform-fieldset-DiscardFilter").LEGEND().__localize("_ label.selection.discardfilter").__colon()._LEGEND().SELECT("discardfilter");
        for (SelectOption option : DISCARDFILTER_OPTIONS) {
            this.htmlPrinter.__(option, currentDiscardFilter);
        }
        this.htmlPrinter._SELECT()._FIELDSET();
        return true;
    }

    private boolean printUserFieldset() {
        UserCondition userCondition = this.ficheQuery.getUserCondition();
        boolean all = userCondition == null;
        String usersString = "";
        if (userCondition != null) {
            switch (userCondition.getFilter()) {
                case "any": {
                    usersString = "*";
                    break;
                }
                case "none": {
                    usersString = "!*";
                    break;
                }
                case "some": {
                    usersString = this.toUsersString(userCondition);
                }
            }
        }
        String detailId = this.htmlPrinter.generateId();
        String appelantAnchorId = this.htmlPrinter.generateId();
        this.htmlPrinter.FIELDSET("selectform-fieldset-Users").LEGEND().__localize("_ label.selection.users").__colon()._LEGEND().__(this.addRadios("users_all", detailId, all, "_ label.selection.users_all")).DIV(this.getDetailAttributes(detailId, all)).INPUT_text(this.htmlPrinter.name("users_selection").value(usersString).classes("selectform-Input").populate(Appelant.user().sphere(this.bdfUser).anchor(appelantAnchorId))).DIV("selectform-AndOr").SPAN(HA.id(appelantAnchorId)).__space()._SPAN()._DIV()._DIV()._FIELDSET();
        return true;
    }

    private boolean printPeriodFieldSet() {
        String startDate = "";
        String endDate = "";
        boolean onCreationDate = true;
        boolean onModificationDate = false;
        boolean withFieldSelection = false;
        String fieldSelection = "";
        PeriodCondition periodCondition = this.ficheQuery.getPeriodCondition();
        if (periodCondition != null) {
            switch (periodCondition.getStartType()) {
                case "any": {
                    startDate = "*";
                    break;
                }
                case "date": {
                    startDate = periodCondition.getStartDate().toString();
                }
            }
            switch (periodCondition.getEndType()) {
                case "any": {
                    endDate = "*";
                    break;
                }
                case "date": {
                    endDate = periodCondition.getEndDate().toString();
                }
            }
            onCreationDate = periodCondition.isOnCreationDate();
            onModificationDate = periodCondition.isOnModificationDate();
            fieldSelection = this.toString(periodCondition.getFieldKeyList());
            withFieldSelection = !fieldSelection.isEmpty();
        }
        String fieldsAreaClasses = "";
        if (this.htmlPrinter.isWithJavascript() && !withFieldSelection) {
            fieldsAreaClasses = "hidden";
        }
        String fieldsAreaId = this.htmlPrinter.generateId();
        String appelantAnchorId = this.htmlPrinter.generateId();
        this.htmlPrinter.FIELDSET("selectform-Period").LEGEND().__localize("_ label.selection.period").__colon()._LEGEND().LABEL("selectform-Label").__localize("_ label.selection.period_start").__colon().INPUT_text(HA.name("period_start").value(startDate).size("10").classes("selectform-Input").attr("data-selectform-role", "date"))._LABEL().LABEL("selectform-Label").__localize("_ label.selection.period_end").__colon().INPUT_text(HA.name("period_end").value(endDate).size("10").classes("selectform-Input").attr("data-selectform-role", "date"))._LABEL().LABEL("selectform-Label").INPUT_checkbox(HA.name("period_scope").value("creation").checked(onCreationDate)).__space().__localize("_ label.selection.period_onchrono_creation")._LABEL().LABEL("selectform-Label").INPUT_checkbox(HA.name("period_scope").value("modification").checked(onModificationDate)).__space().__localize("_ label.selection.period_onchrono_modification")._LABEL().LABEL("selectform-Label").INPUT_checkbox(HA.name("period_scope").value("fieldlist").checked(withFieldSelection).populate(Deploy.checkbox(fieldsAreaId))).__space().__localize("_ label.selection.period_fieldlist")._LABEL().DIV(HA.id(fieldsAreaId).classes(fieldsAreaClasses)).INPUT_text(this.htmlPrinter.name("period_fieldlist").value(fieldSelection).classes("selectform-Input").populate(Appelant.field().fieldtype_date().anchor(appelantAnchorId))).DIV("selectform-AndOr").SPAN(HA.id(appelantAnchorId)).__space()._SPAN()._DIV()._DIV()._FIELDSET();
        return true;
    }

    private String toUsersString(UserCondition userCondition) {
        SubsetKey defaultSphereKey = this.bdfUser.getRedacteur().getSubsetKey();
        StringBuilder buf = new StringBuilder();
        for (UserCondition.Entry entry : userCondition.getEntryList()) {
            Redacteur redacteur;
            Sphere sphere = FichothequeUtils.getSphere(this.fichotheque, entry.getSphereName());
            if (sphere == null) continue;
            if (entry instanceof UserCondition.LoginEntry) {
                redacteur = sphere.getRedacteurByLogin(((UserCondition.LoginEntry)entry).getLogin());
                if (redacteur == null) continue;
                this.appendRedacteur(buf, redacteur, defaultSphereKey);
                continue;
            }
            if (entry instanceof UserCondition.IdEntry) {
                redacteur = sphere.getRedacteurById(((UserCondition.IdEntry)entry).getId());
                if (redacteur == null) continue;
                this.appendRedacteur(buf, redacteur, defaultSphereKey);
                continue;
            }
            buf.append('[');
            buf.append(entry.getSphereName());
            buf.append(']');
            buf.append("; ");
        }
        return buf.toString();
    }

    private void appendRedacteur(StringBuilder buf, Redacteur redacteur, SubsetKey defaultSphereKey) {
        if (!defaultSphereKey.equals(redacteur.getSubsetKey())) {
            buf.append(redacteur.getBracketStyle());
        } else {
            buf.append(redacteur.getLogin());
        }
        buf.append("; ");
    }

    private String toString(List<FieldKey> fieldKeyList) {
        if (fieldKeyList.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (FieldKey fieldKey : fieldKeyList) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(fieldKey.getKeyString());
        }
        return buf.toString();
    }

    private boolean printMotcleConditionFieldsets() {
        String logicalOperator = "and";
        boolean hidden = true;
        MotcleCondition motcleCondition = this.ficheQuery.getMotcleCondition();
        HtmlPrinter hp = this.htmlPrinter;
        StringBuilder buf = new StringBuilder();
        PrintWriter old = hp.initPrinter(buf);
        this.printMotcleConditionFieldset(null, "nnn");
        hp.initPrinter(old);
        hp.DIV(HA.id("motcleFieldsets").attr("data-selectform-new-fieldset", buf.toString()));
        if (motcleCondition == null) {
            this.printMotcleConditionFieldset(null, "1");
        } else {
            int number = 1;
            for (MotcleCondition.Entry entry : motcleCondition.getEntryList()) {
                this.printMotcleConditionFieldset(entry.getMotcleQuery(), String.valueOf(number));
                ++number;
            }
            logicalOperator = motcleCondition.getLogicalOperator();
            if (number > 2) {
                hidden = false;
            }
        }
        hp.__(this.printMotcleLogicalOperator(logicalOperator, hidden))._DIV();
        return true;
    }

    private boolean printFicheConditionFieldsets() {
        String logicalOperator = "and";
        FicheCondition ficheCondition = this.ficheQuery.getFicheCondition();
        String ficheConditionString = this.getFicheConditionString(ficheCondition);
        if (ficheCondition != null) {
            logicalOperator = ficheCondition.getLogicalOperator();
        }
        String appelantAnchorId = this.htmlPrinter.generateId();
        this.htmlPrinter.FIELDSET("selectform-fieldset-FicheCondition").LEGEND().__localize("_ label.selection.fichecondition").__colon()._LEGEND().INPUT_text(this.htmlPrinter.name("fiche_list").value(ficheConditionString).classes("selectform-Input").populate(Appelant.fiche().anchor(appelantAnchorId))).DIV("selectform-AndOr").__(this.printAndOr("fiche_logicaloperator", logicalOperator)).SPAN(HA.id(appelantAnchorId)).__space()._SPAN()._DIV()._FIELDSET();
        return true;
    }

    private boolean printMotcleLogicalOperator(String logicalOperator, boolean hidden) {
        String logicalOperatorClasses = hidden ? "selectform-MotcleLogicalOperator hidden" : "selectform-MotcleLogicalOperator";
        this.htmlPrinter.DIV(HA.id("motcleLogicalOperator").classes(logicalOperatorClasses)).__localize("_ label.selection.motclelogicaloperator").__colon().BR().__(this.printAndOr("motcle_logicaloperator", logicalOperator))._DIV();
        return true;
    }

    private boolean printMotcleConditionFieldset(MotcleQuery motcleQuery, String suffix) {
        String anchorId = "motcleInputAnchor_" + suffix;
        HtmlPrinter hp = this.htmlPrinter;
        String logicalOperator = "and";
        MotcleQuery.ContentCondition contentCondition = null;
        boolean withSelection = false;
        ArrayList<Thesaurus> thesaurusList = null;
        if (motcleQuery != null) {
            SubsetCondition thesaurusCondition = motcleQuery.getThesaurusCondition();
            contentCondition = motcleQuery.getContentCondition();
            if (contentCondition != null) {
                logicalOperator = contentCondition.getTextCondition().getLogicalOperator();
            }
            if (!thesaurusCondition.isAll()) {
                withSelection = true;
                thesaurusList = new ArrayList<Thesaurus>();
                for (SubsetKey thesaurusKey : thesaurusCondition.getSubsetKeySet()) {
                    Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(thesaurusKey);
                    if (thesaurus == null) continue;
                    thesaurusList.add(thesaurus);
                }
                if (thesaurusList.isEmpty()) {
                    thesaurusList = null;
                    withSelection = false;
                }
            }
        }
        boolean withSatellite = true;
        String detailId = "thesaurusList_" + suffix;
        HtmlAttributes att = HA.id("parMotcle_" + suffix).classes("selectform-fieldset-MotcleCondition");
        hp.FIELDSET(att).LEGEND().__localize("_ label.selection.motclecondition", suffix).__colon()._LEGEND();
        hp.INPUT_hidden("motcle_satellite_" + suffix, withSatellite ? "1" : "0");
        String value = contentCondition != null ? ConditionsUtils.conditionToString(contentCondition.getTextCondition()) : "";
        Appelant appelantData = Appelant.motcle().anchor(anchorId);
        if (thesaurusList != null) {
            for (Thesaurus thesaurus : thesaurusList) {
                appelantData.subsets(thesaurus.getSubsetKey());
            }
        }
        hp.INPUT_text(HA.id("motcleInput_" + suffix).name("motcle_input_" + suffix).value(value).classes("selectform-Input").populate(appelantData)).DIV("selectform-AndOr").__(this.printAndOr("motcle_contentoperator_" + suffix, logicalOperator)).SPAN(HA.id(anchorId)).__space()._SPAN()._DIV().SPAN("selectform-Label").__localize("_ label.selection.thesaurus")._SPAN().__(this.addRadios("motcle_all_" + suffix, detailId, !withSelection, "_ label.selection.motclecondition_all")).DIV(this.getDetailAttributes(detailId, !withSelection));
        HashSet<SubsetKey> disabledSet = new HashSet<SubsetKey>();
        if (withSelection) {
            HtmlAttributes checkAttr = HA.name("motcle_selection_" + suffix).checked(true).attr("data-selectform-role", "thesaurus-checkbox");
            for (Thesaurus thesaurus : thesaurusList) {
                SubsetKey thesaurusKey = thesaurus.getSubsetKey();
                checkAttr.value(thesaurusKey.getSubsetName());
                hp.LABEL("selectform-Label").INPUT_checkbox(checkAttr).__escape(FichothequeUtils.getTitle(thesaurus, this.workingLang))._LABEL();
                disabledSet.add(thesaurusKey);
            }
        }
        HtmlAttributes selectAttributes = HA.id("thesaurusSelect_" + suffix).classes("selectform-ThesaurusSelect").name("motcle_selection_" + suffix).multiple(true).size("10").attr("data-selectform-role", "thesaurus-select");
        hp.SELECT(selectAttributes).__(SubsetTreeOptions.init(this.bdfServer.getTreeManager().getSubsetTree((short)2), this.bdfServer, this.workingLang).multiple(true).onlyNames(true).withKeys(false).disabledSet(disabledSet))._SELECT()._DIV()._FIELDSET();
        return true;
    }

    private boolean addRadios(String name, String detailId, boolean all, String allLocKey) {
        this.htmlPrinter.LABEL("selectform-Label").INPUT_radio(HA.name(name).value("1").checked(all)).__localize(allLocKey)._LABEL().LABEL("selectform-Label").INPUT_radio(HA.name(name).value("0").checked(!all).populate(Deploy.radio(detailId))).__localize("_ label.selection.selectlist")._LABEL();
        return true;
    }

    private HtmlAttributes getDetailAttributes(String detailId, boolean empty) {
        boolean hidden = this.htmlPrinter.isWithJavascript() && empty;
        return HA.id(detailId).classes("selectform-Detail").addClass(hidden, "hidden");
    }

    private boolean printAndOr(String name, String logicalOperator) {
        boolean isAnd = logicalOperator.equals("and");
        this.htmlPrinter.LABEL().INPUT_radio(HA.name(name).value("and").checked(isAnd)).__localize("_ label.global.and")._LABEL().__space().LABEL().INPUT_radio(HA.name(name).value("or").checked(!isAnd)).__localize("_ label.global.or")._LABEL();
        return true;
    }

    private String getFicheConditionString(FicheCondition ficheCondition) {
        if (ficheCondition == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (FicheCondition.Entry entry : ficheCondition.getEntryList()) {
            FicheQuery entryFicheQuery = entry.getFicheQuery();
            RangeCondition idRangeCondition = entryFicheQuery.getIdRangeCondition();
            Set<SubsetKey> corpusKeySet = entryFicheQuery.getCorpusCondition().getSubsetKeySet();
            if (corpusKeySet.isEmpty() || idRangeCondition == null) continue;
            buf.append(corpusKeySet.iterator().next().getSubsetName());
            buf.append('/');
            if (idRangeCondition.isExclude()) {
                buf.append("!");
            }
            buf.append(RangeUtils.positiveRangesToString(idRangeCondition.getRanges(), ","));
            this.appendCroisementCondition(buf, entry.getCroisementCondition());
            buf.append("; ");
        }
        return buf.toString();
    }

    private void appendCroisementCondition(StringBuilder buf, CroisementCondition croisementCondition) {
        if (croisementCondition == null) {
            return;
        }
        List<String> modeList = croisementCondition.getLienModeList();
        buf.append("|");
        boolean next = false;
        for (String mode : modeList) {
            if (next) {
                buf.append(',');
            } else {
                next = true;
            }
            if (mode.isEmpty()) {
                buf.append("_default");
                continue;
            }
            buf.append(mode);
        }
        RangeCondition rangeCondition = croisementCondition.getWeightRangeCondition();
        if (rangeCondition != null) {
            buf.append("|");
            if (rangeCondition.isExclude()) {
                buf.append("!");
            }
            buf.append(RangeUtils.positiveRangesToString(rangeCondition.getRanges(), ","));
        }
    }
}

