/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.Tree;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.CroisementsBySubset;
import net.fichotheque.croisement.Lien;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;

public class CroisementSelection
implements Consumer<HtmlPrinter> {
    public static final HtmlWrapper TREE = Tree.tree("global-CroisementTree");
    public static final HtmlWrapper OPEN_NODE = Tree.openNode("global-CroisementOpenContent");
    private final String paramName;
    private final List<CroisementsBySubset> croisementsBySubsetList;
    private final Lang workingLang;
    private final Locale formatLocale;

    public CroisementSelection(String paramName, List<CroisementsBySubset> croisementsBySubsetList, Lang workingLang, Locale formatLocale) {
        this.paramName = paramName;
        this.croisementsBySubsetList = croisementsBySubsetList;
        this.workingLang = workingLang;
        this.formatLocale = formatLocale;
    }

    @Override
    public void accept(HtmlPrinter hp) {
        hp.UL("global-CroisementList");
        for (CroisementsBySubset croisementsBySubset : this.croisementsBySubsetList) {
            Subset subset = croisementsBySubset.getSubset();
            SubsetKey subsetKey = subset.getSubsetKey();
            hp.LI().P().__(SubsetTitle.init(subset, this.workingLang).subsetIcon(true))._P().__(TREE, () -> {
                for (Croisements.Entry entry : croisementsBySubset.getCroisements().getEntryList()) {
                    SubsetItem subsetItem = entry.getSubsetItem();
                    for (Lien lien : entry.getCroisement().getLienList()) {
                        HtmlAttributes inputAttributes = hp.name(this.paramName).value(this.getValue(subsetKey, subsetItem, lien.getMode()));
                        hp.__(Tree.checkboxLeaf(inputAttributes, () -> hp.__(this.printMode(hp, lien.getMode(), lien.getWeight())).__(this.printTitle(hp, subsetItem))));
                    }
                }
            })._LI();
        }
        hp._UL();
    }

    private String getValue(SubsetKey subsetKey, SubsetItem subsetItem, String mode) {
        StringBuilder buf = new StringBuilder();
        buf.append(subsetKey);
        if (mode.length() > 0) {
            buf.append('_');
            buf.append(mode);
        }
        buf.append('/');
        buf.append(subsetItem.getId());
        return buf.toString();
    }

    private boolean printMode(HtmlPrinter hp, String mode, int weight) {
        if (weight > 1 || mode.length() > 0) {
            hp.__escape(" <");
            if (mode.length() > 0) {
                hp.__escape(mode);
                if (weight > 1) {
                    hp.__escape('_');
                }
            }
            if (weight > 1) {
                hp.__append(weight);
            }
            hp.__escape("> ");
            return true;
        }
        return false;
    }

    private boolean printTitle(HtmlPrinter hp, SubsetItem subsetItem) {
        if (subsetItem instanceof FicheMeta) {
            hp.__escape(CorpusMetadataUtils.getFicheTitle((FicheMeta)subsetItem, this.workingLang, this.formatLocale));
        }
        return true;
    }
}

