/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.smtp.SmtpParameters;
import net.mapeadores.util.smtp.SmtpUtils;
import net.mapeadores.util.text.StringUtils;

public class SmtpManager {
    public static final short INIT_OK = 1;
    public static final short INIT_NOFILE = -1;
    public static final short INIT_IOEXCEPTION = -2;
    public static final short INIT_PROPERTIESERRORS = -3;
    private final File iniFile;
    private List<String> errorList = StringUtils.EMPTY_STRINGLIST;
    private SmtpParameters smtpParameters;
    private short initState;

    public SmtpManager(@Nullable File iniFile) {
        this.iniFile = iniFile;
        this.init();
    }

    public boolean isInit() {
        return this.initState == 1;
    }

    public short getInitState() {
        return this.initState;
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public SmtpParameters getSmtpParameters() {
        return this.smtpParameters;
    }

    public String getIniFilePath() {
        if (this.iniFile == null) {
            return "";
        }
        return this.iniFile.getAbsolutePath();
    }

    private void init() {
        if (this.iniFile == null || !this.iniFile.exists() || this.iniFile.isDirectory()) {
            this.initState = (short)-1;
            this.smtpParameters = null;
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try (FileInputStream is = new FileInputStream(this.iniFile);){
            IniParser.parseIni((InputStream)is, map);
        }
        catch (IOException ioe) {
            this.initState = (short)-2;
            this.smtpParameters = null;
            this.errorList = Collections.singletonList(ioe.getMessage());
        }
        if (map.isEmpty()) {
            this.initState = (short)-1;
            this.smtpParameters = null;
            return;
        }
        ArrayList<String> newErrorList = new ArrayList<String>();
        this.smtpParameters = SmtpUtils.toSmtpParameters(map, newErrorList);
        if (!newErrorList.isEmpty()) {
            this.smtpParameters = null;
            this.initState = (short)-3;
            this.errorList = newErrorList;
        } else {
            this.initState = 1;
        }
    }
}

