/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.TypoOptions;

public class LabelChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LabelChange";
    public static final String COMMANDKEY = "_ THS-11";
    public static final String LABEL_PARAMPREFIX = "label/";
    public static final String BABELIEN_LANG_PARAMNAME = "babelienlang";
    public static final String BABELIEN_LABEL_PARAMNAME = "babelienlabel";
    private Motcle motcle;
    private LabelChange motcleLabelChange;
    private Lang babelienLang;
    private String babelienLabel;

    public LabelChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Thesaurus thesaurus = this.motcle.getThesaurus();
        boolean done = false;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(thesaurus);
            if (this.motcleLabelChange != null) {
                done = ThesaurusUtils.changeMotcleLabels(thesaurusEditor, this.motcle, this.motcleLabelChange);
            } else if (this.babelienLabel != null) {
                TypoOptions typoOptions = TypoOptions.getTypoOptions(this.babelienLang.toLocale());
                done = thesaurusEditor.putLabel(this.motcle, this.babelienLang, TypoParser.parseTypo(this.babelienLabel, typoOptions));
            }
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.putResultObject("obj.motcle", this.motcle);
        if (done) {
            this.setDone("_ done.thesaurus.labelchange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        if (this.motcle.getThesaurus().isBabelienType()) {
            this.babelienLabel = this.getMandatory(BABELIEN_LABEL_PARAMNAME);
            String langString = this.getMandatory(BABELIEN_LANG_PARAMNAME).trim();
            if (!langString.isEmpty()) {
                try {
                    this.babelienLang = Lang.parse(langString);
                }
                catch (ParseException lie) {
                    throw BdfErrors.error("_ error.wrong.lang", langString);
                }
            }
        } else {
            this.motcleLabelChange = this.requestHandler.getLabelChange(LABEL_PARAMPREFIX);
        }
    }
}

