/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.commands.selection.FqlParserCommand;
import fr.exemole.bdfserver.commands.selection.SelectionDefChangeCommand;
import fr.exemole.bdfserver.commands.selection.SelectionDefCreationCommand;
import fr.exemole.bdfserver.commands.selection.SelectionDefRemoveCommand;
import fr.exemole.bdfserver.commands.selection.UserDefaultSelectionCommand;
import fr.exemole.bdfserver.commands.selection.UserSelectionByFicheCommand;
import fr.exemole.bdfserver.commands.selection.UserSelectionByMotcleCommand;
import fr.exemole.bdfserver.commands.selection.UserSelectionChangeCommand;
import net.mapeadores.util.request.RequestMap;

public class SelectionCommandFactory {
    private SelectionCommandFactory() {
    }

    public static BdfCommand getBdfCommand(BdfServer bdfServer, RequestMap requestMap, String commandName) {
        switch (commandName) {
            case "SelectionDefCreation": {
                return new SelectionDefCreationCommand(bdfServer, requestMap);
            }
            case "SelectionDefRemove": {
                return new SelectionDefRemoveCommand(bdfServer, requestMap);
            }
            case "SelectionDefChange": {
                return new SelectionDefChangeCommand(bdfServer, requestMap);
            }
            case "UserSelectionChange": {
                return new UserSelectionChangeCommand(bdfServer, requestMap);
            }
            case "UserDefaultSelection": {
                return new UserDefaultSelectionCommand(bdfServer, requestMap);
            }
            case "UserSelectionByFiche": {
                return new UserSelectionByFicheCommand(bdfServer, requestMap);
            }
            case "UserSelectionByMotcle": {
                return new UserSelectionByMotcleCommand(bdfServer, requestMap);
            }
            case "FqlParser": {
                return new FqlParserCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

