/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.tools.croisement.CroisementRemoveParser;
import net.fichotheque.tools.permission.PermissionPredicate;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CroisementRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CroisementRemove";
    public static final String COMMANDKEY = "_ ADD-08";
    public static final String REMOVE_PARAMNAME = "remove";
    private Document document;
    private CroisementChanges croisementChanges;

    public CroisementRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            session.getFichothequeEditor().getCroisementEditor().updateCroisements(this.document, this.croisementChanges);
        }
        this.putResultObject("obj.addenda", this.document.getAddenda());
        this.putResultObject("obj.document", this.document);
        this.setDone("_ done.addenda.croisementremove", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.document = this.requestHandler.getMandatoryDocument();
        this.getPermissionChecker().checkWrite(this.document);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        String[] values = this.requestHandler.getTokens(REMOVE_PARAMNAME);
        if (values.length == 0) {
            throw BdfErrors.error("_ error.empty.ficheselection");
        }
        this.croisementChanges = CroisementRemoveParser.parseRemove(values, this.fichotheque, PermissionPredicate.read(this.getPermissionSummary()));
    }
}

