/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.xml;

import java.awt.Color;
import java.text.ParseException;
import java.util.function.Consumer;
import net.desmodo.simplegrille.api.SimpleStructureBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.InvalidXMLException;
import org.w3c.dom.Element;

public class SimpleStructureDOMReader {
    private final SimpleStructureBuilder simpleStructureBuilder;

    public SimpleStructureDOMReader(SimpleStructureBuilder simpleStructureBuilder) {
        this.simpleStructureBuilder = simpleStructureBuilder;
    }

    public void readSimpleStructure(Element element) {
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer());
    }

    private Color getColor(Element element) {
        Color color = null;
        String colorString = element.getAttribute("color");
        if (colorString.length() > 0) {
            try {
                color = Color.decode(colorString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("langs")) {
                DOMUtils.readChildren((Element)element, (Consumer)new LangsConsumer());
            } else if (tagName.equals("simple-contexte-list")) {
                Color color;
                String name = element.getAttribute("name");
                if (name.length() == 0) {
                    name = "_default";
                }
                if ((color = SimpleStructureDOMReader.this.getColor(element)) != null) {
                    SimpleStructureDOMReader.this.simpleStructureBuilder.setContexteListColor(name, color);
                }
                DOMUtils.readChildren((Element)element, (Consumer)new SimpleContexteConsumer(name));
            } else if (tagName.equals("simple-descripteur-pere-list")) {
                DOMUtils.readChildren((Element)element, (Consumer)new SimpleDescripteurPereConsumer());
            } else if (tagName.equals("simple-famille-list")) {
                DOMUtils.readChildren((Element)element, (Consumer)new SimpleFamilleConsumer());
            }
        }
    }

    private class LangsConsumer
    implements Consumer<Element> {
        private LangsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lang")) {
                try {
                    Lang lang = Lang.parse((String)DOMUtils.readSimpleElement((Element)element));
                    SimpleStructureDOMReader.this.simpleStructureBuilder.addLang(lang);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class FamilleContentConsumer
    implements Consumer<Element> {
        private final int index;

        private FamilleContentConsumer(int index) {
            this.index = index;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        SimpleStructureDOMReader.this.simpleStructureBuilder.putFamilleLibelle(this.index, libelle);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class ContexteContentConsumer
    implements Consumer<Element> {
        private final int index;

        private ContexteContentConsumer(int index) {
            this.index = index;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        SimpleStructureDOMReader.this.simpleStructureBuilder.putContexteLibelle(this.index, libelle);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class DescripteurPereContentConsumer
    implements Consumer<Element> {
        private final int index;

        private DescripteurPereContentConsumer(int index) {
            this.index = index;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        SimpleStructureDOMReader.this.simpleStructureBuilder.putDescripteurPereLibelle(this.index, libelle);
                    }
                }
                catch (ParseException libelle) {}
            } else if (tagName.equals("fils-list-length")) {
                String idctxt = element.getAttribute("idctxt");
                if (idctxt.length() == 0) {
                    return;
                }
                String valueString = element.getAttribute("value");
                if (valueString.length() == 0) {
                    return;
                }
                try {
                    int value = Integer.parseInt(valueString);
                    if (value > 0) {
                        SimpleStructureDOMReader.this.simpleStructureBuilder.addListLengthValue(this.index, idctxt, value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private class SimpleFamilleConsumer
    implements Consumer<Element> {
        private SimpleFamilleConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("simple-famille")) {
                String idfamille = element.getAttribute("idfamille").trim();
                if (idfamille.length() == 0) {
                    throw new InvalidXMLException("missing idfamille attribute in simple-famille");
                }
                Color color = null;
                String colorString = element.getAttribute("color");
                if (colorString.length() > 0) {
                    try {
                        color = Color.decode(colorString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int index = SimpleStructureDOMReader.this.simpleStructureBuilder.addSimpleFamille(idfamille, color);
                DOMUtils.readChildren((Element)element, (Consumer)new FamilleContentConsumer(index));
            }
        }
    }

    private class SimpleDescripteurPereConsumer
    implements Consumer<Element> {
        private SimpleDescripteurPereConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("simple-descripteur-pere")) {
                String idfamille;
                String iddesc = element.getAttribute("iddesc");
                if (iddesc.length() == 0) {
                    throw new InvalidXMLException("missing iddesc attribute in simple-descripteur-pere");
                }
                String name = element.getAttribute("contexte-list-name");
                if (name.length() == 0) {
                    name = "_default";
                }
                if ((idfamille = element.getAttribute("idfamille")).length() == 0) {
                    idfamille = null;
                }
                int index = SimpleStructureDOMReader.this.simpleStructureBuilder.addSimpleDescripteurPere(iddesc, idfamille, name);
                DOMUtils.readChildren((Element)element, (Consumer)new DescripteurPereContentConsumer(index));
            }
        }
    }

    private class SimpleContexteConsumer
    implements Consumer<Element> {
        private final String name;

        private SimpleContexteConsumer(String name) {
            this.name = name;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("simple-contexte")) {
                String idctxt = element.getAttribute("idctxt");
                if (idctxt.length() == 0) {
                    throw new InvalidXMLException("missing idctxt attribute in simple-contexte");
                }
                Color color = SimpleStructureDOMReader.this.getColor(element);
                int index = SimpleStructureDOMReader.this.simpleStructureBuilder.addSimpleContexte(idctxt, color, this.name);
                DOMUtils.readChildren((Element)element, (Consumer)new ContexteContentConsumer(index));
            } else if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        SimpleStructureDOMReader.this.simpleStructureBuilder.putContexteListLibelle(this.name, libelle);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

