/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.analytique;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.AvenirDetail;
import fr.exemole.bdfext.scarabe.api.analytique.CustomLigneDef;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeColDefs;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.exportation.CategoryColumnDef;
import fr.exemole.bdfext.scarabe.tools.exportation.Columns;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.BH;
import java.util.List;
import java.util.Locale;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.primitives.RangeDateFilter;
import net.mapeadores.util.table.TableWriter;
import net.mapeadores.util.text.DateFormatBundle;

public class AnalytiqueDetailTableEngine
extends TableEngine {
    private final AnalytiqueDetails analytiqueDetails;
    private final AnalytiqueRecap analytiqueRecap;
    private final OdTableDef odTableDef;
    private final int columnLength;
    private final String title;
    private final Currencies currencies;
    private final int currencyLength;
    private final boolean withTotaux;
    private final boolean withLignes;
    private final boolean withRecap;
    private final Columns columns;
    private int beforeLignesIndex = -1;
    private int beforeAvenirIndex = -1;

    public AnalytiqueDetailTableEngine(AnalytiqueDetails analytiqueDetails, BdfParameters bdfParameters, ScarabeLocalisation scarabeLocalisation, AnalytiqueRecap analytiqueRecap, ScarabeContext scarabeContext) {
        super(scarabeLocalisation);
        int i;
        this.analytiqueDetails = analytiqueDetails;
        this.analytiqueRecap = analytiqueRecap;
        this.title = this.initTitle(scarabeLocalisation);
        this.currencies = analytiqueDetails.getCustomCurrencies();
        this.currencyLength = this.currencies.size();
        this.withRecap = analytiqueDetails.getAnalytiqueParameters().isDetailWithRecap();
        this.columns = Columns.build(bdfParameters, scarabeContext, scarabeLocalisation.getWorkingLang(), analytiqueDetails.getAnalytiqueSubset().getSubsetKey().getKeyString(), ScarabeColDefs.ANALYTIQUE_LIST);
        OdTableDefBuilder odTableDefBuilder = new OdTableDefBuilder("");
        int columnCount = this.columns.getCount();
        for (i = 0; i < columnCount; ++i) {
            if (this.columns.isNumeropiece(i)) {
                odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildStandard("PIECE"));
                continue;
            }
            short formatCast = this.columns.getFormatCast(i);
            if (formatCast == 3) {
                odTableDefBuilder.addDate();
                continue;
            }
            odTableDefBuilder.addStandard();
        }
        for (i = 0; i < this.currencyLength; ++i) {
            String category = "MIDDLE_MONTANT";
            if (i == this.currencyLength - 1) {
                category = "LAST_MONTANT";
            }
            odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildCurrency((ExtendedCurrency)this.currencies.get(i), category));
        }
        for (i = 0; i < this.currencyLength; ++i) {
            String category = "MIDDLE_MONTANT";
            if (i == this.currencyLength - 1) {
                category = "LAST_MONTANT";
            }
            odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildCurrency((ExtendedCurrency)this.currencies.get(i), category));
        }
        if (this.withRecap) {
            for (i = 0; i < this.currencyLength; ++i) {
                String category = "MIDDLE_MONTANT";
                if (i == this.currencyLength - 1) {
                    category = "LAST_MONTANT";
                }
                odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildCurrency((ExtendedCurrency)this.currencies.get(i), category));
            }
        }
        this.odTableDef = odTableDefBuilder.toOdTableDef();
        this.columnLength = columnCount;
        short filter = analytiqueDetails.getAnalytiqueParameters().getRowFilter();
        if (filter == 1) {
            this.withLignes = false;
            this.withTotaux = true;
        } else {
            this.withLignes = true;
            this.withTotaux = true;
        }
        if (analytiqueRecap != null) {
            List<Operation> operationList = analytiqueRecap.getOperationList();
            int operationLength = operationList.size();
            for (int i2 = 0; i2 < operationLength; ++i2) {
                OperationDef operationDef = operationList.get(i2).getOperationDef();
                if (!(operationDef instanceof CustomLigneDef)) continue;
                if (this.beforeLignesIndex == -1) {
                    this.beforeLignesIndex = i2;
                }
                if (!operationDef.getName().equals("_avenir_depense_") || this.beforeAvenirIndex != -1) continue;
                this.beforeAvenirIndex = i2;
            }
            if (this.beforeLignesIndex == -1) {
                this.beforeLignesIndex = 0;
            }
            if (this.beforeAvenirIndex == -1) {
                this.beforeAvenirIndex = this.beforeLignesIndex;
            }
        }
    }

    private String initTitle(ScarabeLocalisation scarabeLocalisation) {
        Lang workingLang = scarabeLocalisation.getWorkingLang();
        StringBuilder buf = new StringBuilder();
        if (this.analytiqueDetails instanceof ItemAnalytiqueDetails) {
            buf.append(ScarabeUtils.getLibelle(((ItemAnalytiqueDetails)this.analytiqueDetails).getAnalytiqueItem(), workingLang));
        } else {
            buf.append(FichothequeUtils.getTitle((Subset)this.analytiqueDetails.getAnalytiqueSubset().getSubset(), (Lang)workingLang));
        }
        RangeDateFilter rangeDateFilter = this.analytiqueDetails.getRangeDateFilter();
        if (rangeDateFilter != null) {
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle((Locale)scarabeLocalisation.getFormatLocale());
            buf.append(" / ");
            FuzzyDate min = rangeDateFilter.getMinDate();
            buf.append(min.getDateLitteral(dateFormatBundle));
            FuzzyDate max = rangeDateFilter.getMaxDate();
            if (!max.equals((Object)min)) {
                buf.append(" - ");
                buf.append(max.getDateLitteral(dateFormatBundle));
            }
        }
        return buf.toString();
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)101);
        tableWriter.addStringCell(this.title, this.columnLength);
        tableWriter.endRow();
        tableWriter.startRow((short)103);
        this.writeTitles(tableWriter, this.columns.getColDefList());
        tableWriter.addMessageCell("_ label.scarabe.debit", this.currencyLength, false);
        tableWriter.addMessageCell("_ label.scarabe.credit", this.currencyLength, false);
        if (this.withRecap) {
            tableWriter.addMessageCell("_ label.scarabe.solde_progressive", this.currencyLength, false);
        }
        tableWriter.endRow();
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        if (this.withRecap && this.analytiqueRecap != null) {
            if (this.beforeLignesIndex > 0) {
                this.printEmptyRow(tableWriter);
            }
            this.printOperation(tableWriter, 0, this.beforeLignesIndex);
        }
        boolean withAvenir = false;
        Total totalFinal = new Total(this.currencyLength, "");
        for (AnalytiqueDetail analytiqueDetail : this.analytiqueDetails.getAnalytiqueDetailList()) {
            Total soustotal = this.printLignes(tableWriter, analytiqueDetail, 1);
            totalFinal.addTotal(soustotal);
            if (analytiqueDetail.isAvenirEmpty()) continue;
            withAvenir = true;
        }
        if (!totalFinal.isEmpty()) {
            this.printTotalRow(tableWriter, (short)104, totalFinal, "_ label.scarabe.total_lignes");
            this.printEmptyRow(tableWriter);
        }
        if (this.withRecap && this.analytiqueRecap != null) {
            this.printOperation(tableWriter, this.beforeLignesIndex, this.beforeAvenirIndex);
        }
        if (withAvenir) {
            Total avenirTotalFinal = new Total(this.currencyLength, "");
            for (AnalytiqueDetail analytiqueDetail : this.analytiqueDetails.getAnalytiqueDetailList()) {
                Total soustotal = this.printAvenir(tableWriter, analytiqueDetail, 1);
                avenirTotalFinal.addTotal(soustotal);
            }
            this.printTotalRow(tableWriter, (short)109, avenirTotalFinal, "_ label.scarabe.total_avenir");
            if (!totalFinal.isEmpty()) {
                totalFinal.addTotal(avenirTotalFinal);
                this.printEmptyRow(tableWriter);
                this.printTotalRow(tableWriter, (short)104, totalFinal, "_ label.scarabe.total_tout");
            }
            this.printEmptyRow(tableWriter);
        }
        if (this.withRecap && this.analytiqueRecap != null) {
            this.printOperation(tableWriter, this.beforeAvenirIndex, this.analytiqueRecap.getOperationList().size());
        }
    }

    private void printOperation(ScarabeTableWriter tableWriter, int startIndex, int endIndex) {
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        List<Operation> operationList = this.analytiqueRecap.getOperationList();
        for (int i = startIndex; i < endIndex; ++i) {
            Operation operation = operationList.get(i);
            OperationDef operationDef = operation.getOperationDef();
            MoneyByCurrency moneyByCurrency = operation.getMoneyByCurrency();
            if (moneyByCurrency.isEmpty()) continue;
            if (operationDef instanceof AgregatDef) {
                tableWriter.startRow((short)113);
            } else {
                if (!(operationDef instanceof SoldeDef)) continue;
                tableWriter.startRow((short)114);
            }
            int columnCount = this.columns.getCount();
            for (int j = 0; j < columnCount; ++j) {
                if (this.columns.isLibelle(j)) {
                    if (!operationDef.getTitleLabels().isEmpty()) {
                        tableWriter.addStringCell(operationDef.getTitle(workingLang), 1, true);
                        continue;
                    }
                    if (operationDef instanceof SoldeDef) {
                        tableWriter.addMessageCell("_ label.scarabe.solde", 1, true);
                        continue;
                    }
                    if (operationDef instanceof CustomLigneDef) {
                        tableWriter.addMessageCell(AnalytiqueUtils.getLibelleKey(operationDef.getName()), 1, true);
                        continue;
                    }
                    tableWriter.addStringCell(operationDef.getName(), 1, true);
                    continue;
                }
                tableWriter.addNullCell(1);
            }
            this.addEmptyMoneyCells(tableWriter);
            this.addEmptyMoneyCells(tableWriter);
            this.printMoneyCell(tableWriter, moneyByCurrency, false);
            tableWriter.endRow();
            this.printEmptyRow(tableWriter);
        }
    }

    private Total printLignes(ScarabeTableWriter tableWriter, AnalytiqueDetail analytiqueDetail, int level) {
        MoneyByCurrency beforeStart = analytiqueDetail.getLignesBeforeStart();
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        Total totalIntermediaire = new Total(this.currencyLength, ScarabeUtils.getIdalpha(analytiqueDetail.getDetailObject(), workingLang));
        if (beforeStart != null && !beforeStart.isEmpty()) {
            totalIntermediaire.setBeforeStart(beforeStart);
        }
        if (analytiqueDetail.isLigneEmpty()) {
            return totalIntermediaire;
        }
        String libelle = ScarabeUtils.getLibelle(analytiqueDetail.getDetailObject(), workingLang);
        if (libelle.length() > 0) {
            tableWriter.startRow((short)105);
            tableWriter.addStringCell(libelle, this.columnLength);
            tableWriter.endRow();
        }
        boolean withSousTotaux = false;
        if (this.withRecap && !beforeStart.isEmpty()) {
            withSousTotaux = true;
            tableWriter.startRow((short)111);
            int columnCount = this.columns.getCount();
            for (int i = 0; i < columnCount; ++i) {
                if (this.columns.isLibelle(i)) {
                    tableWriter.addMessageCell("_ label.scarabe.datesanterieures");
                    continue;
                }
                tableWriter.addNullCell(1);
            }
            this.addEmptyMoneyCells(tableWriter);
            this.addEmptyMoneyCells(tableWriter);
            this.printMoneyCell(tableWriter, beforeStart, false);
            tableWriter.endRow();
        }
        for (LigneDetail ligneDetail : analytiqueDetail.getLigneDetailList()) {
            withSousTotaux = true;
            this.printLigneRow(tableWriter, ligneDetail, totalIntermediaire);
        }
        if (withSousTotaux) {
            this.printSousTotalRow(tableWriter, (short)104, totalIntermediaire, libelle);
        }
        boolean withIntermediaire = false;
        for (AnalytiqueDetail sousDetail : analytiqueDetail.getSubDetailList()) {
            Total sousTotal = this.printLignes(tableWriter, sousDetail, level + 1);
            if (sousTotal.isEmpty()) continue;
            totalIntermediaire.addTotal(sousTotal);
            withIntermediaire = true;
        }
        if (withIntermediaire) {
            this.printTotalIntermediaireRow(tableWriter, (short)104, totalIntermediaire);
        }
        return totalIntermediaire;
    }

    private void printLigneRow(ScarabeTableWriter tableWriter, LigneDetail ligneDetail, Total totalIntermediaire) {
        Ligne ligne = ligneDetail.getLigne();
        MoneyByCurrency moneyByCurrency = ligneDetail.getMoneyByCurrency();
        if (ligne.getComputeMoneyLong() < 0L) {
            totalIntermediaire.addDebit(moneyByCurrency);
        } else {
            totalIntermediaire.addCredit(moneyByCurrency);
        }
        if (!this.withLignes) {
            return;
        }
        tableWriter.startRow();
        this.columns.setCurrentFicheMeta(ligne.getFicheMeta());
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isDate(i)) {
                tableWriter.addDateCell(ligne.getDate());
                continue;
            }
            if (this.columns.isNumeropiece(i)) {
                tableWriter.addIntegerCell(ligne.getMouvement().getNumeropiece());
                continue;
            }
            if (this.columns.isId(i)) {
                String href = BH.domain((String)"edition").page("fiche-change").subsetItem((SubsetItem)ligne.getFicheMeta()).toString();
                String text = ScarabeUtils.getRaccourci(ligne.getLigneKey()) + "-" + String.valueOf(ligne.getId());
                tableWriter.addHrefCell(href, text);
                continue;
            }
            if (this.columns.isBeneficiaire(i)) {
                tableWriter.addStringCell(ligne.getBeneficiaireString());
                continue;
            }
            if (this.columns.isLibelle(i)) {
                tableWriter.addStringCell(ScarabeUtils.checkLibelle(ligne, this.getScarabeLocalisation()));
                continue;
            }
            this.columns.getCurrentCell(i).write((TableWriter)tableWriter);
        }
        if (ligne.getComputeMoneyLong() < 0L) {
            this.printMoneyCell(tableWriter, moneyByCurrency, true);
            this.addEmptyMoneyCells(tableWriter);
        } else {
            this.addEmptyMoneyCells(tableWriter);
            this.printMoneyCell(tableWriter, moneyByCurrency, false);
        }
        if (this.withRecap) {
            this.printMoneyCell(tableWriter, totalIntermediaire.getSoldeProgressif(), false);
        }
        tableWriter.endRow();
    }

    private Total printAvenir(ScarabeTableWriter tableWriter, AnalytiqueDetail analytiqueDetail, int level) {
        MoneyByCurrency beforeStart = analytiqueDetail.getAvenirBeforeStart();
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        Total totalIntermediaire = new Total(this.currencyLength, ScarabeUtils.getIdalpha(analytiqueDetail.getDetailObject(), workingLang));
        if (beforeStart != null && !beforeStart.isEmpty()) {
            totalIntermediaire.setBeforeStart(beforeStart);
        }
        if (analytiqueDetail.isAvenirEmpty()) {
            return totalIntermediaire;
        }
        String libelle = ScarabeUtils.getLibelle(analytiqueDetail.getDetailObject(), workingLang);
        if (libelle.length() > 0) {
            tableWriter.startRow((short)108);
            tableWriter.addStringCell(libelle, this.columnLength);
            tableWriter.endRow();
        }
        boolean withSousTotaux = false;
        if (this.withRecap && !beforeStart.isEmpty()) {
            withSousTotaux = true;
            tableWriter.startRow((short)112);
            int columnCount = this.columns.getCount();
            for (int i = 0; i < columnCount; ++i) {
                if (this.columns.isLibelle(i)) {
                    tableWriter.addMessageCell("_ label.scarabe.datesanterieures");
                    continue;
                }
                tableWriter.addNullCell(1);
            }
            this.addEmptyMoneyCells(tableWriter);
            this.addEmptyMoneyCells(tableWriter);
            this.printMoneyCell(tableWriter, beforeStart, false);
            tableWriter.endRow();
        }
        for (AvenirDetail avenirDetail : analytiqueDetail.getAvenirDetailList()) {
            withSousTotaux = true;
            this.printAvenirRow(tableWriter, avenirDetail, totalIntermediaire);
        }
        if (withSousTotaux) {
            this.printSousTotalRow(tableWriter, (short)109, totalIntermediaire, libelle);
        }
        boolean withIntermediaire = false;
        for (AnalytiqueDetail sousDetail : analytiqueDetail.getSubDetailList()) {
            Total sousTotal = this.printAvenir(tableWriter, sousDetail, level + 1);
            if (sousTotal.isEmpty()) continue;
            totalIntermediaire.addTotal(sousTotal);
            withIntermediaire = true;
        }
        if (withIntermediaire) {
            this.printTotalIntermediaireRow(tableWriter, (short)109, totalIntermediaire);
        }
        return totalIntermediaire;
    }

    private void printAvenirRow(ScarabeTableWriter tableWriter, AvenirDetail avenirDetail, Total totalIntermediaire) {
        Avenir avenir = avenirDetail.getAvenir();
        MoneyByCurrency moneyByCurrency = avenirDetail.getMoneyByCurrency();
        if (avenir.getComputeMoneyLong() < 0L) {
            totalIntermediaire.addDebit(moneyByCurrency);
        } else {
            totalIntermediaire.addCredit(moneyByCurrency);
        }
        if (!this.withLignes) {
            return;
        }
        tableWriter.startRow((short)110);
        this.columns.setCurrentFicheMeta(avenir.getFicheMeta());
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isDate(i)) {
                tableWriter.addDateCell(avenir.getDatePrevue());
                continue;
            }
            if (this.columns.isNumeropiece(i)) {
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isId(i)) {
                String href = BH.domain((String)"edition").page("fiche-change").subsetItem((SubsetItem)avenir.getFicheMeta()).toString();
                String text = "DF-" + String.valueOf(avenir.getFicheMeta().getId());
                tableWriter.addHrefCell(href, text);
                continue;
            }
            if (this.columns.isBeneficiaire(i)) {
                tableWriter.addStringCell(avenir.getBeneficiaireString());
                continue;
            }
            if (this.columns.isLibelle(i)) {
                tableWriter.addStringCell(avenir.getLibelle());
                continue;
            }
            this.columns.getCurrentCell(i).write((TableWriter)tableWriter);
        }
        if (avenir.getComputeMoneyLong() < 0L) {
            this.printMoneyCell(tableWriter, moneyByCurrency, true);
            this.addEmptyMoneyCells(tableWriter);
        } else {
            this.addEmptyMoneyCells(tableWriter);
            this.printMoneyCell(tableWriter, moneyByCurrency, false);
        }
        if (this.withRecap) {
            this.printMoneyCell(tableWriter, totalIntermediaire.getSoldeProgressif(), false);
        }
        tableWriter.endRow();
    }

    private void addEmptyMoneyCells(ScarabeTableWriter tableWriter) {
        for (int i = 0; i < this.currencyLength; ++i) {
            tableWriter.addNullCell(1);
        }
    }

    private void printMoneyCell(ScarabeTableWriter tableWriter, MoneyByCurrency moneyByCurrency, boolean opposite) {
        for (int i = 0; i < this.currencyLength; ++i) {
            if (moneyByCurrency.withMoney(i)) {
                long moneyLong = moneyByCurrency.getMoneyLong(i);
                if (opposite) {
                    moneyLong = -moneyLong;
                }
                tableWriter.addMoneyCell(moneyLong, (ExtendedCurrency)this.currencies.get(i));
                continue;
            }
            tableWriter.addNullCell(1);
        }
    }

    private void printTotalRow(ScarabeTableWriter tableWriter, short rowType, Total total, String messageKey) {
        if (!this.withTotaux) {
            return;
        }
        tableWriter.startRow(rowType);
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isLibelle(i)) {
                tableWriter.addMessageCell(messageKey);
                continue;
            }
            tableWriter.addNullCell(1);
        }
        this.printTotalCells(tableWriter, total);
        tableWriter.endRow();
    }

    private void printSousTotalRow(ScarabeTableWriter tableWriter, short rowType, Total total, String libelle) {
        if (!this.withTotaux) {
            return;
        }
        tableWriter.startRow(rowType);
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isLibelle(i)) {
                tableWriter.addStringCell(this.getScarabeLocalisation().getMessageLocalisation().toString("_ label.scarabe.soustotal", new Object[]{libelle}));
                continue;
            }
            tableWriter.addNullCell(1);
        }
        this.printTotalCells(tableWriter, total);
        tableWriter.endRow();
        this.printEmptyRow(tableWriter);
    }

    private void printTotalIntermediaireRow(ScarabeTableWriter tableWriter, short rowType, Total total) {
        if (!this.withTotaux) {
            return;
        }
        tableWriter.startRow(rowType);
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isLibelle(i)) {
                tableWriter.addStringCell(this.getScarabeLocalisation().getMessageLocalisation().toString("_ label.scarabe.totalintermediaire", new Object[]{total.getTotalIntermediaireIntitule()}));
                continue;
            }
            tableWriter.addNullCell(1);
        }
        this.printTotalCells(tableWriter, total);
        tableWriter.endRow();
        this.printEmptyRow(tableWriter);
    }

    private void printTotalCells(ScarabeTableWriter tableWriter, Total total) {
        this.printMoneyCell(tableWriter, total.debit, true);
        this.printMoneyCell(tableWriter, total.credit, false);
        if (this.withRecap) {
            this.printMoneyCell(tableWriter, total.getSoldeProgressif(), false);
        }
    }

    private void printEmptyRow(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)107);
        tableWriter.addStringCell("", this.columnLength);
        tableWriter.endRow();
    }

    private static class Total {
        private final MutableMoneyByCurrency debit;
        private final MutableMoneyByCurrency credit;
        private final MutableMoneyByCurrency soldeProgressif;
        private String intitule;
        private boolean empty = true;

        private Total(int currencyCount, String intitule) {
            this.debit = new MutableMoneyByCurrency(currencyCount);
            this.credit = new MutableMoneyByCurrency(currencyCount);
            this.soldeProgressif = new MutableMoneyByCurrency(currencyCount);
            this.intitule = intitule;
        }

        private void setBeforeStart(MoneyByCurrency beforeStart) {
            this.soldeProgressif.add(beforeStart);
        }

        private void addTotal(Total total) {
            if (total.isEmpty()) {
                return;
            }
            this.debit.add(total.debit);
            this.credit.add(total.credit);
            this.soldeProgressif.add(total.soldeProgressif);
            if (total.intitule.length() > 0) {
                this.intitule = this.intitule.length() == 0 ? total.intitule : this.intitule + " + " + total.intitule;
            }
            this.empty = false;
        }

        private void addDebit(MoneyByCurrency sousdebit) {
            this.soldeProgressif.add(sousdebit);
            this.debit.add(sousdebit);
            this.empty = false;
        }

        private void addCredit(MoneyByCurrency souscredit) {
            this.soldeProgressif.add(souscredit);
            this.credit.add(souscredit);
            this.empty = false;
        }

        private boolean isEmpty() {
            return this.empty;
        }

        private String getTotalIntermediaireIntitule() {
            return this.intitule;
        }

        private MoneyByCurrency getSoldeProgressif() {
            return this.soldeProgressif;
        }
    }
}

