/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.tools.core.BanqueBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;

public class BanquesBuilder {
    public static final Banques EMPTY_BANQUES;

    private BanquesBuilder() {
    }

    public static Banques init(AliasHolder coreAliasHolder) {
        boolean withErrors = false;
        HashMap<String, Banque> banqueMap = new HashMap<String, Banque>();
        ArrayList<Banque> banqueList = new ArrayList<Banque>();
        Thesaurus banqueThesaurus = coreAliasHolder.getThesaurus("banque");
        for (Motcle motcle : banqueThesaurus.getFirstLevelList()) {
            Banque banque = BanqueBuilder.init(motcle, coreAliasHolder);
            banqueList.add(banque);
            banqueMap.put(banque.getCodeBanque(), banque);
            if (!banque.hasError()) continue;
            withErrors = true;
        }
        Banque[] array = banqueList.toArray(new Banque[banqueList.size()]);
        return new InternalBanques(array, banqueMap, withErrors);
    }

    static {
        Map banqueMap = Collections.emptyMap();
        EMPTY_BANQUES = new InternalBanques(new Banque[0], banqueMap, false);
    }

    private static class InternalBanques
    extends AbstractList<Banque>
    implements Banques {
        private final Map<String, Banque> banqueMap;
        private final Banque[] array;
        private final boolean withErrors;

        private InternalBanques(Banque[] array, Map<String, Banque> banqueMap, boolean withErrors) {
            this.array = array;
            this.banqueMap = banqueMap;
            this.withErrors = withErrors;
        }

        @Override
        public Banque getBanqueByIdalpha(String idalpha) {
            return this.banqueMap.get(idalpha);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Banque get(int i) {
            return this.array[i];
        }

        @Override
        public boolean isWithErrors() {
            return this.withErrors;
        }
    }
}

