/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyChronology;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.primitives.FuzzyDate;

class MoneyChronologyBuilder {
    private final int currencyLength;
    private final MutableMoneyByCurrency moneyByCurrency;
    private final SortedMap<Integer, YearBuilder> yearMap = new TreeMap<Integer, YearBuilder>();

    MoneyChronologyBuilder(int currencyLength) {
        this.currencyLength = currencyLength;
        this.moneyByCurrency = new MutableMoneyByCurrency(currencyLength);
    }

    MoneyByCurrency getMoneyByCurrency() {
        return this.moneyByCurrency;
    }

    void add(int currencyIndex, long moneyLong, FuzzyDate fuzzyDate) {
        this.moneyByCurrency.add(currencyIndex, moneyLong);
        this.getYearBuilder(fuzzyDate.getYear()).add(currencyIndex, moneyLong, fuzzyDate.getMonth());
    }

    void add(MoneyChronology moneyChronology) {
        this.moneyByCurrency.add(moneyChronology.getMoneyByCurrency());
        for (MoneyChronology.Year yearObj : moneyChronology.getYearList()) {
            YearBuilder yearBuilder = this.getYearBuilder(yearObj.getYear());
            yearBuilder.montant.add(yearObj.getMoneyByCurrency());
            for (MoneyChronology.Month month : yearObj.getMonthList()) {
                yearBuilder.getMonthMontant(month.getMonth()).add(month.getMoneyByCurrency());
            }
        }
    }

    MoneyChronology toMoneyChronology() {
        MoneyChronology.Year[] yearArray = new MoneyChronology.Year[this.yearMap.size()];
        int p = 0;
        for (YearBuilder yearBuilder : this.yearMap.values()) {
            yearArray[p] = yearBuilder.toYear();
            ++p;
        }
        return new InternalMoneyChronology(this.moneyByCurrency.toUnmodifiableMoneyByCurrency(), AnalytiqueUtils.wrap(yearArray));
    }

    private YearBuilder getYearBuilder(int year) {
        YearBuilder yearBuilder = (YearBuilder)this.yearMap.get(year);
        if (yearBuilder == null) {
            yearBuilder = new YearBuilder(year, this.currencyLength);
            this.yearMap.put(year, yearBuilder);
        }
        return yearBuilder;
    }

    private static class YearBuilder {
        private final int year;
        private final int currencyLength;
        private final MutableMoneyByCurrency montant;
        private final SortedMap<Integer, MutableMoneyByCurrency> monthMap = new TreeMap<Integer, MutableMoneyByCurrency>();

        private YearBuilder(int year, int currencyLength) {
            this.year = year;
            this.currencyLength = currencyLength;
            this.montant = new MutableMoneyByCurrency(currencyLength);
        }

        private void add(int currencyIndex, long moneyLong, int month) {
            this.montant.add(currencyIndex, moneyLong);
            this.getMonthMontant(month).add(currencyIndex, moneyLong);
        }

        private MoneyChronology.Year toYear() {
            int p = 0;
            MoneyChronology.Month[] monthArray = new MoneyChronology.Month[this.monthMap.size()];
            for (Map.Entry<Integer, MutableMoneyByCurrency> entry : this.monthMap.entrySet()) {
                monthArray[p] = new InternalMonth(entry.getKey(), entry.getValue().toUnmodifiableMoneyByCurrency());
                ++p;
            }
            return new InternalYear(this.year, this.montant, AnalytiqueUtils.wrap(monthArray));
        }

        private MutableMoneyByCurrency getMonthMontant(int month) {
            MutableMoneyByCurrency monthMontant = (MutableMoneyByCurrency)this.monthMap.get(month);
            if (monthMontant == null) {
                monthMontant = new MutableMoneyByCurrency(this.currencyLength);
                this.monthMap.put(month, monthMontant);
            }
            return monthMontant;
        }
    }

    private static class InternalMoneyChronology
    implements MoneyChronology {
        private final MoneyByCurrency moneyByCurrency;
        private final List<MoneyChronology.Year> yearList;

        private InternalMoneyChronology(MoneyByCurrency moneyByCurrency, List<MoneyChronology.Year> yearList) {
            this.moneyByCurrency = moneyByCurrency;
            this.yearList = yearList;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }

        @Override
        public List<MoneyChronology.Year> getYearList() {
            return this.yearList;
        }
    }

    private static class InternalMonth
    implements MoneyChronology.Month {
        private final int month;
        private final MoneyByCurrency moneyByCurrency;

        private InternalMonth(int month, MoneyByCurrency moneyByCurrency) {
            this.month = month;
            this.moneyByCurrency = moneyByCurrency;
        }

        @Override
        public int getMonth() {
            return this.month;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }
    }

    private static class InternalYear
    implements MoneyChronology.Year {
        private final int year;
        private final MoneyByCurrency moneyByCurrency;
        private final List<MoneyChronology.Month> monthList;

        private InternalYear(int year, MoneyByCurrency moneyByCurrency, List<MoneyChronology.Month> monthList) {
            this.year = year;
            this.moneyByCurrency = moneyByCurrency;
            this.monthList = monthList;
        }

        @Override
        public int getYear() {
            return this.year;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }

        @Override
        public List<MoneyChronology.Month> getMonthList() {
            return this.monthList;
        }
    }
}

