/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.selection;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.commands.SelectionParameters;
import fr.exemole.bdfext.scarabe.selection.ScarabeSelectionUtils;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.FieldTest;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.FieldTestFactory;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DecimalLong;
import net.mapeadores.util.primitives.DecimalLongFilter;

public class LigneFicheSelector
implements FicheSelector {
    private final BdfServer bdfServer;
    private final ScarabeContext scarabeContext;
    private final BdfUser bdfUser;
    private final Lang lang;
    private final SelectionParameters selectionParameters;
    private final List<Corpus> corpusList = new ArrayList<Corpus>();
    private final Map<SubsetKey, CorpusBuffer> corpusBufferMap = new HashMap<SubsetKey, CorpusBuffer>();

    public LigneFicheSelector(BdfServer bdfServer, ScarabeContext scarabeContext, BdfUser bdfUser, SelectionParameters selectionParameters) {
        this.bdfServer = bdfServer;
        this.scarabeContext = scarabeContext;
        this.bdfUser = bdfUser;
        this.lang = bdfUser.getWorkingLang();
        this.selectionParameters = selectionParameters;
        this.initCorpusBuffer("depense");
        this.initCorpusBuffer("apport");
        this.initCorpusBuffer("avance");
    }

    private void initCorpusBuffer(String alias) {
        AliasHolder coreAliasHolder = this.scarabeContext.getCoreAliasHolder();
        ArrayList<FieldTest> list = new ArrayList<FieldTest>();
        DecimalLongFilter montantLongFilter = (DecimalLongFilter)this.selectionParameters.getValue("montant");
        if (montantLongFilter != null) {
            CorpusField montantCorpusField = CoreUtils.getMontant(coreAliasHolder, alias);
            if (montantCorpusField == null) {
                list.add(FieldTestFactory.FALSE_FIELDTEST);
            } else {
                list.add(new MontantFieldTest(montantCorpusField.getFieldKey(), montantLongFilter));
            }
        }
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder((BdfServer)this.bdfServer, (Lang)this.lang).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        ScarabeSelectionUtils.addFieldTest(list, (TextCondition)this.selectionParameters.getValue("beneficiaire"), selectionContext, CoreUtils.getBeneficiaire(coreAliasHolder, alias));
        ScarabeSelectionUtils.addFieldTest(list, (TextCondition)this.selectionParameters.getValue("libelle"), selectionContext, CoreUtils.getLibelle(coreAliasHolder, alias));
        ScarabeSelectionUtils.addFieldTest(list, this.selectionParameters.getValue("date"), CoreUtils.getDate(coreAliasHolder, alias));
        ScarabeSelectionUtils.addFieldTest(list, this.selectionParameters.getValue("periode"), CoreUtils.getPeriode(coreAliasHolder, alias));
        ScarabeSelectionUtils.addFieldTest(list, this.selectionParameters.getValue("dateprevue"), CoreUtils.getDateprevue(coreAliasHolder, alias));
        int size = list.size();
        FieldTest[] array = new FieldTest[size];
        for (int i = 0; i < size; ++i) {
            FieldTest fieldTest = (FieldTest)list.get(i);
            if (fieldTest.equals(FieldTestFactory.FALSE_FIELDTEST)) {
                return;
            }
            array[i] = fieldTest;
        }
        Corpus corpus = coreAliasHolder.getCorpus(alias);
        CorpusBuffer corpusBuffer = new CorpusBuffer(corpus, array);
        this.corpusBufferMap.put(corpusBuffer.getCorpus().getSubsetKey(), corpusBuffer);
        this.corpusList.add(corpus);
    }

    public List<Corpus> getCorpusList() {
        return Collections.unmodifiableList(this.corpusList);
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public Croisement isSelected(FicheMeta ficheMeta, Croisement croisement) {
        if (this.test(ficheMeta)) {
            return croisement;
        }
        return null;
    }

    public boolean test(FicheMeta ficheMeta) {
        CorpusBuffer corpusBuffer = this.corpusBufferMap.get(ficheMeta.getSubsetKey());
        if (corpusBuffer == null) {
            return false;
        }
        return corpusBuffer.isSelected(ficheMeta);
    }

    private static class MontantFieldTest
    implements FieldTest {
        private final FieldKey montantFieldKey;
        private final DecimalLongFilter montantLongFilter;

        private MontantFieldTest(FieldKey montantFieldKey, DecimalLongFilter montantLongFilter) {
            this.montantFieldKey = montantFieldKey;
            this.montantLongFilter = montantLongFilter;
        }

        public boolean success(FichePointeur fichePointeur) {
            AmountItem montant = PointeurUtils.getAmount((FichePointeur)fichePointeur, (FieldKey)this.montantFieldKey);
            if (montant == null) {
                return false;
            }
            long lg = Math.abs(DecimalLong.toDecimalLong((Decimal)montant.getDecimal()));
            return this.montantLongFilter.containsDecimalLong(lg);
        }
    }

    private static class CorpusBuffer {
        private final Corpus corpus;
        private final FichePointeur fichePointeur;
        private final FieldTest[] fieldTestArray;

        private CorpusBuffer(Corpus corpus, FieldTest[] fieldTestArray) {
            this.corpus = corpus;
            this.fieldTestArray = fieldTestArray;
            this.fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus);
        }

        private Corpus getCorpus() {
            return this.corpus;
        }

        private boolean isSelected(FicheMeta ficheMeta) {
            this.fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            for (FieldTest fieldTest : this.fieldTestArray) {
                if (fieldTest.success(this.fichePointeur)) continue;
                return false;
            }
            return true;
        }
    }
}

