/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.instructions;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenExportLogHandler;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.ExportEngine;
import fr.exemole.bdfext.scarabe.tools.comptagen.writers.CegidComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.writers.FecComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.writers.SageComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.writers.WinbizComptagenWriter;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.metadata.CorpusField;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.TextStreamProducer;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.DateFilter;
import net.mapeadores.util.primitives.DateFilterUtils;
import net.mapeadores.util.primitives.RangeDateFilter;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;

public class ComptagenEngine {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final ScarabeContext scarabeContext;
    private final String type;
    private final boolean download;
    private boolean selection = false;
    private DateFilter dateIntegerFilter;
    private boolean ignoreErrors = false;
    private final ExtendedCurrency exportCurrency;

    private ComptagenEngine(BdfParameters bdfParameters, ScarabeContext scarabeContext, String type, ExtendedCurrency exportCurrency, boolean download) {
        this.bdfServer = bdfParameters.getBdfServer();
        this.bdfUser = bdfParameters.getBdfUser();
        this.scarabeContext = scarabeContext;
        this.type = type;
        this.exportCurrency = exportCurrency;
        this.download = download;
    }

    private void setSelection(boolean selection) {
        this.selection = selection;
    }

    private void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    private void setDateIntegerFilter(DateFilter dateIntegerFilter) {
        this.dateIntegerFilter = dateIntegerFilter;
    }

    public ResponseHandler run() {
        MessageLocalisation messageLocalisation = this.bdfServer.getL10nManager().getMessageLocalisation((UserLangContext)this.bdfUser);
        InternalComptagenExportLogHandler comptagenExportLogHandler = new InternalComptagenExportLogHandler(messageLocalisation);
        List<ComptagenLigne> result = ExportEngine.run(this.bdfServer, this.bdfUser, this.scarabeContext, this.exportCurrency, this.dateIntegerFilter, this.selection, comptagenExportLogHandler);
        if (comptagenExportLogHandler.hasError() && !this.ignoreErrors) {
            return SimpleResponseHandler.init((String)("-------- " + messageLocalisation.toString("_ title.scarabe.exportationerrors") + " -------------\n" + comptagenExportLogHandler.errorsToString()));
        }
        if (result.isEmpty()) {
            return SimpleResponseHandler.init((String)("-------- " + messageLocalisation.toString("_ warning.scarabe.emptyresult") + " -------------"));
        }
        StringBuilder appendable = new StringBuilder();
        ComptagenWriter writer = this.getComptagenWriter(this.type, appendable, this.exportCurrency.getDefaultFractionDigits());
        try {
            writer.writeColumns();
            for (ComptagenLigne ligne : result) {
                writer.writeLigne(ligne);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String charset = writer.getCharset();
        String text = appendable.toString();
        if (this.download) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.type);
            buf.append("-");
            buf.append(this.bdfServer.getFichotheque().getFichothequeMetadata().getBaseName());
            buf.append(".");
            buf.append(dateFormat.format(new Date()));
            buf.append(writer.getExtension());
            TextStreamProducer textStreamProducer = new TextStreamProducer(text, buf.toString(), charset);
            return StreamResponseHandler.init((StreamProducer)textStreamProducer);
        }
        return SimpleResponseHandler.init((String)text).charset(charset);
    }

    public static ComptagenEngine buildFromRequest(BdfParameters bdfParameters, RequestMap requestMap, ScarabeContext scarabeContext) throws ErrorMessageException {
        String periodeString;
        ExtendedCurrency exportCurrency;
        String type = requestMap.getParameter("type");
        if (type == null) {
            throw BdfErrors.emptyMandatoryParameter((String)"type");
        }
        if (!ComptagenEngine.checkType(type)) {
            throw BdfErrors.unknownParameterValue((String)"type", (String)type);
        }
        String monnaieString = requestMap.getParameter("monnaie");
        if (monnaieString != null && monnaieString.length() > 0) {
            try {
                exportCurrency = ExtendedCurrency.parse((String)monnaieString);
            }
            catch (ParseException pe) {
                throw BdfErrors.unknownParameterValue((String)"monnaie", (String)monnaieString);
            }
        } else {
            exportCurrency = ComptagenEngine.getDefaultCurrency(scarabeContext.getCoreAliasHolder());
        }
        boolean download = requestMap.isTrue("download");
        ComptagenEngine comptagenEngine = new ComptagenEngine(bdfParameters, scarabeContext, type, exportCurrency, download);
        String[] filtreArray = requestMap.getParameterValues("filtre");
        if (filtreArray != null) {
            for (String val : filtreArray) {
                if (val.equals("selection")) {
                    comptagenEngine.setSelection(true);
                    continue;
                }
                if (!val.equals("ignore-errors")) continue;
                comptagenEngine.setIgnoreErrors(true);
            }
        }
        if ((periodeString = requestMap.getParameter("periode")) != null) {
            try {
                RangeDateFilter dateIntegerFilter = DateFilterUtils.parseDateFilter((String)periodeString);
                comptagenEngine.setDateIntegerFilter((DateFilter)dateIntegerFilter);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue((String)"periode", (String)periodeString);
            }
        }
        return comptagenEngine;
    }

    private static boolean checkType(String type) {
        switch (type) {
            case "sage": 
            case "winbiz": 
            case "cegid": 
            case "fec": {
                return true;
            }
        }
        return false;
    }

    private ComptagenWriter getComptagenWriter(String type, Appendable appendable, int exportFractionDigits) {
        AliasHolder coreAliasHolder = this.scarabeContext.getCoreAliasHolder();
        switch (type) {
            case "sage": {
                return new SageComptagenWriter(appendable, coreAliasHolder, exportFractionDigits);
            }
            case "winbiz": {
                return new WinbizComptagenWriter(appendable, coreAliasHolder, exportFractionDigits);
            }
            case "cegid": {
                return new CegidComptagenWriter(appendable, coreAliasHolder, exportFractionDigits);
            }
            case "fec": {
                return new FecComptagenWriter(appendable, coreAliasHolder, exportFractionDigits);
            }
        }
        throw new SwitchException("Unknown type : " + type);
    }

    private static ExtendedCurrency getDefaultCurrency(AliasHolder coreAliasHolder) {
        CorpusField reportField = coreAliasHolder.getCorpusField("banque_montantreport");
        Currencies currencies = reportField.getCurrencies();
        if (currencies == null) {
            throw new IllegalStateException("Currency Not defined");
        }
        return (ExtendedCurrency)currencies.get(0);
    }

    private static class InternalComptagenExportLogHandler
    implements ComptagenExportLogHandler {
        private final MessageLocalisation messageLocalisation;
        private boolean hasError = false;
        private final StringBuilder errorBuf = new StringBuilder();

        private InternalComptagenExportLogHandler(MessageLocalisation messageLocalisation) {
            this.messageLocalisation = messageLocalisation;
        }

        @Override
        public void emptySelection() {
        }

        @Override
        public void excludeMouvement(int id, List<Message> errorMessageList) {
            this.appendFicheError("mouvement", id);
        }

        @Override
        public void excludeMouvement(int id, String causeKey) {
            this.appendFicheError("mouvement", id);
        }

        @Override
        public void noContrepartie(String banqueIdalpha) {
            this.hasError = true;
            this.errorBuf.append(this.messageLocalisation.toString("_ error.empty.scarabe.contrepartie", new Object[]{banqueIdalpha}));
            this.errorBuf.append("\n");
        }

        @Override
        public void excludeLigne(String alias, int id, List<Message> errorMessageList) {
            this.appendFicheError(alias, id);
        }

        @Override
        public void excludeLigne(String alias, int id, String causeKey) {
            if (causeKey.equals("PLANCOMPTABLE_NONE")) {
                this.appendError("_ error.empty.scarabe.plancomptable", alias, id, null);
            } else if (causeKey.equals("DOUBLON_CONTREPARTIE")) {
                this.appendError("_ error.unsupported.scarabe.doubloncontrepartie", alias, id, null);
            } else if (causeKey.equals("COURSALIAS_NONE")) {
                this.appendError("_ error.empty.scarabe.coursalias", alias, id, null);
            } else if (causeKey.equals("MONEYCONVERSION_NONE")) {
                this.appendError("_ error.empty.scarabe.moneyconversion", alias, id, null);
            } else {
                this.appendError("_ error.unsupported.scarabe.ficheerror_one", alias, id, causeKey);
            }
        }

        @Override
        public void noCompteTiersAttribute(String compteTiersIdalpha, AttributeKey attributeKey) {
            this.hasError = true;
            this.errorBuf.append(this.messageLocalisation.toString("_ error.empty.scarabe.comptetiersattribute", new Object[]{compteTiersIdalpha, attributeKey.toString()}));
            this.errorBuf.append("\n");
        }

        private boolean hasError() {
            return this.hasError;
        }

        private String errorsToString() {
            return this.errorBuf.toString();
        }

        private void appendFicheError(String alias, int id) {
            this.appendError("_ error.unsupported.scarabe.ficheerror_many", alias, id, null);
        }

        private void appendError(String errorMessageKey, String alias, int id, String cause) {
            this.hasError = true;
            String text = this.messageLocalisation.toString(InternalComptagenExportLogHandler.toMessageKey(alias));
            if (cause != null) {
                this.errorBuf.append(this.messageLocalisation.toString(errorMessageKey, new Object[]{text, id, cause}));
            } else {
                this.errorBuf.append(this.messageLocalisation.toString(errorMessageKey, new Object[]{text, id}));
            }
            this.errorBuf.append("\n");
        }

        private static String toMessageKey(String alias) {
            if (alias.equals("depense")) {
                return "_ label.scarabe.fiche_depense";
            }
            if (alias.equals("apport")) {
                return "_ label.scarabe.fiche_apport";
            }
            if (alias.equals("avance")) {
                return "_ label.scarabe.fiche_avance";
            }
            if (alias.equals("mouvement")) {
                return "_ label.scarabe.fiche_mouvement";
            }
            return null;
        }
    }
}

