<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : xslt-carto0.9.xsl
    Created on : 26 mai 2005, 09:48
    Author     : vic
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" indent="yes"/>

    <xsl:template match="/">
    <xsl:apply-templates select="cartoxml"/>
    </xsl:template>
    
    <xsl:template match="cartoxml">
        <carto version="0.9.7">
        <conf>
        <xsl:apply-templates select="parametrescarto" />
        </conf>
        <atlas>
        <structure>
            <xsl:apply-templates select="structure/thesaurus" mode="grille"/>
            <familles>
            <xsl:apply-templates select="descripteurs" mode="familles"/>
            </familles>
        </structure>
        <descripteurs>
        <xsl:apply-templates select="descripteurs" mode="descripteurs"/>
        </descripteurs>
        <liens>
        <liensstructurels>
            <xsl:apply-templates select="liens/lienstermesstructure/lts"/>
        </liensstructurels>
        <lienssymetriques>
            <xsl:apply-templates select="liens/lienssymetriques/ls"/>
        </lienssymetriques>
        <lienshierarchiques>
        <xsl:apply-templates select="liens/lienshierarchiques/lhs"/>
        </lienshierarchiques>
        </liens>
        </atlas>

        
        </carto>
    </xsl:template>
    
    <xsl:template match="parametrescarto">
    </xsl:template>
    
    <xsl:template match="thesaurus" mode="grille">
        <grille nomgrille="{@nomthesaurus}">
        <xsl:apply-templates select="thesaurusmetadata/langs/lang"/>
        <xsl:apply-templates select="mtcl" mode="contexte"/>
        </grille>
    </xsl:template>
    
    <xsl:template match="lang">
    <xsl:variable name="Lang" select="string(.)"/>
    <lib xml:lang="{$Lang}"><xsl:value-of select="../../intitules/intitule[@xml:lang=$Lang]"/><xsl:value-of select="../../intitules/intitule[@lang=$Lang]"/></lib>
    </xsl:template>
    
    <xsl:template match="mtcl" mode="contexte">
    <contexte idctxt="{@idths}">
        <xsl:apply-templates select="lib"/>
        <xsl:apply-templates select="mtcl" mode="contexte"/>
    </contexte>
    </xsl:template>
    
    <xsl:template match="lib">
    <lib>
    <xsl:attribute name="xml:lang"><xsl:choose><xsl:when test="string-length(@xml:lang) &gt; 0"><xsl:value-of select="@xml:lang"/></xsl:when><xsl:otherwise><xsl:value-of select="@lang"/></xsl:otherwise></xsl:choose></xsl:attribute>
    <xsl:attribute name="vo"><xsl:choose><xsl:when test="(@original = 0) or (@original = 'true')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute>
    <xsl:value-of select="."/></lib>
    </xsl:template>
    
    <xsl:template match="descripteurs" mode="familles">
        <xsl:apply-templates select="descfamille" mode="contexte"/>
    </xsl:template>
    
     <xsl:template match="descripteurs" mode="descripteurs">
        <xsl:apply-templates select="descfamille" mode="descripteurs"/>
        <xsl:apply-templates select="sansfamille"/>
    </xsl:template>
    
    <xsl:template match="descfamille" mode="contexte">
    <contexte idctxt="{@iddesc}">
        <color><xsl:value-of select="color"/></color>
        <xsl:apply-templates select="lib"/>
    </contexte>
    </xsl:template>
    
    <xsl:template match="descfamille" mode="descripteurs">
    <infamille idctxt="{@iddesc}">
        <xsl:apply-templates select="desc"/>
    </infamille>
    </xsl:template>
    
    <xsl:template match="sansfamille" >
    <sansfamille>
        <xsl:apply-templates select="desc"/>
    </sansfamille>
    </xsl:template>
    
    <xsl:template match="desc" >
    <descripteur iddesc="{@iddesc}">
        <xsl:apply-templates select="lib"/>
    </descripteur>
    </xsl:template>
    
    <xsl:template match="lts">
    <lst>
    <ctxt grl="{@ths1}" idctxt="{@idths1}"/>
    <ctxt grl="{@ths2}" idctxt="{@idths2}"/>
    <xsl:apply-templates select="dsc"/>
    </lst>
    </xsl:template>
    
    <xsl:template match="dsc">
    <desc iddesc="{@iddesc}"/>
    </xsl:template>
    
    <xsl:template match="ls">
    <lsm>
        <desc-ctxt>
            <desc iddesc="{@iddesc1}"/>
            <ctxt grl="{@thsctxt1}" idctxt="{@idctxt1}"/>
        </desc-ctxt>
        <desc-ctxt>
            <desc iddesc="{@iddesc2}"/>
            <ctxt grl="{@thsctxt2}" idctxt="{@idctxt2}"/>
        </desc-ctxt>
    </lsm>
    </xsl:template>
    
    <xsl:template match="lhs">
    <lhg>
    <desc-ctxt>
            <desc iddesc="{@iddesc}"/>
            <ctxt grl="{@thsctxt}" idctxt="{@idctxt}"/>
    </desc-ctxt>
    <xsl:apply-templates select="dsc"/>
    </lhg>
    </xsl:template>

</xsl:stylesheet>
