/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.dsmd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.stream.StreamSource;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.TermSpaceManager;
import net.desmodo.atlas.conf.ConfXMLPart;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.io.AtlasIO;
import net.desmodo.atlas.io.AtlasIOException;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.xml.api.AtlasXMLPart;
import net.desmodo.atlas.xml.dsmd.DsmdConstants;
import net.desmodo.atlas.xml.dsmd.DsmdDOMErrorHandler;
import net.desmodo.atlas.xml.dsmd.DsmdDOMReader;
import net.desmodo.atlas.xml.dsmd.DsmdXMLPart;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DsmdIO
implements DsmdConstants,
SessionConfKeys {
    public static final TermSpaceManager DEFAULT_TERMSPACEMANAGER = new DefaultTermSpaceManager();

    private DsmdIO() {
    }

    public static void parseDocument(Document document, SessionSource sessionSource, DsmdDOMErrorHandler errorHandler) {
        Element root = document.getDocumentElement();
        String tagName = root.getTagName();
        if (tagName.equals("dsmd")) {
            DsmdDOMReader dsmdDOMReader = new DsmdDOMReader(sessionSource, errorHandler);
            dsmdDOMReader.readDsmd(root);
        } else if (tagName.equals("carto")) {
            DsmdDOMReader dsmdDOMReader = new DsmdDOMReader(sessionSource, errorHandler);
            dsmdDOMReader.setOldCrtxml(true);
            dsmdDOMReader.readDsmd(root);
        } else if (tagName.equals("cartoxml")) {
            StreamSource sourcexsl;
            InputStream is;
            if (root.getAttribute("version").equals("0.9")) {
                is = DsmdIO.class.getResourceAsStream("crtxml/cartoxml-0.9.xsl");
                if (is == null) {
                    throw new InternalResourceException("missingRessource : xslt/cartoxml-0.9.xsl is missing");
                }
                sourcexsl = new StreamSource(is);
            } else {
                is = DsmdIO.class.getResourceAsStream("crtxml/cartoxml-0.8.xsl");
                if (is == null) {
                    throw new InternalResourceException("missingRessource : xslt/cartoxml-0.8.xsl is missing");
                }
                sourcexsl = new StreamSource(is);
            }
            try {
                document = AtlasIO.transform(document, sourcexsl);
            }
            catch (AtlasIOException aie) {
                throw new InternalResourceException((Exception)aie);
            }
            DsmdDOMReader dsmdDOMReader = new DsmdDOMReader(sessionSource, errorHandler);
            dsmdDOMReader.setOldCrtxml(true);
            dsmdDOMReader.readDsmd(document.getDocumentElement());
        } else {
            errorHandler.unknownRootElement(tagName);
        }
    }

    public static void saveSession(Session session, File f) throws IOException {
        DsmdIO.saveSession(session.getAtlas(), session.getSessionConf(), f);
    }

    public static void saveSession(Atlas atlas, SessionConf sessionConf, File f) throws IOException {
        AtlasFilter atlasFilter = AtlasUtils.ACCEPTALL_ATLASFILTER;
        String name = f.getName();
        if (name.endsWith(".crtxml")) {
            DsmdIO.saveToCrtxml(f, sessionConf, atlas, atlasFilter);
        } else {
            DsmdIO.saveToDsmd(f, sessionConf, atlas, atlasFilter);
        }
    }

    public static void saveTemplate(Session session, File f, VentilationName homeVentilationName) throws IOException {
        SessionConf sessionConf = new SessionConf(session.getSessionConf());
        sessionConf.setBoolean("file.template", true);
        sessionConf.setString("home.ventilationname", homeVentilationName.toUriString());
        sessionConf.setString("home.ventilationroot", "special:null");
        sessionConf.setBoolean("ignore.empty.secteur", false);
        Atlas atlas = session.getAtlas();
        AtlasFilter atlasFilter = AtlasUtils.ONLYSTRUCTURE_ATLASFILTER;
        String name = f.getName();
        if (name.endsWith(".crtxml")) {
            DsmdIO.saveToCrtxml(f, sessionConf, atlas, atlasFilter);
        } else {
            DsmdIO.saveToDsmd(f, sessionConf, atlas, atlasFilter);
        }
    }

    private static void saveToDsmd(File f, SessionConf sc, Atlas atlas, AtlasFilter atlasFilter) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter((Appendable)writer);
        xmlWriter.appendXMLDeclaration();
        DsmdXMLPart dxp = new DsmdXMLPart((XMLWriter)xmlWriter, DEFAULT_TERMSPACEMANAGER, atlasFilter, null);
        dxp.addDsmd(sc, atlas);
        writer.close();
    }

    private static void saveToCrtxml(File f, SessionConf sc, Atlas atlas, AtlasFilter atlasFilter) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter((Appendable)writer);
        xmlWriter.appendXMLDeclaration();
        xmlWriter.startOpenTag("carto");
        xmlWriter.addAttribute("version", "0.9.8");
        xmlWriter.endOpenTag();
        ConfXMLPart cxp = new ConfXMLPart((XMLWriter)xmlWriter);
        cxp.addConf(sc);
        AtlasXMLPart axm = new AtlasXMLPart((XMLWriter)xmlWriter, DEFAULT_TERMSPACEMANAGER, atlasFilter, null);
        axm.setOldCrtxml(true);
        axm.addAtlas(atlas);
        xmlWriter.closeTag("carto");
        writer.close();
    }

    private static class DefaultTermSpaceManager
    implements TermSpaceManager {
        private DefaultTermSpaceManager() {
        }

        @Override
        public String toString(Iddesc iddesc) {
            return iddesc.toString();
        }
    }
}

