/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.dsmd;

import java.util.function.Consumer;
import net.desmodo.atlas.conf.ConfDOMErrorHandler;
import net.desmodo.atlas.conf.ConfDOMReader;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.xml.api.AtlasDOMReader;
import net.desmodo.atlas.xml.dsmd.DsmdConstants;
import net.desmodo.atlas.xml.dsmd.DsmdDOMErrorHandler;
import net.desmodo.atlas.xml.dsmd.crtxml.ReferencesDOMReader;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class DsmdDOMReader
implements DsmdConstants {
    private final DsmdDOMErrorHandler errorHandler;
    private final String rootPath = "/dsmd";
    private final SessionSource sessionSource;
    private boolean oldCrtxml = false;

    public DsmdDOMReader(SessionSource sessionSource, DsmdDOMErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.sessionSource = sessionSource;
    }

    public void setOldCrtxml(boolean oldCrtxml) {
        this.oldCrtxml = oldCrtxml;
    }

    public void readDsmd(Element element) {
        if (!this.oldCrtxml) {
            String version = element.getAttribute("version");
            if (version.length() == 0) {
                this.errorHandler.missingAttributeError("version", "/dsmd");
            } else if (version.compareTo("1.0") > 0) {
                this.errorHandler.upperVersionWarning(version);
            }
        }
        DsmdConsumer dsmdConsumer = new DsmdConsumer();
        DOMUtils.readChildren((Element)element, (Consumer)dsmdConsumer);
        dsmdConsumer.endInit();
    }

    private class DsmdConsumer
    implements Consumer<Element> {
        private Element refElement;

        private DsmdConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("conf")) {
                DsmdConfErrorHandler confErrorHandler = new DsmdConfErrorHandler();
                ConfDOMReader confDOMReader = new ConfDOMReader(DsmdDOMReader.this.sessionSource.getSessionConf(), confErrorHandler);
                confDOMReader.readConf(element);
            } else if (tagName.equals("atlas")) {
                AtlasDOMReader atlasDOMReader = new AtlasDOMReader(DsmdDOMReader.this.sessionSource.getAtlasEditor(), DsmdDOMReader.this.errorHandler);
                atlasDOMReader.readAtlasElement(element, "/dsmd/atlas");
            } else if (tagName.equals("references")) {
                if (DsmdDOMReader.this.oldCrtxml) {
                    this.refElement = element;
                } else {
                    DsmdDOMReader.this.errorHandler.unknownTagWarning(tagName, "/dsmd");
                }
            } else {
                DsmdDOMReader.this.errorHandler.unknownTagWarning(tagName, "/dsmd");
            }
        }

        private void endInit() {
            if (this.refElement != null) {
                ReferencesDOMReader referencesDomReader = new ReferencesDOMReader(DsmdDOMReader.this.sessionSource.getAtlasEditor());
                referencesDomReader.read(this.refElement);
            }
        }
    }

    private class DsmdConfErrorHandler
    implements ConfDOMErrorHandler {
        String xp = "/dsmd/conf";

        DsmdConfErrorHandler() {
        }

        @Override
        public void unknownTagWarning(String unknownTag) {
            DsmdDOMReader.this.errorHandler.unknownTagWarning(unknownTag, this.xp);
        }

        @Override
        public void missingParamNameAttributeError() {
            DsmdDOMReader.this.errorHandler.missingAttributeError("name", this.xp + "/param");
        }

        @Override
        public void unknownKeyWarning(String key) {
            DsmdDOMReader.this.errorHandler.wrongAttributeError("name", key, "unknownKey", this.xp + "/param");
        }

        @Override
        public void badValueError(String key, String value) {
            DsmdDOMReader.this.errorHandler.wrongAttributeError("value", value, "badValue", this.xp + "/param[@name='" + key + "']");
        }
    }
}

