/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.liens.LienExistantException;
import net.desmodo.atlas.liens.LiensEditor;
import net.desmodo.atlas.liens.SaisieLienException;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.InvalidContexteException;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class LiensDOMReader {
    private static final short LHG_TYPE = 1;
    private static final short LSM_TYPE = 2;
    private LiensEditor liensEditor;
    private AtlasDOMErrorHandler errorHandler;
    private String xpath;
    private Descripteurs descripteurs;
    private Structure structure;

    public LiensDOMReader(LiensEditor liensEditor, AtlasDOMErrorHandler errorHandler) {
        this.liensEditor = liensEditor;
        this.errorHandler = errorHandler;
        Atlas atlas = liensEditor.getLiens().getAtlas();
        this.descripteurs = atlas.getDescripteurs();
        this.structure = atlas.getStructure();
    }

    public void readLiensElement(Element element_xml, String xpath) {
        this.xpath = xpath;
        DOMUtils.readChildren((Element)element_xml, (Consumer)new LiensConsumer());
    }

    private Contexte getContexteFromCtxtElement(Element element, String xp) {
        String idctxt;
        boolean done = true;
        String grilleName = element.getAttribute("grille");
        if (grilleName.length() == 0) {
            grilleName = element.getAttribute("grl");
        }
        if (grilleName.length() == 0) {
            this.errorHandler.missingAttributeError("grille", xp + "/ctxt");
            done = false;
        }
        if ((idctxt = element.getAttribute("idctxt")).length() == 0) {
            this.errorHandler.missingAttributeError("idctxt", xp + "/ctxt");
            done = false;
        }
        if (!done) {
            return null;
        }
        Grille grille = this.structure.getGrille(grilleName);
        if (grille == null) {
            this.errorHandler.wrongAttributeError("grille", grilleName, "unknownGrille", xp + "/ctxt");
            return null;
        }
        Contexte contexte = grille.getContexteByIdctxt(idctxt);
        if (contexte == null) {
            this.errorHandler.wrongAttributeError("idctxt", idctxt, "unknownContexte", xp + "/ctxt[@grille='" + grilleName + "']");
            return null;
        }
        if (!contexte.isActive()) {
            this.errorHandler.wrongAttributeError("idctxt", idctxt, "inactiveContexte", xp + "/ctxt[@grille='" + grilleName + "']");
            return null;
        }
        return contexte;
    }

    private Descripteur getDescripteurFromDescElement(Element el, String xp) {
        String iddescString = el.getAttribute("iddesc");
        if (iddescString.length() == 0) {
            this.errorHandler.missingAttributeError("iddesc", xp + "/desc");
            return null;
        }
        Iddesc iddesc = Iddesc.parse(iddescString);
        Descripteur descripteur = this.descripteurs.getDescripteurByIddesc(iddesc);
        if (descripteur == null) {
            this.errorHandler.wrongAttributeError("iddesc", iddescString, "unknownDescripteur", xp + "/desc");
            return null;
        }
        return descripteur;
    }

    private class LiensConsumer
    implements Consumer<Element> {
        private LiensConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("liensstructurels")) {
                DOMUtils.readChildren((Element)element, (Consumer)new LiensStructurelsConsumer());
            } else if (tagName.equals("lienshierarchiques")) {
                DOMUtils.readChildren((Element)element, (Consumer)new LiensHierarchiquesConsumer());
            } else if (tagName.equals("lienssymetriques")) {
                DOMUtils.readChildren((Element)element, (Consumer)new LiensSymetriquesConsumer());
            } else if (tagName.equals("lst")) {
                LienStructurelConsumer lsh = new LienStructurelConsumer();
                DOMUtils.readChildren((Element)element, (Consumer)lsh);
                lsh.endInit();
            } else if (tagName.equals("lhg")) {
                CommonLienConsumer lienHandler = new CommonLienConsumer(LiensDOMReader.this.xpath + "/lhg", 1);
                DOMUtils.readChildren((Element)element, (Consumer)lienHandler);
                lienHandler.endInit();
            } else if (tagName.equals("lsm")) {
                CommonLienConsumer lienHandler = new CommonLienConsumer(LiensDOMReader.this.xpath + "/lsm", 2);
                DOMUtils.readChildren((Element)element, (Consumer)lienHandler);
                lienHandler.endInit();
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, LiensDOMReader.this.xpath);
            }
        }
    }

    private static class DescCtxt {
        private final Descripteur descripteur;
        private final Contexte contexte;

        private DescCtxt(Descripteur descripteur, Contexte contexte) {
            this.descripteur = descripteur;
            this.contexte = contexte;
        }

        public Descripteur getDescripteur() {
            return this.descripteur;
        }

        public Contexte getContexte() {
            return this.contexte;
        }
    }

    private class DescCtxtConsumer
    implements Consumer<Element> {
        private final String xp;
        private Descripteur descripteur;
        private Contexte contexte;

        private DescCtxtConsumer(String xp) {
            this.xp = xp + "desc-ctxt";
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("desc")) {
                if (this.descripteur != null) {
                    LiensDOMReader.this.errorHandler.tooManyElementError("desc", this.xp);
                    return;
                }
                this.descripteur = LiensDOMReader.this.getDescripteurFromDescElement(element, this.xp);
            } else if (tagName.equals("ctxt")) {
                if (this.contexte != null) {
                    LiensDOMReader.this.errorHandler.tooManyElementError("ctxt", this.xp);
                    return;
                }
                this.contexte = LiensDOMReader.this.getContexteFromCtxtElement(element, this.xp);
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }

        private DescCtxt toDescCtxt() {
            if (this.descripteur == null) {
                LiensDOMReader.this.errorHandler.missingElementError("desc", this.xp);
                return null;
            }
            if (this.contexte == null) {
                this.contexte = StructureUtils.getHorsgrilleContexte(LiensDOMReader.this.structure);
            }
            return new DescCtxt(this.descripteur, this.contexte);
        }
    }

    private class CommonLienConsumer
    implements Consumer<Element> {
        private final List<DescCtxt> descCtxtList = new ArrayList<DescCtxt>();
        private final List<Descripteur> filsList = new ArrayList<Descripteur>();
        private final String xp;
        private final short type;

        private CommonLienConsumer(String xp, short type) {
            this.xp = xp;
            this.type = type;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("desc-ctxt")) {
                DescCtxtConsumer descCtxtHandler = new DescCtxtConsumer(this.xp);
                DOMUtils.readChildren((Element)element, (Consumer)descCtxtHandler);
                DescCtxt descCtxt = descCtxtHandler.toDescCtxt();
                if (descCtxt != null) {
                    this.descCtxtList.add(descCtxt);
                }
            } else if (tagName.equals("desc")) {
                if (this.type == 1) {
                    Descripteur descripteur = LiensDOMReader.this.getDescripteurFromDescElement(element, this.xp);
                    if (descripteur != null) {
                        this.filsList.add(descripteur);
                    }
                } else {
                    LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
                }
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }

        private void endInit() {
            if (this.type == 1) {
                this.endLhgInit();
            } else if (this.type == 2) {
                this.endLsmInit();
            }
        }

        private void endLhgInit() {
            int descsSize = this.descCtxtList.size();
            int filsSize = this.filsList.size();
            if (descsSize == 0) {
                LiensDOMReader.this.errorHandler.missingElementError("desc-ctxt", this.xp);
                return;
            }
            if (filsSize == 0) {
                LiensDOMReader.this.errorHandler.missingElementError("desc", this.xp);
                return;
            }
            for (int i = 0; i < descsSize; ++i) {
                DescCtxt descCtxt = this.descCtxtList.get(i);
                Descripteur desc = descCtxt.getDescripteur();
                Contexte ctxt = descCtxt.getContexte();
                for (int j = 0; j < filsSize; ++j) {
                    Descripteur fils = this.filsList.get(j);
                    try {
                        LiensDOMReader.this.liensEditor.createLienHierarchique(desc, fils, ctxt, -1);
                        continue;
                    }
                    catch (SaisieLienException saisieLienException) {
                        continue;
                    }
                    catch (InvalidContexteException invalidContexteException) {
                        // empty catch block
                    }
                }
            }
        }

        private void endLsmInit() {
            int descsSize = this.descCtxtList.size();
            if (descsSize == 0) {
                LiensDOMReader.this.errorHandler.missingElementError("desc-ctxt", this.xp);
                return;
            }
            if (descsSize == 1) {
                LiensDOMReader.this.errorHandler.notEnoughElementError("desc-ctxt", this.xp);
                return;
            }
            for (int i = 0; i < descsSize; ++i) {
                DescCtxt descCtxt = this.descCtxtList.get(i);
                Descripteur desc = descCtxt.getDescripteur();
                Contexte ctxt = descCtxt.getContexte();
                for (int j = i + 1; j < descsSize; ++j) {
                    DescCtxt descCtxt2 = this.descCtxtList.get(i);
                    try {
                        LiensDOMReader.this.liensEditor.createLienSymetrique(desc, ctxt, descCtxt2.getDescripteur(), descCtxt2.getContexte());
                        continue;
                    }
                    catch (SaisieLienException saisieLienException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class LiensSymetriquesConsumer
    implements Consumer<Element> {
        private LiensSymetriquesConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lsm")) {
                CommonLienConsumer lienConsumer = new CommonLienConsumer(LiensDOMReader.this.xpath + "lienssymetriques/lsm", 2);
                DOMUtils.readChildren((Element)element, (Consumer)lienConsumer);
                lienConsumer.endInit();
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, LiensDOMReader.this.xpath);
            }
        }
    }

    private class LiensHierarchiquesConsumer
    implements Consumer<Element> {
        private LiensHierarchiquesConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lhg")) {
                CommonLienConsumer lienConsumer = new CommonLienConsumer(LiensDOMReader.this.xpath + "lienshierarchiques/lhg", 1);
                DOMUtils.readChildren((Element)element, (Consumer)lienConsumer);
                lienConsumer.endInit();
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, LiensDOMReader.this.xpath);
            }
        }
    }

    private class LienStructurelConsumer
    implements Consumer<Element> {
        private final String xp;
        private final List<Contexte> listCtxt = new ArrayList<Contexte>();
        private final List<Descripteur> listDesc = new ArrayList<Descripteur>();

        private LienStructurelConsumer() {
            this.xp = LiensDOMReader.this.xpath + "/lst";
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("ctxt")) {
                Contexte contexte = LiensDOMReader.this.getContexteFromCtxtElement(element, this.xp);
                if (contexte != null) {
                    this.listCtxt.add(contexte);
                }
            } else if (tagName.equals("iddesc")) {
                Descripteur descripteur = LiensDOMReader.this.getDescripteurFromDescElement(element, this.xp);
                if (descripteur != null) {
                    this.listDesc.add(descripteur);
                }
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, LiensDOMReader.this.xpath);
            }
        }

        private void endInit() {
            int sizeCtxt = this.listCtxt.size();
            if (sizeCtxt == 0) {
                LiensDOMReader.this.errorHandler.missingElementError("ctxt", this.xp);
                return;
            }
            int sizeDesc = this.listDesc.size();
            if (sizeDesc == 0) {
                LiensDOMReader.this.errorHandler.missingElementError("desc", this.xp);
                return;
            }
            if (sizeCtxt == 1) {
                Contexte contexte = this.listCtxt.get(0);
                for (int k = 0; k < sizeDesc; ++k) {
                    Descripteur desc = this.listDesc.get(k);
                    try {
                        LiensDOMReader.this.liensEditor.addDescripteur(contexte, contexte, desc, -1);
                        continue;
                    }
                    catch (LienExistantException lienExistantException) {
                        continue;
                    }
                    catch (InvalidContexteException ice) {
                        throw new ShouldNotOccurException((Exception)ice);
                    }
                }
            } else {
                for (int j = 0; j < sizeCtxt - 1; ++j) {
                    Contexte contexte1 = this.listCtxt.get(j);
                    for (int l = j + 1; l < sizeCtxt; ++l) {
                        Contexte contexte2 = this.listCtxt.get(l);
                        for (int k = 0; k < sizeDesc; ++k) {
                            Descripteur desc = this.listDesc.get(k);
                            try {
                                LiensDOMReader.this.liensEditor.addDescripteur(contexte1, contexte2, desc, -1);
                                continue;
                            }
                            catch (LienExistantException lienExistantException) {
                                continue;
                            }
                            catch (InvalidContexteException ice) {
                                throw new ShouldNotOccurException((Exception)ice);
                            }
                        }
                    }
                }
            }
        }
    }

    private class LiensStructurelsConsumer
    implements Consumer<Element> {
        private LiensStructurelsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lst")) {
                LienStructurelConsumer lsh = new LienStructurelConsumer();
                DOMUtils.readChildren((Element)element, (Consumer)lsh);
                lsh.endInit();
            } else {
                LiensDOMReader.this.errorHandler.unknownTagWarning(tagName, LiensDOMReader.this.xpath);
            }
        }
    }
}

