/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import java.awt.Color;
import javax.swing.ComboBoxModel;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.tools.multilist.MultiList;
import net.desmodo.atlas.tools.multilist.MultiListItem;
import net.desmodo.atlas.wrapper.AbstractComboBoxModel;
import net.desmodo.atlas.wrapper.GroupeItem;
import net.desmodo.atlas.wrapper.GroupeItemManagerImpl;
import net.desmodo.atlas.wrapper.LibelleItemImpl;
import net.mapeadores.util.awt.ColorSkin;

class GroupeItemImpl
extends MultiListItem
implements GroupeItem {
    static final short OBJECT_REMOVED = 1;
    static final short OBJECT_ADDED = 2;
    static final short OBJECT_CHANGED = 3;
    static final short OBJECT_TRANSLATED = 4;
    static final int ACTIVEINGROUPEBUNDLE_INDEX = 0;
    static final int ACTIVEINGROUPEBUNDLE_MASK = 1;
    static final int LIBELLEITEM_INDEXCOUNT = 1;
    private GroupeItemImpl parentInternalGroupeItem;
    private GroupeModel groupeModel;
    private MultiList groupeMultiList = new MultiList(1);
    private ColorSkin colorSkin;
    private int termCode;
    private short termType;
    private String intitule;
    private GroupeItemManagerImpl groupeItemManager;
    private boolean isActive;

    GroupeItemImpl(GroupeItemManagerImpl groupeItemManager, Term term, int initialmask, GroupeItemImpl parent) {
        super(groupeItemManager.getInternalGroupeItemMultiList(), initialmask);
        this.groupeItemManager = groupeItemManager;
        this.groupeModel = new GroupeModel();
        this.termCode = term.getCode();
        this.termType = term.getTermType();
        this.intitule = AtlasUtils.toLibelleString(term, groupeItemManager.getWorkingLang());
        this.parentInternalGroupeItem = parent;
        this.colorSkin = ColorSkin.createFondColorSkin((Color)AtlasAttributes.getColor(term));
        this.isActive = term instanceof Grille ? true : ((Contexte)term).isActive();
    }

    @Override
    public Object getWrappedObject() {
        return this;
    }

    int getSize() {
        return this.groupeMultiList.getSecondarySize(0);
    }

    ComboBoxModel getGroupeModel() {
        return this.groupeModel;
    }

    GroupeItemImpl getParent() {
        return this.parentInternalGroupeItem;
    }

    @Override
    public GroupeItem getGroupeParent() {
        return this.parentInternalGroupeItem;
    }

    void setParent(GroupeItemImpl parentInternalGroupeItem) {
        this.parentInternalGroupeItem = parentInternalGroupeItem;
    }

    void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    void setColor(Color color) {
        this.colorSkin = ColorSkin.createFondColorSkin((Color)color);
        int size = this.groupeMultiList.getSecondarySize(0);
        if (size > 0) {
            new Change(3, 0, size);
        }
    }

    boolean descendsFrom(GroupeItemImpl igi) {
        if (this.parentInternalGroupeItem == null) {
            return false;
        }
        if (this.parentInternalGroupeItem.equals(igi)) {
            return true;
        }
        return this.parentInternalGroupeItem.descendsFrom(igi);
    }

    void setLibelle(String s) {
        this.intitule = s;
    }

    void removeLibelleItem(LibelleItemImpl internalLibelleItem) {
        int activeindex = internalLibelleItem.getSecondaryIndex(0);
        internalLibelleItem.clear();
        if (activeindex != -1) {
            new Change(1, activeindex);
        }
    }

    void translateLibelleItem(LibelleItemImpl internalLibelleItem, int newIndex) {
        int oldActiveIndex = internalLibelleItem.getSecondaryIndex(0);
        this.groupeMultiList.translate(internalLibelleItem, newIndex);
        if (oldActiveIndex != -1) {
            new Change(4, oldActiveIndex, internalLibelleItem.getSecondaryIndex(0));
        }
    }

    void addLibelleItem(LibelleItemImpl libItem) {
        libItem.setGroupeItemImpl(this);
        int activeIndex = libItem.getSecondaryIndex(0);
        if (activeIndex != -1) {
            new Change(2, activeIndex);
        }
    }

    MultiList getInternalLibelleItemMultiList() {
        return this.groupeMultiList;
    }

    void activeChanged(boolean active, LibelleItemImpl libItem) {
        int activeIndex = libItem.getSecondaryIndex(0);
        if (active && activeIndex == -1) {
            this.groupeMultiList.enable(libItem, 1);
            new Change(2, libItem.getSecondaryIndex(0));
        }
        if (!active && activeIndex != -1) {
            this.groupeMultiList.disable(libItem, 1);
            new Change(1, activeIndex);
        }
    }

    @Override
    public ColorSkin getColorSkin() {
        return this.colorSkin;
    }

    @Override
    public int getTermCode() {
        return this.termCode;
    }

    @Override
    public short getTermType() {
        return this.termType;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public String toString() {
        return this.intitule;
    }

    void libelleItemChanged(LibelleItemImpl ili) {
        if (!ili.getGroupeItemImpl().equals(this)) {
            throw new IllegalStateException("wrongGroupeItem : le libell\u00e9 item n'appartient pas au groupe");
        }
        new Change(3, ili.getSecondaryIndex(0));
    }

    private class GroupeModel
    extends AbstractComboBoxModel {
        private GroupeModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return GroupeItemImpl.this.groupeMultiList.getItemSecondaryList(0).get(index);
        }

        @Override
        public int getSize() {
            return GroupeItemImpl.this.groupeMultiList.getSecondarySize(0);
        }

        private void commitChange(Change change) {
            switch (change.type) {
                case 1: {
                    this.fireObjectRemoved(change.index);
                    break;
                }
                case 2: {
                    this.fireObjectAdded(change.index);
                    break;
                }
                case 3: {
                    this.fireObjectChanged(change.index);
                    break;
                }
                case 4: {
                    this.fireIndexChanged(change.index, change.index2);
                }
            }
        }
    }

    private class Change {
        private short type;
        private int index;
        private int index2;

        private Change(short type, int index) {
            this.type = type;
            this.index = index;
            this.commitChange();
        }

        private Change(short type, int index, int index2) {
            this.type = type;
            this.index = index;
            this.index2 = index;
            this.commitChange();
        }

        private void commitChange() {
            GroupeItemImpl.this.groupeItemManager.checkNotEmptyChange(GroupeItemImpl.this, this.type);
            GroupeItemImpl.this.groupeModel.commitChange(this);
        }
    }
}

