/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.ventilation;

import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.LienDeduit;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.tools.ventilation.VentilationBuilder;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.builders.DefaultVentilation;
import net.desmodo.atlas.ventilation.builders.SecteurBuilder;

public final class VentilationBuilderUtils {
    public static final VentilationBuilderUtils UNIQUE_INSTANCE = new VentilationBuilderUtils();
    public static final LienDeduit LIENDEDUIT_AVAL = new DefaultLienDeduit(1);
    public static final LienDeduit LIENDEDUIT_AMONT = new DefaultLienDeduit(3);
    public static final LienDeduit LIENDEDUIT_EGAL = new DefaultLienDeduit(2);

    private VentilationBuilderUtils() {
    }

    public static void initVentilationComplete(VentilationBuilder ventilationBuilder, boolean ignoreHorsGrille) {
        ventilationBuilder.setColorStyle(ColorStyle.COMPLETE_COLORSTYLE);
        Structure structure = ventilationBuilder.getVentilationParameters().getAtlas().getStructure();
        GrilleList list = structure.getGrilleList();
        int grilleCount = list.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            Grille grille = list.getGrille(i);
            SecteurBuilder secteurBuilder = new SecteurBuilder(grille);
            secteurBuilder.setActive(false);
            secteurBuilder.setVentilationCode(ventilationBuilder.createCode());
            secteurBuilder.setColorStyle(ventilationBuilder.getColorStyle(grille));
            VentilationBuilderUtils.initChildren(ventilationBuilder, secteurBuilder, grille.getFirstLevelContexteList());
            ventilationBuilder.addSecteurBuilder(secteurBuilder);
        }
        if (!ignoreHorsGrille) {
            Contexte horsGrille = StructureUtils.getHorsgrilleContexte(structure);
            SecteurBuilder horsGrilleBuilder = new SecteurBuilder(horsGrille);
            horsGrilleBuilder.setActive(true);
            horsGrilleBuilder.setVentilationCode(ventilationBuilder.createCode());
            horsGrilleBuilder.setColorStyle(ventilationBuilder.getColorStyle(horsGrille));
            ventilationBuilder.addSecteurBuilder(horsGrilleBuilder);
        }
    }

    public static void initGrilleOrContexteVentilation(VentilationBuilder ventilationBuilder, Term start) {
        if (start instanceof Grille) {
            Grille grille = (Grille)start;
            ventilationBuilder.setColorStyle(ventilationBuilder.getColorStyle(grille));
            ContexteList list = grille.getFirstLevelContexteList();
            int contexteCount = list.getContexteCount();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte child = list.getContexte(i);
                SecteurBuilder secteurBuilder = VentilationBuilderUtils.toSecteurBuilder(ventilationBuilder, child);
                ventilationBuilder.addSecteurBuilder(secteurBuilder);
            }
        } else {
            Contexte contexte = (Contexte)start;
            if (contexte.isActive()) {
                ventilationBuilder.setColorStyle(ColorStyle.fromActiveContexte(contexte));
                SecteurBuilder secteurBuilder = VentilationBuilderUtils.toSecteurBuilder(ventilationBuilder, contexte);
                ventilationBuilder.addSecteurBuilder(secteurBuilder);
            } else {
                ventilationBuilder.setColorStyle(ventilationBuilder.getColorStyle(contexte));
                ContexteList list = contexte.getChildren();
                int contexteCount = list.getContexteCount();
                for (int i = 0; i < contexteCount; ++i) {
                    Contexte child = list.getContexte(i);
                    SecteurBuilder secteurBuilder = VentilationBuilderUtils.toSecteurBuilder(ventilationBuilder, child);
                    ventilationBuilder.addSecteurBuilder(secteurBuilder);
                }
            }
        }
    }

    private static void initChildren(VentilationBuilder ventilationBuilder, SecteurBuilder parent, ContexteList contexteList) {
        int count = contexteList.getContexteCount();
        for (int i = 0; i < count; ++i) {
            Contexte contexte = contexteList.getContexte(i);
            SecteurBuilder child = VentilationBuilderUtils.toSecteurBuilder(ventilationBuilder, contexte);
            parent.addChild(child);
        }
    }

    private static SecteurBuilder toSecteurBuilder(VentilationBuilder ventilationBuilder, Contexte contexte) {
        Grille grille;
        Contexte ctxtparent;
        SecteurBuilder secteurBuilder = new SecteurBuilder(contexte);
        secteurBuilder.setActive(contexte.isActive());
        short type = contexte.getTermType();
        ColorStyle colorStyle = type == 4 || type == 6 ? ventilationBuilder.getColorStyle(contexte) : ((ctxtparent = contexte.getParent()) == null ? ((grille = contexte.getGrille()) != null ? ventilationBuilder.getColorStyle(grille) : ventilationBuilder.getColorStyle(contexte)) : ventilationBuilder.getColorStyle(ctxtparent));
        secteurBuilder.setColorStyle(colorStyle);
        secteurBuilder.setVentilationCode(ventilationBuilder.createCode());
        VentilationBuilderUtils.initChildren(ventilationBuilder, secteurBuilder, contexte.getChildren());
        return secteurBuilder;
    }

    public static void addLiaisonsNaturelles(Contexte contexte, DefaultVentilation defVentilation) {
        Liens liens = contexte.getAtlas().getLiens();
        LienStructurelList lstList = liens.getLienStructurelList(contexte);
        int lienCount = lstList.getLienStructurelCount();
        if (lienCount > 0) {
            for (int i = 0; i < lienCount; ++i) {
                LienStructurel lienStructurel = lstList.getLienStructurel(i);
                Contexte otherContexte = LiensUtils.getOtherContexte(lienStructurel, contexte);
                defVentilation.createLiaisonsFromLienStructurel(lienStructurel, otherContexte);
            }
        }
    }

    public static void addLiaisonsNaturelles(Descripteur descripteur, DefaultVentilation defVentilation) {
        LienHierarchiqueGroupList lhgList;
        int groupCount;
        LienSymetriqueList lsmList;
        int lsmCount;
        LienHierarchiqueList lhList;
        int lhCount;
        Liens liens = descripteur.getAtlas().getLiens();
        Liens.LienLists lienLists = liens.getLienLists(descripteur);
        LienStructurelList lstList = lienLists.getLienStructurelList();
        int lstCount = lstList.getLienStructurelCount();
        if (lstCount > 0) {
            for (int i = 0; i < lstCount; ++i) {
                LienStructurel lienStructurel = lstList.getLienStructurel(i);
                Contexte contexte1 = lienStructurel.getContexte1();
                Contexte contexte2 = lienStructurel.getContexte2();
                defVentilation.createLiaison(lienStructurel, contexte1, contexte2);
                if (lienStructurel.isLienSurLuiMeme()) continue;
                defVentilation.createLiaison(lienStructurel, contexte2, contexte1);
            }
        }
        if ((lhCount = (lhList = lienLists.getLienHierarchiqueList()).getLienHierarchiqueCount()) > 0) {
            for (int i = 0; i < lhCount; ++i) {
                LienHierarchique lienHierarchique = lhList.getLienHierarchique(i);
                defVentilation.createLiaison(lienHierarchique, lienHierarchique.getDescripteurPere(), lienHierarchique.getContexte());
            }
        }
        if ((lsmCount = (lsmList = lienLists.getLienSymetriqueList()).getLienSymetriqueCount()) > 0) {
            for (int i = 0; i < lsmCount; ++i) {
                LienSymetrique lienSymetrique = lsmList.getLienSymetrique(i);
                int index = LiensUtils.indexOf(lienSymetrique, descripteur);
                int sensinverse = LiensUtils.getSensInverse(index);
                defVentilation.createLiaison(lienSymetrique, lienSymetrique.getDescripteur(sensinverse), lienSymetrique.getContexte(sensinverse));
            }
        }
        if ((groupCount = (lhgList = lienLists.getLienHierarchiqueGroupList()).getLienHierarchiqueGroupCount()) > 0) {
            for (int i = 0; i < groupCount; ++i) {
                LienHierarchiqueGroup lienHierarchiqueGroup = lhgList.getLienHierarchiqueGroup(i);
                Contexte contexte = lienHierarchiqueGroup.getContexte();
                defVentilation.createLiaisonsFromLienHierarchiqueGroup(lienHierarchiqueGroup, contexte);
            }
        }
    }

    private static class DefaultLienDeduit
    implements LienDeduit {
        private final short position;

        private DefaultLienDeduit(short position) {
            this.position = position;
        }

        @Override
        public short getPosition() {
            return this.position;
        }
    }
}

