/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.lienscroises;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensFilter;
import net.desmodo.atlas.lienscroises.LienCroise;
import net.desmodo.atlas.lienscroises.LienCroiseImpl;
import net.desmodo.atlas.structure.Contexte;

public class LienCroiseFactory {
    private final Liens liens;
    private final Descripteur descripteurCentral;
    private final DescripteurList descripteurList;
    private final Map<Descripteur, LienCroiseBundle> lienCroiseMap = new LinkedHashMap<Descripteur, LienCroiseBundle>();
    private final Liens.LienLists lienLists;
    private final Map<Integer, FilsCommun> filsCommunMap = new HashMap<Integer, FilsCommun>();
    private final Map<Integer, SymetriqueCommun> symetriqueCommunMap = new HashMap<Integer, SymetriqueCommun>();
    private final Map<Integer, PereCommun> pereCommunMap = new HashMap<Integer, PereCommun>();
    private final Map<Integer, ContexteCommun> contexteCommunMap = new HashMap<Integer, ContexteCommun>();

    private LienCroiseFactory(Descripteur descripteurCentral, DescripteurList descripteurList, LiensFilter liensFilter) {
        this.liens = descripteurCentral.getAtlas().getLiens();
        this.descripteurCentral = descripteurCentral;
        this.descripteurList = descripteurList;
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            Descripteur descripteur = descripteurList.getDescripteur(i);
            if (descripteur.equals(descripteurCentral)) continue;
            this.lienCroiseMap.put(descripteur, new LienCroiseBundle(descripteur));
        }
        this.lienLists = this.liens.getLienLists(descripteurCentral);
    }

    public static List<LienCroise> getLienCroiseList(Descripteur descripteur, Contexte famille, LiensFilter liensFilter) {
        DescripteurList liste = famille.getAtlas().getDescripteurs().getInFamilleDescripteurList(famille);
        LienCroiseFactory factory = new LienCroiseFactory(descripteur, liste, liensFilter);
        if (liensFilter.acceptLienStructurel()) {
            factory.addLienStructurel();
        }
        if (liensFilter.acceptLienHierarchiqueAmont()) {
            factory.addLienHierarchiqueAmont();
        }
        if (liensFilter.acceptLienSymetrique()) {
            factory.addLienSymetrique();
        }
        if (liensFilter.acceptLienHierarchiqueAval()) {
            factory.addLienHierarchiqueAval();
        }
        return factory.getResultList();
    }

    private List<LienCroise> getResultList() {
        ArrayList<LienCroise> resultList = new ArrayList<LienCroise>();
        for (LienCroiseBundle lienCroiseBundle : this.lienCroiseMap.values()) {
            lienCroiseBundle.appendResult(resultList);
        }
        return resultList;
    }

    private void addLienStructurel() {
        LienStructurelList list = this.lienLists.getLienStructurelList();
        int lienCount = list.getLienStructurelCount();
        if (lienCount == 0) {
            return;
        }
        for (int i = 0; i < lienCount; ++i) {
            LienStructurel lst = list.getLienStructurel(i);
            this.testLienStructurel(lst, lst.getContexte1());
            if (lst.isLienSurLuiMeme()) continue;
            this.testLienStructurel(lst, lst.getContexte2());
        }
    }

    private void addLienHierarchiqueAval() {
        LienHierarchiqueGroupList list = this.lienLists.getLienHierarchiqueGroupList();
        int groupCount = list.getLienHierarchiqueGroupCount();
        if (groupCount == 0) {
            return;
        }
        for (int i = 0; i < groupCount; ++i) {
            LienHierarchiqueGroup lhg = list.getLienHierarchiqueGroup(i);
            int lienCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lienCount; ++j) {
                this.testLienHierarchiqueAval(lhg.getLienHierarchique(j));
            }
        }
    }

    private void addLienHierarchiqueAmont() {
        LienHierarchiqueList list = this.lienLists.getLienHierarchiqueList();
        int lienCount = list.getLienHierarchiqueCount();
        if (lienCount == 0) {
            return;
        }
        for (int i = 0; i < lienCount; ++i) {
            this.testLienHierarchiqueAmont(list.getLienHierarchique(i));
        }
    }

    private void addLienSymetrique() {
        LienSymetriqueList list = this.lienLists.getLienSymetriqueList();
        int lienCount = list.getLienSymetriqueCount();
        if (lienCount == 0) {
            return;
        }
        for (int j = 0; j < lienCount; ++j) {
            LienSymetrique lienSymetrique = list.getLienSymetrique(j);
            for (int i = 0; i < lienSymetrique.getDescripteurCount(); ++i) {
                Descripteur descripteur = lienSymetrique.getDescripteur(i);
                if (descripteur.equals(this.descripteurCentral)) continue;
                this.testLienSymetrique(descripteur, lienSymetrique);
            }
        }
    }

    private void testLienStructurel(LienStructurel lienStructurel, Contexte contexte) {
        ContexteCommun contexteCommun = this.contexteCommunMap.get(contexte.getCode());
        if (contexteCommun != null) {
            contexteCommun.addLstCentral(lienStructurel);
            return;
        }
        contexteCommun = new ContexteCommun(contexte);
        contexteCommun.addLstCentral(lienStructurel);
        this.contexteCommunMap.put(contexte.getCode(), contexteCommun);
        LienStructurelList list = this.liens.getLienStructurelList(contexte);
        int lienCount = list.getLienStructurelCount();
        for (int i = 0; i < lienCount; ++i) {
            LienStructurel lst = list.getLienStructurel(i);
            DescripteurList lstDescripteurList = lst.getDescripteurList();
            int descripteurCount = lstDescripteurList.getDescripteurCount();
            for (int j = 0; j < descripteurCount; ++j) {
                LienCroiseBundle lienCroiseBundle;
                Descripteur desc = lstDescripteurList.getDescripteur(j);
                if (desc.equals(this.descripteurCentral) || (lienCroiseBundle = this.lienCroiseMap.get(desc)) == null) continue;
                contexteCommun.addLstBordure(lst);
                lienCroiseBundle.addContexteCommun(contexteCommun);
            }
        }
    }

    private void testLienSymetrique(Descripteur descripteur, LienSymetrique lienSymetrique) {
        SymetriqueCommun symetriqueCommun = this.symetriqueCommunMap.get(descripteur.getCode());
        if (symetriqueCommun != null) {
            symetriqueCommun.addLhCentral(lienSymetrique);
            return;
        }
        symetriqueCommun = new SymetriqueCommun(descripteur);
        symetriqueCommun.addLhCentral(lienSymetrique);
        this.symetriqueCommunMap.put(descripteur.getCode(), symetriqueCommun);
        Liens.LienLists liste = this.liens.getLienLists(descripteur);
        LienSymetriqueList lienListe = liste.getLienSymetriqueList();
        int lienCount = lienListe.getLienSymetriqueCount();
        for (int j = 0; j < lienCount; ++j) {
            LienSymetrique ls = lienListe.getLienSymetrique(j);
            for (int i = 0; i < ls.getDescripteurCount(); ++i) {
                LienCroiseBundle lienCroiseBundle;
                Descripteur desc = ls.getDescripteur(i);
                if (desc.equals(descripteur) || (lienCroiseBundle = this.lienCroiseMap.get(desc)) == null) continue;
                symetriqueCommun.addLhBordure(ls);
                lienCroiseBundle.addSymetriqueCommun(symetriqueCommun);
            }
        }
    }

    private void testLienHierarchiqueAmont(LienHierarchique lienHierarchiqueAmont) {
        Descripteur descripteurPere = lienHierarchiqueAmont.getDescripteurPere();
        PereCommun pereCommun = this.pereCommunMap.get(descripteurPere.getCode());
        if (pereCommun != null) {
            pereCommun.addLhCentral(lienHierarchiqueAmont);
            return;
        }
        pereCommun = new PereCommun(descripteurPere);
        pereCommun.addLhCentral(lienHierarchiqueAmont);
        this.pereCommunMap.put(descripteurPere.getCode(), pereCommun);
        Liens.LienLists lienListsFils = this.liens.getLienLists(descripteurPere);
        LienHierarchiqueGroupList groupList = lienListsFils.getLienHierarchiqueGroupList();
        int groupCount = groupList.getLienHierarchiqueGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            LienHierarchiqueGroup lhg = groupList.getLienHierarchiqueGroup(i);
            int lienCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lienCount; ++j) {
                LienCroiseBundle lienCroiseBundle;
                LienHierarchique aval = lhg.getLienHierarchique(j);
                Descripteur descFils = aval.getDescripteurFils();
                if (descFils.equals(this.descripteurCentral) || (lienCroiseBundle = this.lienCroiseMap.get(descFils)) == null) continue;
                pereCommun.addLhBordure(aval);
                lienCroiseBundle.addPereCommun(pereCommun);
            }
        }
    }

    private void testLienHierarchiqueAval(LienHierarchique lienHierarchiqueAval) {
        Descripteur descripteurFils = lienHierarchiqueAval.getDescripteurFils();
        FilsCommun filsCommun = this.filsCommunMap.get(descripteurFils.getCode());
        if (filsCommun != null) {
            filsCommun.addLhCentral(lienHierarchiqueAval);
            return;
        }
        filsCommun = new FilsCommun(descripteurFils);
        filsCommun.addLhCentral(lienHierarchiqueAval);
        this.filsCommunMap.put(descripteurFils.getCode(), filsCommun);
        Liens.LienLists lienListsFils = this.liens.getLienLists(descripteurFils);
        LienHierarchiqueList list = lienListsFils.getLienHierarchiqueList();
        int lienCount = list.getLienHierarchiqueCount();
        for (int i = 0; i < lienCount; ++i) {
            LienHierarchique lh = list.getLienHierarchique(i);
            Descripteur descripteurPere2 = lh.getDescripteurPere();
            LienCroiseBundle lienCroiseBundle = this.lienCroiseMap.get(descripteurPere2);
            if (lienCroiseBundle == null) continue;
            filsCommun.addLhBordure(lh);
            lienCroiseBundle.addFilsCommun(filsCommun);
        }
    }

    private class LienCroiseBundle {
        private final Descripteur descripteurBordure;
        private final Set<FilsCommun> filsCommunSet = new LinkedHashSet<FilsCommun>();
        private final Set<SymetriqueCommun> symetriqueCommunSet = new LinkedHashSet<SymetriqueCommun>();
        private final Set<PereCommun> pereCommunSet = new LinkedHashSet<PereCommun>();
        private final Set<ContexteCommun> contexteCommunSet = new LinkedHashSet<ContexteCommun>();

        private LienCroiseBundle(Descripteur descripteurBordure) {
            this.descripteurBordure = descripteurBordure;
        }

        private void addPereCommun(PereCommun pereCommun) {
            this.pereCommunSet.add(pereCommun);
        }

        private void addFilsCommun(FilsCommun filsCommun) {
            this.filsCommunSet.add(filsCommun);
        }

        private void addSymetriqueCommun(SymetriqueCommun symetriqueCommun) {
            this.symetriqueCommunSet.add(symetriqueCommun);
        }

        private void addContexteCommun(ContexteCommun contexteCommun) {
            this.contexteCommunSet.add(contexteCommun);
        }

        private void appendResult(List<LienCroise> list) {
            LienCroiseImpl implLienCroise;
            for (ContexteCommun contexteCommun : this.contexteCommunSet) {
                implLienCroise = new LienCroiseImpl(contexteCommun.contexte, LienCroiseFactory.this.descripteurCentral, this.descripteurBordure);
                implLienCroise.setPosition((short)3);
                list.add(implLienCroise);
            }
            for (PereCommun pereCommun : this.pereCommunSet) {
                implLienCroise = new LienCroiseImpl(pereCommun.descripteurPere, LienCroiseFactory.this.descripteurCentral, this.descripteurBordure);
                implLienCroise.setPosition((short)3);
                list.add(implLienCroise);
            }
            for (SymetriqueCommun symetriqueCommun : this.symetriqueCommunSet) {
                implLienCroise = new LienCroiseImpl(symetriqueCommun.descripteur, LienCroiseFactory.this.descripteurCentral, this.descripteurBordure);
                implLienCroise.setPosition((short)2);
                list.add(implLienCroise);
            }
            for (FilsCommun filsCommun : this.filsCommunSet) {
                implLienCroise = new LienCroiseImpl(filsCommun.descripteurFils, LienCroiseFactory.this.descripteurCentral, this.descripteurBordure);
                implLienCroise.setPosition((short)1);
                list.add(implLienCroise);
            }
        }
    }

    private class ContexteCommun {
        private final Contexte contexte;
        private final List<LienStructurel> lstCentral = new ArrayList<LienStructurel>();
        private final List<LienStructurel> lstBordure = new ArrayList<LienStructurel>();

        private ContexteCommun(Contexte contexte) {
            this.contexte = contexte;
        }

        private void addLstCentral(LienStructurel lst) {
            this.lstCentral.add(lst);
        }

        private void addLstBordure(LienStructurel lst) {
            this.lstBordure.add(lst);
        }
    }

    private class SymetriqueCommun {
        private final Descripteur descripteur;
        private final List<LienSymetrique> lsCentral = new ArrayList<LienSymetrique>();
        private final List<LienSymetrique> lsBordure = new ArrayList<LienSymetrique>();

        private SymetriqueCommun(Descripteur descripteur) {
            this.descripteur = descripteur;
        }

        private void addLhCentral(LienSymetrique ls) {
            this.lsCentral.add(ls);
        }

        private void addLhBordure(LienSymetrique ls) {
            this.lsBordure.add(ls);
        }
    }

    private class PereCommun {
        private final Descripteur descripteurPere;
        private final List<LienHierarchique> lhCentral = new ArrayList<LienHierarchique>();
        private final List<LienHierarchique> lhBordure = new ArrayList<LienHierarchique>();

        private PereCommun(Descripteur descripteurPere) {
            this.descripteurPere = descripteurPere;
        }

        private void addLhCentral(LienHierarchique lh) {
            this.lhCentral.add(lh);
        }

        private void addLhBordure(LienHierarchique lh) {
            this.lhBordure.add(lh);
        }
    }

    private class FilsCommun {
        private final Descripteur descripteurFils;
        private final List<LienHierarchique> lhCentral = new ArrayList<LienHierarchique>();
        private final List<LienHierarchique> lhBordure = new ArrayList<LienHierarchique>();

        private FilsCommun(Descripteur descripteurFils) {
            this.descripteurFils = descripteurFils;
        }

        private void addLhCentral(LienHierarchique lh) {
            this.lhCentral.add(lh);
        }

        private void addLhBordure(LienHierarchique lh) {
            this.lhBordure.add(lh);
        }
    }
}

