/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.layers.Layer;
import net.mapeadores.util.attr.Attribute;

public class PoidsLayer
implements Layer {
    private final Color backgroundColor = new Color(210, 210, 210);
    private final Color color = Color.RED;
    private final int height = 8;
    private BlockLocator blockLocator;
    private final List<InternalPoidsIcon> iconList = new ArrayList<InternalPoidsIcon>();
    private String name;
    private int index;

    @Override
    public void setBlockLocator(BlockLocator blockLocator) {
        this.blockLocator = blockLocator;
    }

    @Override
    public void paintLayer(Graphics2D g) {
        for (InternalPoidsIcon poidsIcon : this.iconList) {
            poidsIcon.paint(g);
        }
    }

    @Override
    public void update() {
        this.iconList.clear();
        for (LiaisonBlock liaisonBlock : this.blockLocator.getLiaisonBlockList()) {
            Attribute attribute;
            Term term = liaisonBlock.getTerm();
            if (!(term instanceof Descripteur) || (attribute = ((Descripteur)term).getAttributes().getAttribute(AtlasAttributes.POIDS_KEY)) == null) continue;
            try {
                int poids = Integer.parseInt(attribute.getFirstValue());
                if (poids < 0) {
                    poids = 0;
                } else if (poids > 10) {
                    poids = 10;
                }
                Rectangle rect = liaisonBlock.getRectangle();
                Point P = new Point(rect.x + rect.width - 18, rect.y + rect.height - 8 + 2);
                this.iconList.add(new InternalPoidsIcon(P, poids));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    private class InternalPoidsIcon {
        private final Point P;
        private final int poids;

        InternalPoidsIcon(Point P, int poids) {
            this.P = P;
            this.poids = poids;
        }

        void paint(Graphics2D g) {
            Color oldColor = g.getColor();
            int x1 = this.P.x;
            int y1 = this.P.y;
            int x2 = x1 + 21;
            int y2 = y1 + 8 + 1;
            g.setColor(Color.BLACK);
            g.drawLine(x1, y1 - 1, x2, y1 - 1);
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
            g.drawLine(x1, y2, x2, y2);
            g.setColor(Color.WHITE);
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
            g.setColor(PoidsLayer.this.backgroundColor);
            g.fillRect(x1, y1, 20, 8);
            if (this.poids > 0) {
                g.setColor(PoidsLayer.this.color);
                g.fillRect(x1, y1, this.poids * 2, 8);
            }
            g.setColor(oldColor);
        }
    }
}

