/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeLayer;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeLayerDisplay;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeParameters;
import net.desmodo.atlas.session.NavigationUnit;
import net.desmodo.atlas.session.NavigationUtils;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIOException;
import net.desmodo.atlas.sxio.SXStylesSource;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.mapeadores.util.awt.ColorUtils;
import net.mapeadores.util.xml.XMLUtils;

public class SxdExport
implements SXContentSource,
SXStylesSource {
    public static final int SXD_WIDTH = 785;
    public static final int SXD_HEIGHT = 537;
    private final StringWriter contentWriter = new StringWriter();
    private SxdWriter sxdWriter;
    private final StringWriter stylesWriter = new StringWriter();
    private final Set<ColorStyle> usedColorStyle = new HashSet<ColorStyle>();
    private final Set<BoxSkin> usedBoxSkin = new HashSet<BoxSkin>();
    private CartecentreeLayer cartecentreeLayer;
    private CartecentreeParameters parameters;

    private SxdExport() {
        this.sxdWriter = new SxdWriter();
        this.sxdWriter.setAppendable(this.contentWriter);
        this.sxdWriter.setIndentLength(1);
    }

    public SxdExport(CartecentreeLayer cartecentreeLayer, String pageName, CartecentreeParameters parameters) throws IOException {
        this();
        this.cartecentreeLayer = cartecentreeLayer;
        this.parameters = parameters;
        this.write(pageName);
    }

    public SxdExport(CartecentreeLayer cartecentreeLayer, CartecentreeParameters parameters) {
        this();
        this.cartecentreeLayer = cartecentreeLayer;
        this.parameters = parameters;
    }

    public void addNavigationUnit(NavigationUnit navigationUnit) throws IOException {
        this.cartecentreeLayer.reinit(navigationUnit);
        this.write(NavigationUtils.toString(navigationUnit));
    }

    private void write(String pageName) throws IOException {
        CartecentreeLayerDisplay.exportSXDPage(this.cartecentreeLayer, this.sxdWriter, pageName, this.parameters);
        this.usedColorStyle.addAll(this.cartecentreeLayer.getUsedColorStyle());
        this.usedBoxSkin.addAll(this.cartecentreeLayer.getUsedBoxSkin());
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String getFormatName() {
        return "sxd";
    }

    @Override
    public boolean needDeclaration() {
        return true;
    }

    @Override
    public boolean needRootElement() {
        return true;
    }

    @Override
    public void writeContent(OutputStream outputStream) throws SXIOException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write("<office:body>");
            StringBuffer buffer = this.contentWriter.getBuffer();
            writer.write(buffer.toString());
            writer.write("</office:body>");
            writer.flush();
        }
        catch (IOException ioe) {
            throw new SXIOException(ioe);
        }
    }

    @Override
    public void writeStyles(OutputStream outputStream) throws SXIOException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write("<office:styles>");
            writer.write("<style:style style:name='special:ventilation' style:family='graphics' style:parent-style-name='standard'>\n");
            writer.write("\t<style:properties draw:stroke='solid' svg:stroke-width='1pt'/>\n");
            writer.write("</style:style>\n");
            for (ColorStyle colorStyle : this.usedColorStyle) {
                writer.write("<style:style style:name='");
                writer.write(colorStyle.getName());
                writer.write("' style:family='graphics' style:parent-style-name='special:ventilation'>\n");
                writer.write("\t<style:properties svg:stroke-color='");
                writer.write(ColorUtils.toHexFormat((Color)colorStyle.getColor()));
                writer.write("'/>\n");
                writer.write("</style:style>\n");
            }
            for (BoxSkin boxskin : this.usedBoxSkin) {
                SxdExport.writeBoxSkin(writer, boxskin);
            }
            writer.write("<style:style style:name='special:fleche' style:family='graphics' style:parent-style-name='standard'>");
            writer.write("</style:style>\n");
            writer.write("<style:style style:name='special:fleche/both' style:family='graphics' style:parent-style-name='special:fleche'>");
            writer.write("<style:properties draw:marker-end='Arrow' draw:marker-end-width='0.15cm' draw:marker-start='Arrow' draw:marker-start-width='0.15cm'/>");
            writer.write("</style:style>\n");
            writer.write("<style:style style:name='special:fleche/start' style:family='graphics' style:parent-style-name='special:fleche'>");
            writer.write("<style:properties draw:marker-start='Arrow' draw:marker-start-width='0.15cm' />");
            writer.write("</style:style>\n");
            writer.write("<style:style style:name='special:fleche/end' style:family='graphics' style:parent-style-name='special:fleche'>");
            writer.write("<style:properties draw:marker-end='Arrow' draw:marker-end-width='0.15cm' />");
            writer.write("</style:style>\n");
            writer.write("</office:styles>");
            writer.write("<office:automatic-styles><style:page-master style:name='PM0'><style:properties fo:margin-top='0.635cm' fo:margin-bottom='0.496cm' fo:margin-left='0.601cm' fo:margin-right='0.648cm' fo:page-width='29.7cm' fo:page-height='21cm' style:print-orientation='landscape'/></style:page-master><style:style style:name='dp1' style:family='drawing-page'><style:properties draw:background-size='border' draw:fill='none'/></style:style></office:automatic-styles><office:master-styles><draw:layer-set><draw:layer draw:name='layout'/><draw:layer draw:name='background'/><draw:layer draw:name='backgroundobjects'/><draw:layer draw:name='controls'/><draw:layer draw:name='measurelines'/></draw:layer-set><style:master-page style:name='Standard' style:page-master-name='PM0' draw:style-name='dp1'/></office:master-styles>");
            writer.flush();
        }
        catch (IOException ioe) {
            throw new SXIOException(ioe);
        }
    }

    public static void writeBoxSkin(Writer writer, BoxSkin boxSkin) throws IOException {
        Font font = boxSkin.getFont();
        Insets marges = boxSkin.getPaddingInsets();
        writer.write("<style:style style:name='boite:");
        XMLUtils.writeEscape((Appendable)writer, (String)boxSkin.getSkinName());
        writer.write(39);
        writer.write(" style:family='graphics' style:parent-style-name='");
        writer.write("standard");
        writer.write("'>\n");
        writer.write("\t<style:properties ");
        Color borderColor = boxSkin.getBorderColor();
        if (borderColor != null) {
            writer.write(" draw:stroke='solid' svg:stroke-width='0pt' svg:stroke-color='");
            writer.write(ColorUtils.toHexFormat((Color)borderColor));
            writer.write(39);
        } else {
            writer.write(" draw:stroke='none'");
        }
        if (boxSkin.isOpaque()) {
            writer.write(" draw:fill='solid' draw:fill-color='");
            writer.write(ColorUtils.toHexFormat((Color)boxSkin.getBackgroundColor()));
            writer.write(39);
        } else {
            writer.write(" draw:fill='none'");
        }
        writer.write(" \tfo:color='");
        writer.write(ColorUtils.toHexFormat((Color)boxSkin.getTextColor()));
        writer.write(39);
        writer.write(" fo:font-size='");
        writer.write(String.valueOf(font.getSize()));
        writer.write("pt'");
        writer.write(" fo:padding-left='");
        writer.write(String.valueOf(marges.left - 1));
        writer.write("pt'");
        writer.write(" fo:padding-top='");
        writer.write(String.valueOf(marges.top - 1));
        writer.write("pt'");
        writer.write(" fo:padding-right='");
        writer.write(String.valueOf(marges.right - 1));
        writer.write("pt'");
        writer.write(" fo:padding-bottom='");
        writer.write(String.valueOf(marges.bottom - 1));
        writer.write("pt'");
        writer.write(" fo:font-family='");
        XMLUtils.writeEscape((Appendable)writer, (String)font.getName());
        writer.write(39);
        writer.write(" fo:text-align='center' draw:textarea-vertical-align='middle' ");
        writer.write(" style:font-family-generic='swiss' style:font-pitch='variable'   fo:text-indent='0pt'");
        writer.write("/>\n");
        writer.write("</style:style>\n");
    }
}

