/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;

public class TransversalLineComponent
extends JComponent {
    private Point startPoint = null;
    private Point endPoint = null;

    public TransversalLineComponent(Dimension dim) {
        this.setLocation(0, 0);
        this.setVisible(false);
        this.setSize(dim);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.startPoint != null && this.endPoint != null) {
            g.setColor(Color.BLUE);
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            g.drawLine(this.startPoint.x, this.startPoint.y - 7, this.startPoint.x, this.startPoint.y + 7);
            g.drawLine(this.startPoint.x - 7, this.startPoint.y, this.startPoint.x + 7, this.startPoint.y);
        }
    }

    public void hideLine() {
        this.endPoint = null;
        this.startPoint = null;
        this.setVisible(false);
    }

    public void move(Point P) {
        if (this.endPoint == null) {
            this.reinit(P);
        }
        this.endPoint = P;
        this.repaint();
    }

    private void reinit(Point P) {
        this.endPoint = null;
        this.startPoint = P;
        this.setVisible(P != null);
    }
}

