/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display;

import java.awt.Graphics;

public final class GraphicsUtils {
    private GraphicsUtils() {
    }

    public static void drawPoint(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    public static void drawHorizontalLine(Graphics g, int x, int y, int length) {
        g.drawLine(x, y, x + length - 1, y);
    }

    public static void drawVerticalLine(Graphics g, int x, int y, int length) {
        g.drawLine(x, y, x, y + length - 1);
    }

    public static void drawDottedRect(Graphics g, int x, int y, int width, int height, int dotSize) {
        GraphicsUtils.drawDottedHorizontalLine(g, x, y, width, dotSize);
        GraphicsUtils.drawDottedHorizontalLine(g, x, y + height - 1, width, dotSize);
    }

    public static void drawDottedHorizontalLine(Graphics g, int x, int y, int length, int dotSize) {
        int pas = dotSize * 2;
        int longueur = length / pas;
        for (int i = 0; i < longueur; ++i) {
            GraphicsUtils.drawHorizontalLine(g, x + i * pas, y, dotSize);
        }
    }
}

