/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.metadata.AtlasAttributeDefList;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LangFilter;

public final class AtlasUtils {
    public static final AtlasFilter ACCEPTALL_ATLASFILTER = new AcceptAllAtlasFilter(false);
    public static final AtlasFilter ONLYSTRUCTURE_ATLASFILTER = new AcceptAllAtlasFilter(true);
    public static final AtlasAttributeDefList EMPTY_ATLASATTRIBUTEDEFLIST = new EmptyAtlasAttributeDefList();
    public static final LangFilter ACCEPTALL_LANGFILTER = new AcceptAllLangFilter();

    private AtlasUtils() {
    }

    public static boolean stillExists(Term term) {
        Term existingTerm = term.getAtlas().getTerm(term.getCode());
        return existingTerm != null;
    }

    public static String toLibelleString(Term term, Lang lang) {
        Label libelle = term.getLabels().getLangPartCheckedLabel(lang);
        if (libelle != null) {
            return libelle.getLabelString();
        }
        return "?";
    }

    public static boolean isLangUsed(Atlas atlas, Lang lang) {
        Set<Lang> set = AtlasUtils.getUsedLangSet(atlas);
        return set.contains(lang);
    }

    public static Set<Lang> getUsedLangSet(Atlas atlas) {
        Set<Lang> set = AtlasUtils.getUsedLangSet(atlas.getStructure());
        set.addAll(AtlasUtils.getUsedLangSet(atlas.getDescripteurs()));
        return set;
    }

    public static Set<Lang> getUsedLangSet(Structure structure) {
        Set<Lang> set = AtlasUtils.getUsedLangSet(structure.getGrilleDesFamilles());
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            AtlasUtils.analyse(grilleList.getGrille(i), set);
        }
        return set;
    }

    public static Set<Lang> getUsedLangSet(Grille grille) {
        HashSet<Lang> set = new HashSet<Lang>();
        AtlasUtils.analyse(grille, set);
        return set;
    }

    private static void analyse(Grille grille, Set<Lang> set) {
        ContexteList contexteList = grille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            AtlasUtils.analyse(contexteList.getContexte(i), set);
        }
    }

    public static Set<Lang> getUsedLangSet(Descripteurs descripteurs) {
        List<DescripteurList> descripteursLists = DescripteursUtils.getListOfDescripteurList(descripteurs);
        HashSet<Lang> set = new HashSet<Lang>();
        for (DescripteurList descripteurList : descripteursLists) {
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int i = 0; i < descripteurCount; ++i) {
                Descripteur descripteur = descripteurList.getDescripteur(i);
                for (Label label : descripteur.getLabels()) {
                    set.add(label.getLang());
                }
            }
        }
        return set;
    }

    public static boolean updateAttributes(AtlasEditor atlasEditor, Object attributesHolder, AttributeChange attributeChange) {
        boolean doneAttr;
        boolean done = false;
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            doneAttr = atlasEditor.putAttribute(attributesHolder, attribute);
            if (!doneAttr) continue;
            done = true;
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            doneAttr = atlasEditor.removeAttribute(attributesHolder, removedAttributeKey);
            if (!doneAttr) continue;
            done = true;
        }
        return done;
    }

    public static boolean updateLabelHolder(AtlasEditor atlasEditor, Object labelHolder, LabelChange labelChange) {
        boolean stepDone;
        boolean done = false;
        for (Label label : labelChange.getChangedLabels()) {
            stepDone = atlasEditor.putLibelle(labelHolder, label);
            if (!stepDone) continue;
            done = true;
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            stepDone = atlasEditor.removeLibelle(labelHolder, lang);
            if (!stepDone) continue;
            done = true;
        }
        return done;
    }

    private static void analyse(Contexte contexte, Set<Lang> set) {
        for (Label label : contexte.getLabels()) {
            set.add(label.getLang());
        }
        ContexteList contexteList = contexte.getChildren();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            AtlasUtils.analyse(contexteList.getContexte(i), set);
        }
    }

    private static class AcceptAllAtlasFilter
    implements AtlasFilter {
        private final boolean onlyStructure;

        private AcceptAllAtlasFilter(boolean onlyStructure) {
            this.onlyStructure = onlyStructure;
        }

        @Override
        public boolean onlyStructure() {
            return this.onlyStructure;
        }

        @Override
        public LangFilter getLangFilter() {
            return ACCEPTALL_LANGFILTER;
        }

        @Override
        public boolean acceptDescripteur(Descripteur descripteur) {
            return true;
        }
    }

    private static class EmptyAtlasAttributeDefList
    implements AtlasAttributeDefList {
        private EmptyAtlasAttributeDefList() {
        }

        @Override
        public int getAttributeDefCount() {
            return 0;
        }

        @Override
        public AttributeDef getAttributeDef(int i) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getInactiveAttributeKeyCount() {
            return 0;
        }

        @Override
        public AttributeKey getInactiveAttributeKey(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class AcceptAllLangFilter
    implements LangFilter {
        private AcceptAllLangFilter() {
        }

        public boolean accept(Lang lang) {
            return true;
        }
    }
}

