/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.search;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.text.lexie.LexieParseHandler;
import net.mapeadores.util.text.lexie.LexieParser;
import net.mapeadores.util.text.search.SearchToken;
import net.mapeadores.util.text.search.SearchUtils;
import net.mapeadores.util.text.search.SimpleSearchToken;

public class SearchTokenParser {
    private final String source;
    private final int defaultSearchType;
    private final List<SearchToken> tokenList = new ArrayList<SearchToken>();
    private final List<SimpleSearchToken> quoteList = new ArrayList<SimpleSearchToken>();
    private int currentType = 0;
    private String currentWord = null;
    private boolean onQuote = false;

    private SearchTokenParser(String source, int defaultSearchType) {
        this.source = source;
        this.defaultSearchType = defaultSearchType;
    }

    private List<SearchToken> parse() {
        LexieParser.parse(this.source, new InternalHandler());
        if (this.onQuote) {
            this.flushQuote();
        } else {
            this.flushCurrentWord();
        }
        return this.tokenList;
    }

    private void flushCurrentWord() {
        if (this.currentWord != null) {
            if (this.onQuote) {
                this.quoteList.add(SearchUtils.toSimpleSearchToken(this.currentWord, this.currentType));
            } else {
                this.tokenList.add(SearchUtils.toSimpleSearchToken(this.currentWord, this.currentType | this.defaultSearchType));
            }
            this.currentWord = null;
            this.currentType = 0;
        }
    }

    private void flushQuote() {
        this.flushCurrentWord();
        int size = this.quoteList.size();
        if (size > 0) {
            SimpleSearchToken[] array = new SimpleSearchToken[size];
            for (int j = 0; j < size; ++j) {
                array[j] = this.quoteList.get(j);
            }
            int p = this.tokenList.size();
            this.tokenList.add(SearchUtils.toMultiSearchToken(array));
        }
        this.onQuote = false;
        this.quoteList.clear();
    }

    public static List<SearchToken> parse(String source, int defaultSearchType) {
        SearchTokenParser parser = new SearchTokenParser(source, defaultSearchType);
        return parser.parse();
    }

    private class InternalHandler
    implements LexieParseHandler {
        private InternalHandler() {
        }

        @Override
        public void flushLexie(String word, int wordStart) {
            SearchTokenParser.this.flushCurrentWord();
            SearchTokenParser.this.currentWord = word;
        }

        @Override
        public void checkSpecialChar(char carac) {
            switch (carac) {
                case '*': {
                    if (SearchTokenParser.this.currentWord == null) {
                        SearchTokenParser.this.currentType = 2;
                        break;
                    }
                    SearchTokenParser.this.currentType = SearchTokenParser.this.currentType | 1;
                    SearchTokenParser.this.flushCurrentWord();
                    break;
                }
                case '\"': {
                    if (SearchTokenParser.this.onQuote) {
                        SearchTokenParser.this.flushQuote();
                        break;
                    }
                    SearchTokenParser.this.flushCurrentWord();
                    SearchTokenParser.this.onQuote = true;
                    break;
                }
                default: {
                    SearchTokenParser.this.flushCurrentWord();
                }
            }
        }
    }
}

