/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.text.ParseException;

public final class Idalpha {
    private Idalpha() {
    }

    public static boolean isSignificant(String idalpha) {
        if (idalpha == null) {
            return false;
        }
        if (idalpha.isEmpty()) {
            return false;
        }
        return !idalpha.startsWith("_");
    }

    public static void test(String idalpha) throws ParseException {
        if (idalpha == null) {
            throw new IllegalArgumentException("idalpha is null");
        }
        if (idalpha.length() == 0) {
            throw new IllegalArgumentException("idalpha is empty");
        }
        int length = idalpha.length();
        for (int i = 0; i < length; ++i) {
            char carac = idalpha.charAt(i);
            if (carac == ' ') {
                if (i == 0) {
                    throw new ParseException("starting with space : " + idalpha, i);
                }
                if (i == length - 1) {
                    throw new ParseException("idalpha ending with space : " + idalpha, i);
                }
                if (idalpha.charAt(i - 1) != ' ') continue;
                throw new ParseException("two following spaces (idalpha : " + idalpha, i);
            }
            if (Idalpha.isValidNoSpaceChar(carac)) continue;
            throw new ParseException("Wrong character = " + carac + " (idalpha=" + idalpha + ")", i);
        }
    }

    public static boolean isValid(String idalpha) {
        try {
            Idalpha.test(idalpha);
            return true;
        }
        catch (IllegalArgumentException | ParseException e) {
            return false;
        }
    }

    public static boolean isValidNoSpaceChar(char carac) {
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        switch (carac) {
            case '(': 
            case ')': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '@': 
            case '[': 
            case ']': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }
}

