/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.request.RequestConf;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.request.SupplementaryParameter;

public class RequestConfBuilder {
    private final Map<String, InternalSupplementaryParameter> map = new LinkedHashMap<String, InternalSupplementaryParameter>();
    private final AttributesBuilder attributesBuilder = new AttributesBuilder();

    public RequestConfBuilder addParameter(String name, Collection<String> values) {
        if (values.isEmpty()) {
            return this;
        }
        InternalSupplementaryParameter supplementaryParameter = this.map.get(name);
        if (supplementaryParameter == null) {
            supplementaryParameter = new InternalSupplementaryParameter(name);
            this.map.put(name, supplementaryParameter);
        }
        supplementaryParameter.add(values);
        return this;
    }

    public AttributesBuilder getAttributesBuilder() {
        return this.attributesBuilder;
    }

    public RequestConf toRequestConf() {
        List<SupplementaryParameter> supplementaryParameterList = RequestUtils.wrap(this.map.values().toArray(new SupplementaryParameter[this.map.size()]));
        return new InternalRequestConf(supplementaryParameterList, this.attributesBuilder.toAttributes());
    }

    public static RequestConfBuilder init() {
        return new RequestConfBuilder();
    }

    private static class InternalSupplementaryParameter
    implements SupplementaryParameter {
        private final String name;
        private final boolean append = false;
        private final List<String> valueList = new ArrayList<String>();

        private InternalSupplementaryParameter(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean appendToExisting() {
            return false;
        }

        @Override
        public boolean isArray() {
            return this.valueList.size() == 1;
        }

        @Override
        public String getValue() {
            return this.valueList.get(0);
        }

        @Override
        public String[] getValueArray() {
            return this.valueList.toArray(new String[this.valueList.size()]);
        }

        private void add(Collection<String> values) {
            this.valueList.addAll(values);
        }
    }

    private static class InternalRequestConf
    implements RequestConf {
        private final List<SupplementaryParameter> supplementaryParameterList;
        private final Attributes attributes;

        private InternalRequestConf(List<SupplementaryParameter> supplementaryParameterList, Attributes attributes) {
            this.supplementaryParameterList = supplementaryParameterList;
            this.attributes = attributes;
        }

        @Override
        public List<SupplementaryParameter> getSupplementaryParameterList() {
            return this.supplementaryParameterList;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

