/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.regex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionParser;

public class RegexList {
    private final List<Couple> list = new ArrayList<Couple>();

    public int getRegexCount() {
        return this.list.size();
    }

    public static RegexList parse(String s) {
        BufferedReader bufReader = new BufferedReader(new StringReader(s));
        RegexList regexList = new RegexList();
        String ligne = null;
        int p = 0;
        try {
            while ((ligne = bufReader.readLine()) != null) {
                ++p;
                int length = (ligne = ligne.trim()).length();
                if (length == 0) continue;
                int idx = -1;
                for (int i = 0; i < length; ++i) {
                    char c = ligne.charAt(i);
                    if (!Character.isWhitespace(c)) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) continue;
                String patternString = ligne.substring(0, idx);
                String result = ligne.substring(idx + 1).trim();
                Pattern pattern = null;
                try {
                    pattern = Pattern.compile(patternString);
                }
                catch (PatternSyntaxException pse) {
                    continue;
                }
                Instruction instruction = InstructionParser.parse(result, null);
                regexList.add(pattern, instruction);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return regexList;
    }

    private void add(Pattern pattern, Instruction instruction) {
        HashMap<Integer, String> groupMap = new HashMap<Integer, String>();
        HashMap<String, String> constantsMap = new HashMap<String, String>();
        for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getValue();
            if (value == null) {
                constantsMap.put(key, "");
                continue;
            }
            int sl = value.length();
            if (sl > 1 && value.charAt(0) == '$') {
                try {
                    int id = Integer.parseInt(value.substring(1));
                    if (id > 0) {
                        groupMap.put(id, key);
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            constantsMap.put(key, value);
        }
        this.add(pattern, groupMap, constantsMap);
    }

    private void add(Pattern pattern, Map<Integer, String> groupMap, Map<String, String> constantsMap) {
        this.list.add(new Couple(pattern, groupMap, constantsMap));
    }

    public Map<String, String> getMap(String s) {
        for (Couple couple : this.list) {
            Map<String, String> map = couple.getResultMap(s);
            if (map == null) continue;
            return map;
        }
        return null;
    }

    private class Couple {
        private final Pattern pattern;
        private final Map<String, String> constantsMap;
        private final Map<Integer, String> groupMap;

        Couple(Pattern pattern, Map<Integer, String> groupMap, Map<String, String> constantsMap) {
            this.pattern = pattern;
            this.groupMap = groupMap;
            this.constantsMap = constantsMap;
        }

        public Map<String, String> getResultMap(String s) {
            Matcher matcher = this.pattern.matcher(s);
            if (!matcher.matches()) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>(this.constantsMap);
            int groupCount = matcher.groupCount();
            for (int i = 1; i <= groupCount; ++i) {
                String key = this.groupMap.get(i);
                if (key == null) continue;
                map.put(key, matcher.group(i));
            }
            return map;
        }
    }
}

