/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.conditions;

import java.text.RuleBasedCollator;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.collation.CollationUnit;

public class CollatedStringTestUnit {
    private final TextTest textTest;
    private final String searchCollatedString;

    private CollatedStringTestUnit(TextTest textTest, String searchCollatedString) {
        this.textTest = textTest;
        this.searchCollatedString = searchCollatedString;
    }

    public TextTest getTextTest() {
        return this.textTest;
    }

    public boolean accept(String collatedString) {
        switch (this.textTest.getTestType()) {
            case 15: {
                return collatedString.length() == 0;
            }
            case 20: {
                return collatedString.length() > 0;
            }
            case 19: {
                return !collatedString.equals(this.searchCollatedString);
            }
            case 16: {
                return !collatedString.startsWith(this.searchCollatedString);
            }
            case 17: {
                return !collatedString.endsWith(this.searchCollatedString);
            }
            case 18: {
                return !collatedString.contains(this.searchCollatedString);
            }
            case 14: {
                return collatedString.equals(this.searchCollatedString);
            }
            case 11: {
                return collatedString.startsWith(this.searchCollatedString);
            }
            case 12: {
                return collatedString.endsWith(this.searchCollatedString);
            }
            case 13: {
                return collatedString.contains(this.searchCollatedString);
            }
        }
        throw new SwitchException("unknown testType: " + this.textTest.getTestType());
    }

    public static CollatedStringTestUnit newInstance(TextTest textTest, RuleBasedCollator collator) {
        String searchCollatedString;
        switch (textTest.getTestType()) {
            case 15: 
            case 20: {
                searchCollatedString = "";
                break;
            }
            default: {
                searchCollatedString = CollationUnit.collate(textTest.getText(), collator);
            }
        }
        return new CollatedStringTestUnit(textTest, searchCollatedString);
    }
}

