/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.awt;

import java.awt.Color;

public class ColorSkin {
    private Color backgroundColor = null;
    private Color selectedBackgroundColor = null;
    private Color textColor = null;
    private Color selectedTextColor = null;
    private ColorSkin parent;
    private String name;

    public ColorSkin() {
        this.backgroundColor = Color.WHITE;
        this.selectedBackgroundColor = new Color(128, 128, 255);
        this.textColor = Color.BLACK;
        this.selectedTextColor = Color.YELLOW;
        this.name = "_default";
    }

    ColorSkin(ColorSkin parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public ColorSkin(String name, Color txtColor, Color bgColor, Color selTxtColor, Color selBgColor) {
        this.name = name;
        this.textColor = txtColor != null ? txtColor : Color.BLACK;
        this.backgroundColor = bgColor != null ? bgColor : Color.WHITE;
        this.selectedTextColor = selTxtColor != null ? selTxtColor : Color.YELLOW;
        this.selectedBackgroundColor = selBgColor != null ? selBgColor : new Color(128, 128, 255);
    }

    public ColorSkin(String name, ColorSkin colorSkin) {
        this.name = name;
        this.textColor = colorSkin.textColor;
        this.backgroundColor = colorSkin.backgroundColor;
        this.selectedTextColor = colorSkin.selectedTextColor;
        this.selectedBackgroundColor = colorSkin.selectedBackgroundColor;
    }

    public String getSkinName() {
        return this.name;
    }

    public Color getTextColor() {
        if (this.textColor == null) {
            return this.parent.textColor;
        }
        return this.textColor;
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return this.parent.backgroundColor;
        }
        return this.backgroundColor;
    }

    public Color getSelectedTextColor() {
        if (this.selectedTextColor == null) {
            return this.parent.selectedTextColor;
        }
        return this.selectedTextColor;
    }

    public Color getSelectedBackgroundColor() {
        if (this.selectedBackgroundColor == null) {
            return this.parent.selectedBackgroundColor;
        }
        return this.selectedBackgroundColor;
    }

    public ColorSkin deriveColorSkin(String name, Color txtColor, Color bgColor, Color selTxtColor, Color selBgColor) {
        ColorSkin colorSkin = new ColorSkin(this, name);
        if (txtColor != null) {
            colorSkin.textColor = txtColor;
        }
        if (bgColor != null) {
            colorSkin.backgroundColor = bgColor;
        }
        if (selTxtColor != null) {
            colorSkin.selectedTextColor = selTxtColor;
        }
        if (selBgColor != null) {
            colorSkin.selectedBackgroundColor = selBgColor;
        }
        return colorSkin;
    }

    protected void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    protected void setSelectedTextColor(Color selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    protected void setSelectedBackgroundColor(Color selectedBackgroundColor) {
        this.selectedBackgroundColor = selectedBackgroundColor;
    }

    public static ColorSkin createFondColorSkin(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hue = hsb[0] * 360.0f;
        float saturation = hsb[1];
        float brightness = hsb[2];
        Color selectedTextColor = Color.BLACK;
        if ((double)brightness <= 0.7) {
            selectedTextColor = Color.WHITE;
        } else if (hue >= 200.0f && (double)saturation >= 0.3) {
            selectedTextColor = Color.WHITE;
        } else if (hue <= 45.0f && (double)saturation >= 0.8) {
            selectedTextColor = Color.WHITE;
        }
        return new ColorSkin("name", Color.BLACK, Color.WHITE, selectedTextColor, color);
    }
}

