/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.money.ExtendedCurrency;

public final class OdCellKey {
    private final short styleFamily;
    private final ExtendedCurrency currency;
    private final String styleName;

    private OdCellKey(short styleFamily, ExtendedCurrency currency, String styleName) {
        this.styleFamily = styleFamily;
        this.currency = currency;
        this.styleName = styleName;
    }

    public short getStyleFamliy() {
        return this.styleFamily;
    }

    @Nullable
    public ExtendedCurrency getCurrency() {
        return this.currency;
    }

    @Nullable
    public String getStyleName() {
        return this.styleName;
    }

    public int hashCode() {
        int code = this.styleFamily;
        if (this.currency != null) {
            code += this.currency.hashCode();
        }
        if (this.styleName != null) {
            code += this.styleName.hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        OdCellKey odCellKey = (OdCellKey)other;
        if (odCellKey.styleFamily != this.styleFamily) {
            return false;
        }
        if (odCellKey.currency == null) {
            if (this.currency != null) {
                return false;
            }
        } else {
            if (this.currency == null) {
                return false;
            }
            if (!odCellKey.currency.equals(this.currency)) {
                return false;
            }
        }
        if (odCellKey.styleName == null) {
            return this.styleName == null;
        }
        if (this.styleName == null) {
            return false;
        }
        return odCellKey.styleName.equals(this.styleName);
    }

    public static OdCellKey newInstance(short styleFamily, String styleName) {
        if (styleFamily == 2) {
            throw new IllegalArgumentException("Not use with styleFamily = OdColumnDef.CURRENCY_STYLE_FAMILY");
        }
        return new OdCellKey(styleFamily, null, styleName);
    }

    public static OdCellKey newInstance(short styleFamily, ExtendedCurrency currency, String styleName) {
        if (styleFamily != 2) {
            currency = null;
        }
        return new OdCellKey(styleFamily, currency, styleName);
    }

    public static OdCellKey newStandardInstance(String styleName) {
        return new OdCellKey(0, null, styleName);
    }

    public static OdCellKey newDateInstance(String styleName) {
        return new OdCellKey(1, null, styleName);
    }

    public static OdCellKey newCurrencyInstance(ExtendedCurrency currency, String styleName) {
        return new OdCellKey(2, currency, styleName);
    }
}

