/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.selection.RedacteurQuery;
import net.fichotheque.selection.RedacteurSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.RedacteurSelectEngine;
import net.mapeadores.util.annotation.Nullable;

public class RedacteurSelectorBuilder {
    private final SelectionContext selectionContext;
    private final Map<SubsetKey, List<RedacteurSelectEngine>> listMap = new HashMap<SubsetKey, List<RedacteurSelectEngine>>();
    private final List<Sphere> sphereList = new ArrayList<Sphere>();
    private RedacteurSelectEngine firstEngine;
    private int engineCount = 0;

    public RedacteurSelectorBuilder(SelectionContext selectionContext) {
        this.selectionContext = selectionContext;
    }

    public RedacteurSelectorBuilder add(RedacteurQuery redacteurQuery) {
        Sphere[] sphereArray = SelectionUtils.toSphereArray(this.selectionContext.getFichotheque(), redacteurQuery, this.selectionContext.getSubsetAccessPredicate());
        RedacteurSelectEngine documentSelectEngine = new RedacteurSelectEngine(redacteurQuery, this.selectionContext);
        if (this.firstEngine == null) {
            this.firstEngine = documentSelectEngine;
        }
        ++this.engineCount;
        for (Sphere sphere : sphereArray) {
            List<RedacteurSelectEngine> list = this.checkSphere(sphere);
            list.add(documentSelectEngine);
        }
        return this;
    }

    public RedacteurSelectorBuilder addAll(Collection<RedacteurQuery> collection) {
        for (RedacteurQuery query : collection) {
            this.add(query);
        }
        return this;
    }

    public RedacteurSelector toRedacteurSelector() {
        switch (this.engineCount) {
            case 0: {
                List<Sphere> finalSphereList = FichothequeUtils.wrap(FichothequeUtils.toSphereArray(this.selectionContext.getFichotheque(), this.selectionContext.getSubsetAccessPredicate()));
                return new UniqueRedacteurSelector(finalSphereList, null, new RedacteurSelectEngine(SelectionUtils.EMPTY_REDACTEURQUERY, this.selectionContext));
            }
            case 1: {
                List<Sphere> finalSphereList = FichothequeUtils.wrap(this.sphereList.toArray(new Sphere[this.sphereList.size()]));
                return new UniqueRedacteurSelector(finalSphereList, new HashSet<SubsetKey>(this.listMap.keySet()), this.firstEngine);
            }
        }
        List<Sphere> finalSphereList = FichothequeUtils.wrap(this.sphereList.toArray(new Sphere[this.sphereList.size()]));
        HashMap<SubsetKey, RedacteurSelectEngine[]> arrayMap = new HashMap<SubsetKey, RedacteurSelectEngine[]>();
        for (Map.Entry<SubsetKey, List<RedacteurSelectEngine>> entry : this.listMap.entrySet()) {
            List<RedacteurSelectEngine> list = entry.getValue();
            RedacteurSelectEngine[] array = list.toArray(new RedacteurSelectEngine[list.size()]);
            arrayMap.put(entry.getKey(), array);
        }
        return new MultiRedacteurSelector(finalSphereList, arrayMap);
    }

    private List<RedacteurSelectEngine> checkSphere(Sphere sphere) {
        List<RedacteurSelectEngine> currentList = this.listMap.get(sphere.getSubsetKey());
        if (currentList == null) {
            currentList = new ArrayList<RedacteurSelectEngine>();
            this.sphereList.add(sphere);
            this.listMap.put(sphere.getSubsetKey(), currentList);
        }
        return currentList;
    }

    public static RedacteurSelectorBuilder init(SelectionContext selectionContext) {
        return new RedacteurSelectorBuilder(selectionContext);
    }

    private static class UniqueRedacteurSelector
    implements RedacteurSelector {
        private final List<Sphere> sphereList;
        private final Set<SubsetKey> keySet;
        private final RedacteurSelectEngine redacteurSelectEngine;

        private UniqueRedacteurSelector(List<Sphere> sphereList, @Nullable Set<SubsetKey> keySet, RedacteurSelectEngine redacteurSelectEngine) {
            this.sphereList = sphereList;
            this.keySet = keySet;
            this.redacteurSelectEngine = redacteurSelectEngine;
        }

        @Override
        public List<Sphere> getSphereList() {
            return this.sphereList;
        }

        @Override
        public boolean test(Redacteur redacteur) {
            if (this.keySet != null && !this.keySet.contains(redacteur.getSubsetKey())) {
                return false;
            }
            return this.redacteurSelectEngine.isSelected(redacteur);
        }

        @Override
        public Junction isSelected(Redacteur redacteur, Junction junction) {
            return null;
        }
    }

    private static class MultiRedacteurSelector
    implements RedacteurSelector {
        private final List<Sphere> sphereList;
        private final Map<SubsetKey, RedacteurSelectEngine[]> arrayMap;

        private MultiRedacteurSelector(List<Sphere> sphereList, Map<SubsetKey, RedacteurSelectEngine[]> arrayMap) {
            this.sphereList = sphereList;
            this.arrayMap = arrayMap;
        }

        @Override
        public List<Sphere> getSphereList() {
            return this.sphereList;
        }

        @Override
        public boolean test(Redacteur redacteur) {
            RedacteurSelectEngine[] array = this.arrayMap.get(redacteur.getSubsetKey());
            if (array == null) {
                return false;
            }
            for (RedacteurSelectEngine engine : array) {
                if (!engine.isSelected(redacteur)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Junction isSelected(Redacteur redacteur, Junction junction) {
            return null;
        }
    }
}

