/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FilteredJunctionBuilder;
import net.fichotheque.utils.selection.MotcleSelectEngine;
import net.mapeadores.util.annotation.Nullable;

public class MotcleSelectorBuilder {
    private final SelectionContext selectionContext;
    private final Map<SubsetKey, List<MotcleSelectEngine>> listMap = new HashMap<SubsetKey, List<MotcleSelectEngine>>();
    private final List<Thesaurus> thesaurusList = new ArrayList<Thesaurus>();
    private MotcleSelectEngine firstEngine;
    private int engineCount = 0;

    public MotcleSelectorBuilder(SelectionContext selectionContext) {
        this.selectionContext = selectionContext;
    }

    public MotcleSelectorBuilder add(MotcleQuery motcleQuery) {
        return this.add(motcleQuery, null);
    }

    public MotcleSelectorBuilder add(MotcleQuery motcleQuery, JunctionCondition junctionCondition) {
        Thesaurus[] thesaurusArray = SelectionUtils.toThesaurusArray(this.selectionContext.getFichotheque(), motcleQuery, this.selectionContext.getSubsetAccessPredicate());
        MotcleSelectEngine motcleSelectEngine = new MotcleSelectEngine(motcleQuery, junctionCondition, this.selectionContext);
        if (this.firstEngine == null) {
            this.firstEngine = motcleSelectEngine;
        }
        ++this.engineCount;
        for (Thesaurus thesaurus : thesaurusArray) {
            List<MotcleSelectEngine> list = this.checkThesaurus(thesaurus);
            list.add(motcleSelectEngine);
        }
        return this;
    }

    public MotcleSelectorBuilder addAll(Collection<MotcleCondition.Entry> entries) {
        for (MotcleCondition.Entry entry : entries) {
            this.add(entry.getMotcleQuery(), entry.getJunctionCondition());
        }
        return this;
    }

    public MotcleSelector toMotcleSelector() {
        switch (this.engineCount) {
            case 0: {
                List<Thesaurus> finalThesaurusList = FichothequeUtils.wrap(FichothequeUtils.toThesaurusArray(this.selectionContext.getFichotheque(), this.selectionContext.getSubsetAccessPredicate()));
                return new UniqueMotcleSelector(finalThesaurusList, null, new MotcleSelectEngine(SelectionUtils.EMPTY_MOTCLEQUERY, null, this.selectionContext));
            }
            case 1: {
                List<Thesaurus> finalThesaurusList = FichothequeUtils.wrap(this.thesaurusList.toArray(new Thesaurus[this.thesaurusList.size()]));
                return new UniqueMotcleSelector(finalThesaurusList, new HashSet<SubsetKey>(this.listMap.keySet()), this.firstEngine);
            }
        }
        List<Thesaurus> finalThesaurusList = FichothequeUtils.wrap(this.thesaurusList.toArray(new Thesaurus[this.thesaurusList.size()]));
        HashMap<SubsetKey, MotcleSelectEngine[]> arrayMap = new HashMap<SubsetKey, MotcleSelectEngine[]>();
        for (Map.Entry<SubsetKey, List<MotcleSelectEngine>> entry : this.listMap.entrySet()) {
            List<MotcleSelectEngine> list = entry.getValue();
            MotcleSelectEngine[] array = list.toArray(new MotcleSelectEngine[list.size()]);
            arrayMap.put(entry.getKey(), array);
        }
        return new MultiMotcleSelector(finalThesaurusList, arrayMap);
    }

    public static MotcleSelectorBuilder init(SelectionContext selectionContext) {
        return new MotcleSelectorBuilder(selectionContext);
    }

    private List<MotcleSelectEngine> checkThesaurus(Thesaurus thesaurus) {
        List<MotcleSelectEngine> currentList = this.listMap.get(thesaurus.getSubsetKey());
        if (currentList == null) {
            currentList = new ArrayList<MotcleSelectEngine>();
            this.thesaurusList.add(thesaurus);
            this.listMap.put(thesaurus.getSubsetKey(), currentList);
        }
        return currentList;
    }

    private static class UniqueMotcleSelector
    implements MotcleSelector {
        private final List<Thesaurus> thesaurusList;
        private final Set<SubsetKey> keySet;
        private final MotcleSelectEngine motcleSelectEngine;

        private UniqueMotcleSelector(List<Thesaurus> thesaurusList, @Nullable Set<SubsetKey> keySet, MotcleSelectEngine motcleSelectEngine) {
            this.thesaurusList = thesaurusList;
            this.keySet = keySet;
            this.motcleSelectEngine = motcleSelectEngine;
        }

        @Override
        public List<Thesaurus> getThesaurusList() {
            return this.thesaurusList;
        }

        @Override
        public boolean test(Motcle motcle) {
            if (this.keySet != null && !this.keySet.contains(motcle.getSubsetKey())) {
                return false;
            }
            return this.motcleSelectEngine.isSelected(motcle);
        }

        @Override
        public Junction isSelected(Motcle motcle, Junction junction) {
            if (this.keySet != null && !this.keySet.contains(motcle.getSubsetKey())) {
                return null;
            }
            FilteredJunctionBuilder builder = new FilteredJunctionBuilder(junction);
            this.motcleSelectEngine.filter(motcle, builder);
            return builder.toJunction();
        }
    }

    private static class MultiMotcleSelector
    implements MotcleSelector {
        private final List<Thesaurus> thesaurusList;
        private final Map<SubsetKey, MotcleSelectEngine[]> arrayMap;

        private MultiMotcleSelector(List<Thesaurus> thesaurusList, Map<SubsetKey, MotcleSelectEngine[]> arrayMap) {
            this.thesaurusList = thesaurusList;
            this.arrayMap = arrayMap;
        }

        @Override
        public List<Thesaurus> getThesaurusList() {
            return this.thesaurusList;
        }

        @Override
        public boolean test(Motcle motcle) {
            MotcleSelectEngine[] array = this.arrayMap.get(motcle.getSubsetKey());
            if (array == null) {
                return false;
            }
            for (MotcleSelectEngine engine : array) {
                if (!engine.isSelected(motcle)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Junction isSelected(Motcle motcle, Junction junction) {
            MotcleSelectEngine[] array = this.arrayMap.get(motcle.getSubsetKey());
            if (array == null) {
                return null;
            }
            FilteredJunctionBuilder builder = new FilteredJunctionBuilder(junction);
            for (MotcleSelectEngine engine : array) {
                engine.filter(motcle, builder);
            }
            return builder.toJunction();
        }
    }
}

