/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.junction.Junction;
import net.fichotheque.selection.DocumentCondition;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.DocumentSelector;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.DocumentSelectEngine;
import net.fichotheque.utils.selection.FilteredJunctionBuilder;
import net.mapeadores.util.annotation.Nullable;

public class DocumentSelectorBuilder {
    private final SelectionContext selectionContext;
    private final Map<SubsetKey, List<DocumentSelectEngine>> listMap = new HashMap<SubsetKey, List<DocumentSelectEngine>>();
    private final List<Addenda> addendaList = new ArrayList<Addenda>();
    private DocumentSelectEngine firstEngine;
    private int engineCount = 0;

    public DocumentSelectorBuilder(SelectionContext selectionContext) {
        this.selectionContext = selectionContext;
    }

    public DocumentSelectorBuilder add(DocumentQuery documentQuery, JunctionCondition junctionCondition) {
        Addenda[] addendaArray = SelectionUtils.toAddendaArray(this.selectionContext.getFichotheque(), documentQuery, this.selectionContext.getSubsetAccessPredicate());
        DocumentSelectEngine documentSelectEngine = new DocumentSelectEngine(documentQuery, junctionCondition, this.selectionContext);
        if (this.firstEngine == null) {
            this.firstEngine = documentSelectEngine;
        }
        ++this.engineCount;
        for (Addenda addenda : addendaArray) {
            List<DocumentSelectEngine> list = this.checkAddenda(addenda);
            list.add(documentSelectEngine);
        }
        return this;
    }

    public DocumentSelectorBuilder addAll(Collection<DocumentCondition.Entry> entries) {
        for (DocumentCondition.Entry entry : entries) {
            this.add(entry.getDocumentQuery(), entry.getJunctionCondition());
        }
        return this;
    }

    public DocumentSelector toDocumentSelector() {
        switch (this.engineCount) {
            case 0: {
                List<Addenda> finalAddendaList = FichothequeUtils.wrap(FichothequeUtils.toAddendaArray(this.selectionContext.getFichotheque(), this.selectionContext.getSubsetAccessPredicate()));
                return new UniqueDocumentSelector(finalAddendaList, null, new DocumentSelectEngine(SelectionUtils.EMPTY_DOCUMENTQUERY, null, this.selectionContext));
            }
            case 1: {
                List<Addenda> finalAddendaList = FichothequeUtils.wrap(this.addendaList.toArray(new Addenda[this.addendaList.size()]));
                return new UniqueDocumentSelector(finalAddendaList, new HashSet<SubsetKey>(this.listMap.keySet()), this.firstEngine);
            }
        }
        List<Addenda> finalAddendaList = FichothequeUtils.wrap(this.addendaList.toArray(new Addenda[this.addendaList.size()]));
        HashMap<SubsetKey, DocumentSelectEngine[]> arrayMap = new HashMap<SubsetKey, DocumentSelectEngine[]>();
        for (Map.Entry<SubsetKey, List<DocumentSelectEngine>> entry : this.listMap.entrySet()) {
            List<DocumentSelectEngine> list = entry.getValue();
            DocumentSelectEngine[] array = list.toArray(new DocumentSelectEngine[list.size()]);
            arrayMap.put(entry.getKey(), array);
        }
        return new MultiDocumentSelector(finalAddendaList, arrayMap);
    }

    private List<DocumentSelectEngine> checkAddenda(Addenda addenda) {
        List<DocumentSelectEngine> currentList = this.listMap.get(addenda.getSubsetKey());
        if (currentList == null) {
            currentList = new ArrayList<DocumentSelectEngine>();
            this.addendaList.add(addenda);
            this.listMap.put(addenda.getSubsetKey(), currentList);
        }
        return currentList;
    }

    public static DocumentSelectorBuilder init(SelectionContext selectionContext) {
        return new DocumentSelectorBuilder(selectionContext);
    }

    private static class UniqueDocumentSelector
    implements DocumentSelector {
        private final List<Addenda> addendaList;
        private final Set<SubsetKey> keySet;
        private final DocumentSelectEngine documentSelectEngine;

        private UniqueDocumentSelector(List<Addenda> addendaList, @Nullable Set<SubsetKey> keySet, DocumentSelectEngine documentSelectEngine) {
            this.addendaList = addendaList;
            this.keySet = keySet;
            this.documentSelectEngine = documentSelectEngine;
        }

        @Override
        public List<Addenda> getAddendaList() {
            return this.addendaList;
        }

        @Override
        public boolean test(Document document) {
            if (this.keySet != null && !this.keySet.contains(document.getSubsetKey())) {
                return false;
            }
            return this.documentSelectEngine.isSelected(document);
        }

        @Override
        public Junction isSelected(Document document, Junction junction) {
            if (this.keySet != null && !this.keySet.contains(document.getSubsetKey())) {
                return null;
            }
            FilteredJunctionBuilder builder = new FilteredJunctionBuilder(junction);
            this.documentSelectEngine.filter(document, builder);
            return builder.toJunction();
        }
    }

    private static class MultiDocumentSelector
    implements DocumentSelector {
        private final List<Addenda> addendaList;
        private final Map<SubsetKey, DocumentSelectEngine[]> arrayMap;

        private MultiDocumentSelector(List<Addenda> addendaList, Map<SubsetKey, DocumentSelectEngine[]> arrayMap) {
            this.addendaList = addendaList;
            this.arrayMap = arrayMap;
        }

        @Override
        public List<Addenda> getAddendaList() {
            return this.addendaList;
        }

        @Override
        public boolean test(Document document) {
            DocumentSelectEngine[] array = this.arrayMap.get(document.getSubsetKey());
            if (array == null) {
                return false;
            }
            for (DocumentSelectEngine engine : array) {
                if (!engine.isSelected(document)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Junction isSelected(Document document, Junction junction) {
            DocumentSelectEngine[] array = this.arrayMap.get(document.getSubsetKey());
            if (array == null) {
                return null;
            }
            FilteredJunctionBuilder builder = new FilteredJunctionBuilder(junction);
            for (DocumentSelectEngine engine : array) {
                engine.filter(document, builder);
            }
            return builder.toJunction();
        }
    }
}

