/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.thesaurus.sync.MotcleSync;
import net.fichotheque.thesaurus.sync.ThesaurusSync;
import net.fichotheque.tools.thesaurus.sync.MotcleSyncBuilder;
import net.fichotheque.utils.SyncUtils;

public class ThesaurusSyncBuilder {
    private final Set<String> motcleSet = new HashSet<String>();
    private final List<MotcleSyncBuilder> firstLevelList = new ArrayList<MotcleSyncBuilder>();

    public ThesaurusSyncBuilder addFirstLevel(MotcleSyncBuilder motcleSyncBuilder) {
        this.firstLevelList.add(motcleSyncBuilder);
        this.motcleSet.add(motcleSyncBuilder.getIdalpha());
        return this;
    }

    public ThesaurusSyncBuilder addChild(MotcleSyncBuilder parent, MotcleSyncBuilder child) {
        parent.addChild(child);
        this.motcleSet.add(child.getIdalpha());
        return this;
    }

    public boolean contains(String idalpha) {
        return this.motcleSet.contains(idalpha);
    }

    public ThesaurusSync toThesaurusSync() {
        int size = this.firstLevelList.size();
        MotcleSync[] firstLevel = new MotcleSync[size];
        int p = 0;
        HashMap<String, MotcleSync> motcleSyncMap = new HashMap<String, MotcleSync>();
        for (MotcleSyncBuilder builder : this.firstLevelList) {
            MotcleSync motcleSync;
            firstLevel[p] = motcleSync = builder.toMotcleSync();
            ++p;
            this.add(motcleSync, motcleSyncMap);
        }
        return new InternalThesaurusSync(motcleSyncMap, SyncUtils.wrap(motcleSyncMap.values().toArray(new MotcleSync[motcleSyncMap.size()])), SyncUtils.wrap(firstLevel));
    }

    private void add(MotcleSync motcleSync, Map<String, MotcleSync> motcleSyncMap) {
        motcleSyncMap.put(motcleSync.getIdalpha(), motcleSync);
        for (MotcleSync child : motcleSync.getChildList()) {
            this.add(child, motcleSyncMap);
        }
    }

    private static class InternalThesaurusSync
    implements ThesaurusSync {
        private final Map<String, MotcleSync> motcleSyncMap;
        private final List<MotcleSync> motcleSyncList;
        private final List<MotcleSync> firstLevelList;

        private InternalThesaurusSync(Map<String, MotcleSync> motcleSyncMap, List<MotcleSync> motcleSyncList, List<MotcleSync> firstLevelList) {
            this.motcleSyncMap = motcleSyncMap;
            this.motcleSyncList = motcleSyncList;
            this.firstLevelList = firstLevelList;
        }

        @Override
        public MotcleSync getMotcleSync(String idalpha) {
            return this.motcleSyncMap.get(idalpha);
        }

        @Override
        public List<MotcleSync> getMotcleSyncList() {
            return this.motcleSyncList;
        }

        @Override
        public List<MotcleSync> getFirstLevelList() {
            return this.firstLevelList;
        }
    }
}

